/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.server.dav.handlers;

import java.util.Collection;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.server.dav.DAVException;
import org.tmatesoft.svn.core.internal.server.dav.DAVRepositoryManager;
import org.tmatesoft.svn.core.internal.server.dav.DAVResource;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVGetLocationsRequest;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVReportHandler;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVRequest;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.util.SVNXMLUtil;
import org.tmatesoft.svn.core.io.SVNLocationEntry;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.util.SVNLogType;

public class DAVGetLocationsHandler
extends DAVReportHandler {
    private static final String GET_LOCATIONS_REPORT = "get-locations-report";
    private DAVGetLocationsRequest myDAVRequest;
    private DAVReportHandler myCommonReportHandler;

    public DAVGetLocationsHandler(DAVRepositoryManager repositoryManager, HttpServletRequest request, HttpServletResponse response, DAVReportHandler commonReportHandler) {
        super(repositoryManager, request, response);
        this.myCommonReportHandler = commonReportHandler;
    }

    @Override
    protected DAVRequest getDAVRequest() {
        return this.getGetLocationsRequest();
    }

    private DAVGetLocationsRequest getGetLocationsRequest() {
        if (this.myDAVRequest == null) {
            this.myDAVRequest = new DAVGetLocationsRequest();
        }
        return this.myDAVRequest;
    }

    @Override
    public void execute() throws SVNException {
        this.myCommonReportHandler.checkSVNNamespace(null);
        this.setDAVResource(this.getRequestedDAVResource(false, false));
        DAVResource resource = this.getDAVResource();
        DAVGetLocationsRequest request = this.getGetLocationsRequest();
        String path = request.getPath();
        long pegRevision = request.getPegRevision();
        if (path == null || !SVNRevision.isValidRevisionNumber((long)pegRevision)) {
            throw new DAVException("Not all parameters passed.", 400, SVNLogType.NETWORK, "error", "svn:");
        }
        if (!path.startsWith("/")) {
            path = SVNPathUtil.append((String)resource.getResourceURI().getPath(), (String)path);
        }
        SVNRepository repository = resource.getRepository();
        Collection locations = repository.getLocations(path, (Collection)null, pegRevision, request.getRevisions());
        SVNHashMap attrs = new SVNHashMap();
        this.writeXMLHeader(GET_LOCATIONS_REPORT);
        for (SVNLocationEntry locationEntry : locations) {
            attrs.clear();
            attrs.put("path", locationEntry.getPath());
            attrs.put("rev", String.valueOf(locationEntry.getRevision()));
            StringBuffer xmlBuffer = SVNXMLUtil.openXMLTag((String)"S", (String)"location", (int)4, (Map)attrs, null);
            this.write(xmlBuffer);
        }
        this.writeXMLFooter(GET_LOCATIONS_REPORT);
    }
}

