/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.server.dav.handlers;

import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.io.dav.DAVElement;
import org.tmatesoft.svn.core.internal.io.fs.FSLocationsFinder;
import org.tmatesoft.svn.core.internal.server.dav.DAVException;
import org.tmatesoft.svn.core.internal.server.dav.DAVPathUtil;
import org.tmatesoft.svn.core.internal.server.dav.DAVRepositoryManager;
import org.tmatesoft.svn.core.internal.server.dav.DAVResource;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVElementProperty;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVGetLocationSegmentsRequest;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVReportHandler;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVRequest;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.util.SVNXMLUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.io.ISVNLocationSegmentHandler;
import org.tmatesoft.svn.core.io.SVNLocationSegment;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.util.SVNLogType;

public class DAVGetLocationSegmentsHandler
extends DAVReportHandler
implements ISVNLocationSegmentHandler {
    private static final String GET_LOCATION_SEGMENTS_REPORT = "get-location-segments-report";
    private static final String LOCATION_SEGMENT_TAG = "location-segment";
    private static final String RANGE_START_ATTR = "range-start";
    private static final String RANGE_END_ATTR = "range-end";
    private DAVGetLocationSegmentsRequest myDAVRequest;
    private boolean myIsOpenerSent;
    private DAVReportHandler myCommonReportHandler;

    protected DAVGetLocationSegmentsHandler(DAVRepositoryManager repositoryManager, HttpServletRequest request, HttpServletResponse response, DAVReportHandler commonReportHandler) {
        super(repositoryManager, request, response);
        this.myCommonReportHandler = commonReportHandler;
    }

    @Override
    public void execute() throws SVNException {
        this.myCommonReportHandler.checkSVNNamespace(null);
        DAVResource resource = this.getRequestedDAVResource(false, false);
        this.setDAVResource(resource);
        DAVGetLocationSegmentsRequest request = this.getLocationSegmentsRequest();
        String path = null;
        long startRev = -1L;
        long endRev = -1L;
        long pegRev = -1L;
        DAVElementProperty rootElement = request.getRootElement();
        List children = rootElement.getChildren();
        for (DAVElementProperty childElement : children) {
            DAVElement childElementName = childElement.getName();
            if (!"svn:".equals(childElementName.getNamespace())) continue;
            if (childElementName == DAVElement.PATH) {
                path = childElement.getFirstValue(false);
                DAVPathUtil.testCanonical(path);
                String resourcePath = resource.getResourceURI().getPath();
                path = SVNPathUtil.append((String)resourcePath, (String)path);
                continue;
            }
            if (childElementName == DAVElement.START_REVISION) {
                try {
                    startRev = Long.parseLong(childElement.getFirstValue(true));
                }
                catch (NumberFormatException nfe) {
                    SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.RA_DAV_REQUEST_FAILED, (Throwable)nfe), (SVNLogType)SVNLogType.NETWORK);
                }
                continue;
            }
            if (childElementName == DAVElement.END_REVISION) {
                try {
                    endRev = Long.parseLong(childElement.getFirstValue(true));
                }
                catch (NumberFormatException nfe) {
                    SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.RA_DAV_REQUEST_FAILED, (Throwable)nfe), (SVNLogType)SVNLogType.NETWORK);
                }
                continue;
            }
            if (childElementName != DAVElement.PEG_REVISION) continue;
            try {
                pegRev = Long.parseLong(childElement.getFirstValue(true));
            }
            catch (NumberFormatException nfe) {
                SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.RA_DAV_REQUEST_FAILED, (Throwable)nfe), (SVNLogType)SVNLogType.NETWORK);
            }
        }
        if (path == null) {
            throw new DAVException("Not all parameters passed.", 400, SVNLogType.NETWORK, "error", "svn:");
        }
        if (SVNRevision.isValidRevisionNumber((long)startRev) && SVNRevision.isValidRevisionNumber((long)endRev) && endRev > startRev) {
            throw new DAVException("End revision must not be younger than start revision", 400, SVNLogType.NETWORK, "error", "svn:");
        }
        if (SVNRevision.isValidRevisionNumber((long)pegRev) && SVNRevision.isValidRevisionNumber((long)startRev) && startRev > pegRev) {
            throw new DAVException("Start revision must not be younger than peg revision", 400, SVNLogType.NETWORK, "error", "svn:");
        }
        FSLocationsFinder locationsFinder = new FSLocationsFinder(this.getDAVResource().getFSFS());
        locationsFinder.getNodeLocationSegments(path, pegRev, startRev, endRev, (ISVNLocationSegmentHandler)this);
        try {
            this.maybeSendOpener();
        }
        catch (SVNException svne) {
            throw DAVException.convertError(svne.getErrorMessage(), 500, "Error beginning REPORT reponse", null);
        }
        try {
            this.writeXMLFooter(GET_LOCATION_SEGMENTS_REPORT);
        }
        catch (SVNException svne) {
            throw DAVException.convertError(svne.getErrorMessage(), 500, "Error ending REPORT reponse", null);
        }
    }

    public void handleLocationSegment(SVNLocationSegment locationSegment) throws SVNException {
        this.maybeSendOpener();
        HashMap<String, String> attrs = new HashMap<String, String>();
        String path = locationSegment.getPath();
        if (path != null) {
            path = DAVPathUtil.dropLeadingSlash(path);
            String quotedPath = SVNEncodingUtil.xmlEncodeCDATA((String)path, (boolean)true);
            attrs.put("path", quotedPath);
            attrs.put(RANGE_START_ATTR, String.valueOf(locationSegment.getStartRevision()));
            attrs.put(RANGE_END_ATTR, String.valueOf(locationSegment.getEndRevision()));
        } else {
            attrs.put(RANGE_START_ATTR, String.valueOf(locationSegment.getStartRevision()));
            attrs.put(RANGE_END_ATTR, String.valueOf(locationSegment.getEndRevision()));
        }
        StringBuffer buffer = SVNXMLUtil.openXMLTag((String)"S", (String)LOCATION_SEGMENT_TAG, (int)4, attrs, null);
        this.write(buffer);
    }

    @Override
    protected DAVRequest getDAVRequest() {
        return this.getLocationSegmentsRequest();
    }

    private DAVGetLocationSegmentsRequest getLocationSegmentsRequest() {
        if (this.myDAVRequest == null) {
            this.myDAVRequest = new DAVGetLocationSegmentsRequest();
        }
        return this.myDAVRequest;
    }

    private void maybeSendOpener() throws SVNException {
        if (!this.myIsOpenerSent) {
            this.writeXMLHeader(GET_LOCATION_SEGMENTS_REPORT);
            this.myIsOpenerSent = true;
        }
    }
}

