/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.server.dav.handlers;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.server.dav.DAVRepositoryManager;
import org.tmatesoft.svn.core.internal.server.dav.DAVResource;
import org.tmatesoft.svn.core.internal.server.dav.DAVResourceType;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVRequest;
import org.tmatesoft.svn.core.internal.server.dav.handlers.ServletDAVHandler;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.util.SVNLogType;

public class DAVGetHandler
extends ServletDAVHandler {
    public DAVGetHandler(DAVRepositoryManager connector, HttpServletRequest request, HttpServletResponse response) {
        super(connector, request, response);
    }

    @Override
    public void execute() throws SVNException {
        DAVResource resource = this.getRequestedDAVResource(true, false);
        if (!resource.exists()) {
            SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.RA_DAV_PATH_NOT_FOUND, (String)"Path ''{0}'' you requested not found", (Object)resource.getResourceURI().getPath()), (SVNLogType)SVNLogType.NETWORK);
        }
        if (resource.getResourceURI().getType() != DAVResourceType.REGULAR && resource.getResourceURI().getType() != DAVResourceType.VERSION && resource.getResourceURI().getType() != DAVResourceType.WORKING) {
            SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.RA_DAV_MALFORMED_DATA, (String)"Cannot GET this type of resource."), (SVNLogType)SVNLogType.NETWORK);
        }
        this.setDefaultResponseHeaders();
        this.setResponseHeaders(resource);
        try {
            this.checkPreconditions(resource.getETag(), resource.getLastModified());
        }
        catch (SVNException sVNException) {
            // empty catch block
        }
        if (resource.isCollection()) {
            StringBuilder body = new StringBuilder();
            this.getConfig().getCollectionRenderer().renderCollection(body, resource);
            String responseBody = body.toString();
            try {
                this.setResponseContentLength(responseBody.getBytes("UTF-8").length);
            }
            catch (UnsupportedEncodingException e) {
                this.setResponseContentLength(responseBody.getBytes().length);
            }
            try {
                this.getResponseWriter().write(responseBody);
            }
            catch (IOException e) {
                SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.RA_DAV_REQUEST_FAILED, (Throwable)e), (Throwable)e, (SVNLogType)SVNLogType.NETWORK);
            }
        } else if (resource.getDeltaBase() == null) {
            resource.writeTo(this.getResponseOutputStream());
        }
    }

    @Override
    protected DAVRequest getDAVRequest() {
        return null;
    }

    @Override
    protected int checkPreconditions(String eTag, Date lastModified) {
        super.checkPreconditions(eTag, lastModified);
        lastModified = lastModified == null ? new Date() : lastModified;
        boolean isNotModified = false;
        Enumeration ifNoneMatch = this.getRequestHeaders("If-None-Match");
        if (ifNoneMatch != null && ifNoneMatch.hasMoreElements() && eTag != null) {
            isNotModified = this.getRequestHeaders("Range") != null && this.getRequestHeaders("Range").hasMoreElements() ? !eTag.startsWith("W") && this.containsValue(ifNoneMatch, eTag, "*") : this.containsValue(ifNoneMatch, eTag, "*");
        }
        long ifModified = this.getRequestDateHeader("If-Modified-Since");
        long date = this.getRequestDateHeader("Date");
        if ((isNotModified || ifNoneMatch == null || !ifNoneMatch.hasMoreElements()) && ifModified != -1L && date != -1L) {
            boolean bl = isNotModified = ifModified >= lastModified.getTime() && ifModified <= date;
        }
        if (isNotModified) {
            // empty if block
        }
        return 0;
    }

    private void setResponseHeaders(DAVResource resource) {
        try {
            this.setResponseContentType(resource.getContentType());
        }
        catch (SVNException sVNException) {
            // empty catch block
        }
        this.setResponseHeader("Accept-Ranges", "bytes");
        try {
            Date lastModifiedTime = resource.getLastModified();
            if (lastModifiedTime != null) {
                this.setResponseHeader("Last-Modified", SVNDate.formatRFC1123Date((Date)lastModifiedTime));
            }
        }
        catch (SVNException lastModifiedTime) {
            // empty catch block
        }
        String eTag = resource.getETag();
        if (eTag != null) {
            this.setResponseHeader("ETag", eTag);
        }
    }
}

