/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.server.dav.handlers;

import java.util.List;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.io.dav.DAVElement;
import org.tmatesoft.svn.core.internal.server.dav.DAVPathUtil;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVElementProperty;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVRequest;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.util.SVNLogType;

public class DAVGetDeletedRevisionRequest
extends DAVRequest {
    private long myPegRevision;
    private long myEndRevision;
    private String myPath;

    public long getPegRevision() {
        return this.myPegRevision;
    }

    public long getEndRevision() {
        return this.myEndRevision;
    }

    public String getPath() {
        return this.myPath;
    }

    @Override
    protected void init() throws SVNException {
        DAVElementProperty rootElement = this.getRootElement();
        List rootChildren = rootElement.getChildren();
        if (rootChildren != null) {
            for (DAVElementProperty childElement : rootChildren) {
                DAVElement childElementName = childElement.getName();
                if (!"svn:".equals(childElementName.getNamespace())) continue;
                if (childElementName == DAVElement.PEG_REVISION) {
                    try {
                        this.myPegRevision = Long.parseLong(childElement.getFirstValue(true));
                    }
                    catch (NumberFormatException nfe) {
                        SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.RA_DAV_REQUEST_FAILED, (Throwable)nfe), (SVNLogType)SVNLogType.NETWORK);
                    }
                    continue;
                }
                if (childElementName == DAVElement.END_REVISION) {
                    try {
                        this.myEndRevision = Long.parseLong(childElement.getFirstValue(true));
                    }
                    catch (NumberFormatException nfe) {
                        SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.RA_DAV_REQUEST_FAILED, (Throwable)nfe), (SVNLogType)SVNLogType.NETWORK);
                    }
                    continue;
                }
                if (childElementName != DAVElement.PATH) continue;
                String path = childElement.getFirstValue(false);
                DAVPathUtil.testCanonical(path);
                this.myPath = path;
            }
        }
    }
}

