/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.server.dav.handlers;

import java.io.OutputStream;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.server.dav.DAVException;
import org.tmatesoft.svn.core.internal.server.dav.DAVRepositoryManager;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVFileRevisionsRequest;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVReportHandler;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVRequest;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.util.SVNXMLUtil;
import org.tmatesoft.svn.core.io.ISVNFileRevisionHandler;
import org.tmatesoft.svn.core.io.SVNFileRevision;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;

public class DAVFileRevisionsHandler
extends DAVReportHandler
implements ISVNFileRevisionHandler {
    private static final String FILE_REVISION_TAG = "file-rev";
    private static final String REVISION_PROPERTY_TAG = "rev-prop";
    private static final String SET_PROPERTY_TAG = "set-prop";
    private static final String REMOVE_PROPERTY_TAG = "remove-prop";
    private static final String MERGED_REVISION_TAG = "merged-revision";
    private DAVFileRevisionsRequest myDAVRequest;
    private boolean myWriteHeader;
    private DAVReportHandler myCommonReportHandler;

    public DAVFileRevisionsHandler(DAVRepositoryManager repositoryManager, HttpServletRequest request, HttpServletResponse response, DAVReportHandler commonReportHandler) {
        super(repositoryManager, request, response);
        this.myCommonReportHandler = commonReportHandler;
    }

    @Override
    protected DAVRequest getDAVRequest() {
        return this.getFileRevsionsRequest();
    }

    private DAVFileRevisionsRequest getFileRevsionsRequest() {
        if (this.myDAVRequest == null) {
            this.myDAVRequest = new DAVFileRevisionsRequest();
        }
        return this.myDAVRequest;
    }

    @Override
    public void execute() throws SVNException {
        this.myCommonReportHandler.checkSVNNamespace(null);
        this.setDAVResource(this.getRequestedDAVResource(false, false));
        this.myWriteHeader = true;
        String path = SVNPathUtil.append((String)this.getDAVResource().getResourceURI().getPath(), (String)this.getFileRevsionsRequest().getPath());
        try {
            this.getDAVResource().getRepository().getFileRevisions(path, this.getFileRevsionsRequest().getStartRevision(), this.getFileRevsionsRequest().getEndRevision(), this.getFileRevsionsRequest().isIncludeMergedRevisions(), (ISVNFileRevisionHandler)this);
        }
        catch (SVNException svne) {
            throw DAVException.convertError(svne.getErrorMessage(), 500, svne.getErrorMessage().getMessage(), null);
        }
        try {
            this.maybeSendHeader();
        }
        catch (SVNException svne) {
            throw DAVException.convertError(svne.getErrorMessage(), 500, "Error beginning REPORT reponse", null);
        }
        try {
            this.writeXMLFooter(null);
        }
        catch (SVNException svne) {
            throw DAVException.convertError(svne.getErrorMessage(), 500, "Error ending REPORT reponse", null);
        }
    }

    public void openRevision(SVNFileRevision fileRevision) throws SVNException {
        this.maybeSendHeader();
        SVNHashMap attrs = new SVNHashMap();
        attrs.put("path", fileRevision.getPath());
        attrs.put("rev", String.valueOf(fileRevision.getRevision()));
        StringBuffer xmlBuffer = SVNXMLUtil.openXMLTag((String)"S", (String)FILE_REVISION_TAG, (int)1, (Map)attrs, null);
        this.write(xmlBuffer);
        for (String propertyName : fileRevision.getRevisionProperties().nameSet()) {
            this.writePropertyTag(REVISION_PROPERTY_TAG, propertyName, fileRevision.getRevisionProperties().getSVNPropertyValue(propertyName));
        }
        for (String propertyName : fileRevision.getPropertiesDelta().nameSet()) {
            SVNPropertyValue propertyValue = fileRevision.getPropertiesDelta().getSVNPropertyValue(propertyName);
            if (propertyValue != null) {
                this.writePropertyTag(SET_PROPERTY_TAG, propertyName, propertyValue);
                continue;
            }
            xmlBuffer = SVNXMLUtil.openXMLTag((String)"S", (String)REMOVE_PROPERTY_TAG, (int)4, (String)"name", (String)propertyName, null);
            this.write(xmlBuffer);
        }
        if (fileRevision.isResultOfMerge()) {
            xmlBuffer = SVNXMLUtil.openXMLTag((String)"S", (String)MERGED_REVISION_TAG, (int)4, null, null);
            this.write(xmlBuffer);
        }
    }

    public void closeRevision(String token) throws SVNException {
        StringBuffer xmlBuffer = SVNXMLUtil.closeXMLTag((String)"S", (String)FILE_REVISION_TAG, null);
        this.write(xmlBuffer);
    }

    public void applyTextDelta(String path, String baseChecksum) throws SVNException {
        StringBuffer xmlBuffer = SVNXMLUtil.openXMLTag((String)"S", (String)"txdelta", (int)1, null, null);
        this.write(xmlBuffer);
    }

    public OutputStream textDeltaChunk(String path, SVNDiffWindow diffWindow) throws SVNException {
        this.writeTextDeltaChunk(diffWindow);
        return null;
    }

    public void textDeltaEnd(String path) throws SVNException {
        this.textDeltaChunkEnd();
        this.setWriteTextDeltaHeader(true);
        StringBuffer xmlBuffer = SVNXMLUtil.closeXMLTag((String)"S", (String)"txdelta", null);
        this.write(xmlBuffer);
    }

    private void maybeSendHeader() throws SVNException {
        if (this.myWriteHeader) {
            this.writeXMLHeader(null);
            this.myWriteHeader = false;
        }
    }
}

