/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.server.dav.handlers;

import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.server.dav.DAVDepth;
import org.tmatesoft.svn.core.internal.server.dav.DAVException;
import org.tmatesoft.svn.core.internal.server.dav.DAVRepositoryManager;
import org.tmatesoft.svn.core.internal.server.dav.DAVResource;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVDeleteRequest;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVRequest;
import org.tmatesoft.svn.core.internal.server.dav.handlers.ServletDAVHandler;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class DAVDeleteHandler
extends ServletDAVHandler {
    private DAVDeleteRequest myDAVRequest;

    public DAVDeleteHandler(DAVRepositoryManager repositoryManager, HttpServletRequest request, HttpServletResponse response) {
        super(repositoryManager, request, response);
    }

    @Override
    public void execute() throws SVNException {
        this.readInput(false);
        DAVResource resource = this.getRequestedDAVResource(false, false);
        if (!resource.exists()) {
            this.sendError(404, null);
            return;
        }
        DAVDepth depth = this.getRequestDepth(DAVDepth.DEPTH_INFINITY);
        if (resource.isCollection() && depth != DAVDepth.DEPTH_INFINITY) {
            SVNDebugLog.getDefaultLog().logError(SVNLogType.NETWORK, "Depth must be \"infinity\" for DELETE of a collection.");
            this.sendError(400, null);
            return;
        }
        if (!resource.isCollection() && depth == DAVDepth.DEPTH_ONE) {
            SVNDebugLog.getDefaultLog().logError(SVNLogType.NETWORK, "Depth of \"1\" is not allowed for DELETE.");
            this.sendError(400, null);
            return;
        }
        try {
            this.validateRequest(resource, depth, 160, null, null, null);
        }
        catch (DAVException dave) {
            throw new DAVException("Could not DELETE {0} due to a failed precondition (e.g. locks).", new Object[]{SVNEncodingUtil.xmlEncodeCDATA((String)this.getURI())}, dave.getResponseCode(), null, SVNLogType.NETWORK, Level.FINE, dave, null, null, 0, dave.getResponse());
        }
        int respCode = this.unlock(resource, null);
        if (respCode != 200) {
            this.sendError(respCode, null);
            return;
        }
        ServletDAVHandler.DAVAutoVersionInfo avInfo = this.autoCheckOut(resource, true);
        try {
            this.removeResource(resource);
        }
        catch (DAVException dave) {
            this.autoCheckIn(null, true, false, avInfo);
            throw new DAVException("Could not DELETE {0}.", new Object[]{SVNEncodingUtil.xmlEncodeCDATA((String)this.getURI())}, dave.getResponseCode(), dave, 0);
        }
        try {
            this.autoCheckIn(null, false, false, avInfo);
        }
        catch (DAVException dave) {
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "The DELETE was successful, but there was a problem automatically checking in the parent collection.");
        }
        this.setResponseStatus(204);
    }

    @Override
    protected DAVRequest getDAVRequest() {
        if (this.myDAVRequest == null) {
            this.myDAVRequest = new DAVDeleteRequest();
        }
        return this.myDAVRequest;
    }
}

