/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.server.dav.handlers;

import java.net.URI;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.server.dav.DAVDepth;
import org.tmatesoft.svn.core.internal.server.dav.DAVException;
import org.tmatesoft.svn.core.internal.server.dav.DAVRepositoryManager;
import org.tmatesoft.svn.core.internal.server.dav.DAVResource;
import org.tmatesoft.svn.core.internal.server.dav.DAVResourceState;
import org.tmatesoft.svn.core.internal.server.dav.DAVResourceType;
import org.tmatesoft.svn.core.internal.server.dav.DAVServlet;
import org.tmatesoft.svn.core.internal.server.dav.DAVServletUtil;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVLockInfoProvider;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVRequest;
import org.tmatesoft.svn.core.internal.server.dav.handlers.ServletDAVHandler;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class DAVCopyMoveHandler
extends ServletDAVHandler {
    private boolean myIsMove;

    protected DAVCopyMoveHandler(DAVRepositoryManager connector, HttpServletRequest request, HttpServletResponse response, boolean isMove) {
        super(connector, request, response);
        this.myIsMove = isMove;
    }

    @Override
    public void execute() throws SVNException {
        DAVResource dstParentResource;
        DAVResource srcParentResource;
        DAVResource resource = this.getRequestedDAVResource(!this.myIsMove, false);
        if (!resource.exists()) {
            this.sendError(404, null);
            return;
        }
        if (resource.getType() != DAVResourceType.REGULAR) {
            String body = "Cannot COPY/MOVE resource " + SVNEncodingUtil.xmlEncodeCDATA((String)this.getURI()) + ".";
            this.response(body, DAVServlet.getStatusLine(405), 405);
            return;
        }
        String destination = this.getRequestHeader("Destination");
        if (destination == null) {
            String netScapeHost = this.getRequestHeader("Host");
            String netScapeNewURI = this.getRequestHeader("New-uri");
            if (netScapeHost != null && netScapeNewURI != null) {
                String path = SVNPathUtil.append((String)netScapeHost, (String)netScapeNewURI);
                if (path.startsWith("/")) {
                    path = path.substring(1);
                }
                destination = "http://" + path;
            }
        }
        if (destination == null) {
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "The request is missing a Destination header.");
            this.sendError(400, null);
            return;
        }
        URI uri = null;
        try {
            uri = DAVServletUtil.lookUpURI(destination, this.getRequest(), true);
        }
        catch (DAVException dave) {
            if (dave.getResponseCode() == 400) {
                throw dave;
            }
            this.response(dave.getMessage(), DAVServlet.getStatusLine(dave.getResponseCode()), dave.getResponseCode());
        }
        String path = uri.getPath();
        DAVRepositoryManager manager = this.getRepositoryManager();
        String resourceContext = manager.getResourceContext();
        if (!path.startsWith(resourceContext)) {
            throw new DAVException("Destination url starts with a wrong context", 400, 0);
        }
        path = path.substring(resourceContext.length());
        DAVResource newResource = this.getRequestedDAVResource(false, false, path);
        int overwrite = this.getOverwrite();
        if (overwrite < 0) {
            this.sendError(400, null);
            return;
        }
        if (newResource.exists() && overwrite == 0) {
            this.response("Destination is not empty and Overwrite is not \"T\"", DAVServlet.getStatusLine(412), 412);
            return;
        }
        if (resource.equals(newResource)) {
            this.response("Source and Destination URIs are the same.", DAVServlet.getStatusLine(403), 403);
            return;
        }
        boolean isDir = resource.isCollection();
        DAVDepth depth = null;
        try {
            depth = this.getRequestDepth(DAVDepth.DEPTH_INFINITY);
        }
        catch (SVNException svne) {
            throw DAVException.convertError(svne.getErrorMessage(), 400, null, null);
        }
        if (depth == DAVDepth.DEPTH_ONE) {
            this.sendError(400, null);
            return;
        }
        if (this.myIsMove && isDir && depth != DAVDepth.DEPTH_INFINITY) {
            this.sendError(400, null);
            return;
        }
        if (this.myIsMove) {
            try {
                this.validateRequest(resource, depth, 160, null, null, null);
            }
            catch (DAVException dave) {
                throw new DAVException("Could not MOVE {0} due to a failed precondition on the source (e.g. locks).", new Object[]{SVNEncodingUtil.xmlEncodeCDATA((String)this.getURI())}, dave.getResponseCode(), null, SVNLogType.NETWORK, Level.FINE, dave, null, null, 0, dave.getResponse());
            }
        }
        try {
            this.validateRequest(newResource, DAVDepth.DEPTH_INFINITY, 160, null, null, null);
        }
        catch (DAVException dave) {
            throw new DAVException("Could not MOVE/COPY {0} due to a failed precondition on the destination (e.g. locks).", new Object[]{SVNEncodingUtil.xmlEncodeCDATA((String)this.getURI())}, dave.getResponseCode(), null, SVNLogType.NETWORK, Level.FINE, dave, null, null, 0, dave.getResponse());
        }
        if (isDir && depth == DAVDepth.DEPTH_INFINITY && resource.isParentResource(newResource)) {
            this.response("Source collection contains the Destination.", DAVServlet.getStatusLine(403), 403);
            return;
        }
        if (isDir && newResource.isParentResource(newResource)) {
            this.response("Destination collection contains the Source and Overwrite has been specified.", DAVServlet.getStatusLine(403), 403);
            return;
        }
        this.readInput(true);
        DAVLockInfoProvider lockProvider = null;
        try {
            lockProvider = DAVLockInfoProvider.createLockInfoProvider(this, false);
        }
        catch (SVNException svne) {
            throw DAVException.convertError(svne.getErrorMessage(), 500, null, null);
        }
        if (this.myIsMove) {
            this.unlock(resource, null);
        }
        ServletDAVHandler.DAVAutoVersionInfo srcAVInfo = null;
        if (this.myIsMove) {
            srcAVInfo = this.autoCheckOut(resource, true);
        }
        boolean replaceDestination = false;
        DAVResourceState resNewState = this.getResourceState(newResource);
        if (newResource.exists()) {
            if (this.myIsMove || !newResource.isVersioned()) {
                replaceDestination = true;
            } else if (resource.getType() != newResource.getType()) {
                replaceDestination = true;
            } else if (resource.isCollection() != newResource.isCollection()) {
                replaceDestination = true;
            }
        }
        ServletDAVHandler.DAVAutoVersionInfo dstAVInfo = null;
        if (!newResource.exists() || replaceDestination) {
            try {
                dstAVInfo = this.autoCheckOut(newResource, true);
            }
            catch (DAVException dave) {
                if (this.myIsMove) {
                    this.autoCheckIn(null, true, false, srcAVInfo);
                }
                throw dave;
            }
        }
        if (srcAVInfo != null && srcAVInfo.getParentResource() != null && dstAVInfo != null && dstAVInfo.getParentResource() != null && (srcParentResource = srcAVInfo.getParentResource()).equals(dstParentResource = dstAVInfo.getParentResource())) {
            dstAVInfo.setParentResource(srcAVInfo.getParentResource());
        }
        DAVException err1 = null;
        if (replaceDestination) {
            try {
                this.removeResource(newResource);
            }
            catch (DAVException dave) {
                err1 = dave;
            }
        }
        if (err1 == null) {
            if (this.myIsMove) {
                try {
                    this.moveResource(resource, newResource);
                }
                catch (DAVException dave) {
                    err1 = dave;
                }
            } else {
                try {
                    this.copyResource(resource, newResource);
                }
                catch (DAVException dave) {
                    err1 = dave;
                }
            }
        }
        DAVException err2 = null;
        try {
            this.autoCheckIn(null, err1 != null, false, dstAVInfo);
        }
        catch (DAVException dave) {
            err2 = dave;
        }
        DAVException err3 = null;
        if (this.myIsMove) {
            try {
                this.autoCheckIn(null, err1 != null, false, srcAVInfo);
            }
            catch (DAVException dave) {
                err3 = dave;
            }
        }
        if (err1 != null) {
            throw new DAVException("Could not MOVE/COPY {0}.", new Object[]{SVNEncodingUtil.xmlEncodeCDATA((String)this.getURI())}, err1.getResponseCode(), err1, 0);
        }
        if (err2 != null) {
            // empty if block
        }
        if (err3 != null) {
            // empty if block
        }
        try {
            this.notifyCreated(newResource, lockProvider, resNewState, depth);
        }
        catch (DAVException dave) {
            throw new DAVException("The MOVE/COPY was successful, but there was a problem updating the lock information.", null, dave.getResponseCode(), dave, 0);
        }
        this.handleDAVCreated(uri.toString(), "Destination", resNewState == DAVResourceState.EXISTS);
    }

    protected int getOverwrite() {
        String overwriteValue = this.getRequestHeader("Overwrite");
        if (overwriteValue == null) {
            return 1;
        }
        if ((overwriteValue = overwriteValue.toLowerCase()).length() == 1 && overwriteValue.charAt(0) == 'f') {
            return 0;
        }
        if (overwriteValue.length() == 1 && overwriteValue.charAt(0) == 't') {
            return 1;
        }
        return -1;
    }

    @Override
    protected DAVRequest getDAVRequest() {
        return null;
    }
}

