/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.server.dav;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.tmatesoft.svn.core.internal.io.dav.DAVElement;
import org.tmatesoft.svn.core.internal.server.dav.DAVServlet;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVPropsResult;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVResponse;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNXMLUtil;

public class DAVXMLUtil
extends SVNXMLUtil {
    public static final String SVN_DAV_ERROR_TAG = "error";

    public static StringBuffer addEmptyElement(List namespaces, DAVElement element, StringBuffer target) {
        if (element.getNamespace() == null || "".equals(element.getNamespace())) {
            target.append("<");
            target.append(element.getName());
            target.append("/>");
            target.append('\n');
            return target;
        }
        int index = namespaces.indexOf(element.getNamespace());
        target.append("<ns");
        target.append(index);
        target.append(":");
        target.append(element.getName());
        target.append("/>");
        return target;
    }

    public static StringBuffer openNamespaceDeclarationTag(String prefix, String header, Collection namespaces, StringBuffer target, boolean useIndexedPrefixes) {
        return DAVXMLUtil.openNamespaceDeclarationTag(prefix, header, namespaces, null, target, true, useIndexedPrefixes);
    }

    public static StringBuffer openNamespaceDeclarationTag(String prefix, String header, Collection namespaces, Map attrs, StringBuffer target, boolean addEOL, boolean useIndexedPrefixes) {
        target = target == null ? new StringBuffer() : target;
        target.append("<");
        target.append(prefix);
        target.append(":");
        target.append(header);
        target.append(" xmlns:");
        target.append("D");
        target.append("=\"");
        target.append("DAV:");
        target.append("\"");
        if (namespaces != null && !namespaces.isEmpty()) {
            ArrayList<String> usedNamespaces = new ArrayList<String>();
            usedNamespaces.add("DAV:");
            int i = 0;
            for (Object item : namespaces) {
                String currentNamespace = null;
                if (item instanceof DAVElement) {
                    DAVElement currentElement = (DAVElement)item;
                    currentNamespace = currentElement.getNamespace();
                } else if (item instanceof String) {
                    currentNamespace = (String)item;
                }
                if (currentNamespace != null && currentNamespace.length() > 0 && (useIndexedPrefixes || !usedNamespaces.contains(currentNamespace))) {
                    usedNamespaces.add(currentNamespace);
                    target.append(" xmlns:");
                    if (useIndexedPrefixes) {
                        target.append("ns" + i);
                    } else {
                        target.append(PREFIX_MAP.get(currentNamespace));
                    }
                    target.append("=\"");
                    target.append(currentNamespace);
                    target.append("\"");
                }
                ++i;
            }
            usedNamespaces.clear();
        }
        if (attrs != null && !attrs.isEmpty()) {
            for (Map.Entry entry : attrs.entrySet()) {
                String name = (String)entry.getKey();
                String value = (String)entry.getValue();
                target.append(" ");
                target.append(name);
                target.append("=\"");
                target.append(SVNEncodingUtil.xmlEncodeAttr((String)value));
                target.append("\"");
            }
        }
        target.append(">");
        if (addEOL) {
            target.append('\n');
        }
        return target;
    }

    public static StringBuffer beginMultiStatus(HttpServletResponse servletResponse, int status, Collection namespaces, StringBuffer xmlBuffer) {
        servletResponse.setContentType("text/xml; charset=\"utf-8\"");
        servletResponse.setStatus(status);
        xmlBuffer = xmlBuffer == null ? new StringBuffer() : xmlBuffer;
        SVNXMLUtil.addXMLHeader((StringBuffer)xmlBuffer);
        DAVXMLUtil.openNamespaceDeclarationTag("D", DAVElement.MULTISTATUS.getName(), namespaces, xmlBuffer, namespaces != null);
        return xmlBuffer;
    }

    public static void sendMultiStatus(DAVResponse davResponse, HttpServletResponse servletResponse, int statusCode, Collection namespaces) throws IOException {
        StringBuffer xmlBuffer = new StringBuffer();
        xmlBuffer = DAVXMLUtil.beginMultiStatus(servletResponse, statusCode, namespaces, xmlBuffer);
        while (davResponse != null) {
            DAVXMLUtil.sendOneResponse(davResponse, xmlBuffer);
            davResponse = davResponse.getNextResponse();
        }
        SVNXMLUtil.closeXMLTag((String)"D", (String)DAVElement.MULTISTATUS.getName(), (StringBuffer)xmlBuffer);
        servletResponse.getWriter().write(xmlBuffer.toString());
    }

    public static void sendOneResponse(DAVResponse davResponse, StringBuffer xmlBuffer) {
        DAVPropsResult propResult = davResponse.getPropResult();
        Collection namespaces = propResult.getNamespaces();
        if (namespaces == null || namespaces.isEmpty()) {
            SVNXMLUtil.openXMLTag((String)"D", (String)DAVElement.RESPONSE.getName(), (int)2, null, (StringBuffer)xmlBuffer);
        } else {
            xmlBuffer.append('<');
            xmlBuffer.append("D");
            xmlBuffer.append(':');
            xmlBuffer.append(DAVElement.RESPONSE.getName());
            for (String namespaceText : namespaces) {
                xmlBuffer.append(namespaceText);
            }
            xmlBuffer.append(">\n");
        }
        String href = davResponse.getHref();
        SVNXMLUtil.openCDataTag((String)"D", (String)DAVElement.HREF.getName(), (String)href, null, (boolean)true, (boolean)true, (StringBuffer)xmlBuffer);
        String propStatsText = propResult.getPropStatsText();
        if (propStatsText == null || propStatsText.length() == 0) {
            String statusLine = "HTTP/1.1 " + DAVServlet.getStatusLine(davResponse.getStatusCode());
            SVNXMLUtil.openCDataTag((String)"D", (String)DAVElement.STATUS.getName(), (String)statusLine, null, (boolean)false, (boolean)false, (StringBuffer)xmlBuffer);
        } else {
            xmlBuffer.append(propStatsText);
        }
        if (davResponse.getDescription() != null) {
            SVNXMLUtil.openCDataTag((String)"D", (String)DAVElement.RESPONSE_DESCRIPTION.getName(), (String)davResponse.getDescription(), null, (boolean)false, (boolean)false, (StringBuffer)xmlBuffer);
        }
        SVNXMLUtil.closeXMLTag((String)"D", (String)DAVElement.RESPONSE.getName(), (StringBuffer)xmlBuffer);
    }
}

