/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.server.dav;

import java.util.logging.Level;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.io.fs.FSFS;
import org.tmatesoft.svn.core.internal.io.fs.FSRoot;
import org.tmatesoft.svn.core.internal.io.fs.FSTransactionInfo;
import org.tmatesoft.svn.core.internal.io.fs.FSTransactionRoot;
import org.tmatesoft.svn.core.internal.server.dav.DAVException;
import org.tmatesoft.svn.core.internal.server.dav.DAVPrivateResourceHelper;
import org.tmatesoft.svn.core.internal.server.dav.DAVResource;
import org.tmatesoft.svn.core.internal.server.dav.DAVResourceHelper;
import org.tmatesoft.svn.core.internal.server.dav.DAVResourceKind;
import org.tmatesoft.svn.core.internal.server.dav.DAVResourceType;
import org.tmatesoft.svn.core.internal.server.dav.DAVResourceURI;
import org.tmatesoft.svn.core.internal.server.dav.DAVServletUtil;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.util.SVNLogType;

public class DAVWorkingResourceHelper
extends DAVResourceHelper {
    @Override
    protected void prepare(DAVResource resource) throws DAVException {
        String txnName = DAVServletUtil.getTxn(resource.getActivitiesDB(), resource.getResourceURI().getActivityID());
        if (txnName == null) {
            throw new DAVException("An unknown activity was specified in the URL. This is generally caused by a problem in the client software.", null, 400, null, SVNLogType.NETWORK, Level.FINE, null, null, null, 0, null);
        }
        resource.setTxnName(txnName);
        FSFS fsfs = resource.getFSFS();
        FSTransactionInfo txnInfo = null;
        try {
            txnInfo = fsfs.openTxn(txnName);
        }
        catch (SVNException svne) {
            if (svne.getErrorMessage().getErrorCode() == SVNErrorCode.FS_NO_SUCH_TRANSACTION) {
                throw new DAVException("An activity was specified and found, but the corresponding SVN FS transaction was not found.", null, 500, null, SVNLogType.NETWORK, Level.FINE, null, null, null, 0, null);
            }
            throw DAVException.convertError(svne.getErrorMessage(), 500, "An activity was specified and found, but the corresponding SVN FS transaction was not found.", null);
        }
        resource.setTxnInfo(txnInfo);
        if (resource.isBaseLined()) {
            resource.setExists(true);
            return;
        }
        String userName = resource.getUserName();
        if (resource.getUserName() != null) {
            SVNProperties props = null;
            try {
                props = fsfs.getTransactionProperties(txnName);
            }
            catch (SVNException svne) {
                throw DAVException.convertError(svne.getErrorMessage(), 500, "Failed to retrieve author of the SVN FS transaction corresponding to the specified activity.", null);
            }
            String currentAuthor = props.getStringValue("svn:author");
            if (currentAuthor == null) {
                try {
                    fsfs.setTransactionProperty(txnName, "svn:author", SVNPropertyValue.create((String)userName));
                }
                catch (SVNException svne) {
                    throw DAVException.convertError(svne.getErrorMessage(), 500, "Failed to set the author of the SVN FS transaction corresponding to the specified activity.", null);
                }
            } else if (!currentAuthor.equals(userName)) {
                throw new DAVException("Multi-author commits not supported.", null, 501, null, SVNLogType.NETWORK, Level.FINE, null, null, null, 0, null);
            }
        }
        FSTransactionRoot root = null;
        try {
            root = fsfs.createTransactionRoot(txnInfo);
            resource.setRoot((FSRoot)root);
        }
        catch (SVNException svne) {
            throw DAVException.convertError(svne.getErrorMessage(), 500, "Could not open the (transaction) root of the repository", null);
        }
        SVNNodeKind kind = DAVServletUtil.checkPath((FSRoot)root, resource.getResourceURI().getPath());
        resource.setExists(kind != SVNNodeKind.NONE);
        resource.setCollection(kind == SVNNodeKind.DIR);
    }

    @Override
    protected DAVResource getParentResource(DAVResource resource) throws DAVException {
        return DAVPrivateResourceHelper.createPrivateResource(resource, DAVResourceKind.WORKING);
    }

    public static DAVResource createWorkingResource(DAVResource baseResource, String activityID, String txnName, boolean inPlace) {
        StringBuffer pathBuffer = new StringBuffer();
        if (baseResource.isBaseLined()) {
            pathBuffer.append('/');
            pathBuffer.append("!svn");
            pathBuffer.append("/wbl/");
            pathBuffer.append(activityID);
            pathBuffer.append('/');
            pathBuffer.append(baseResource.getRevision());
        } else {
            pathBuffer.append('/');
            pathBuffer.append("!svn");
            pathBuffer.append("/wrk/");
            pathBuffer.append(activityID);
            pathBuffer.append(baseResource.getResourceURI().getPath());
        }
        String uriPath = SVNEncodingUtil.uriEncode((String)pathBuffer.toString());
        DAVResource resource = null;
        if (inPlace) {
            resource = baseResource;
        } else {
            resource = new DAVResource();
            baseResource.copyTo(resource);
        }
        resource.setTxnName(txnName);
        resource.setExists(true);
        resource.setVersioned(true);
        resource.setWorking(true);
        DAVResourceURI uri = resource.getResourceURI();
        uri.setType(DAVResourceType.WORKING);
        uri.setURI(uriPath);
        uri.setActivityID(activityID);
        return resource;
    }
}

