/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.server.dav;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.LinkedList;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.io.fs.FSCommitter;
import org.tmatesoft.svn.core.internal.io.fs.FSFS;
import org.tmatesoft.svn.core.internal.io.fs.FSID;
import org.tmatesoft.svn.core.internal.io.fs.FSNodeHistory;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionNode;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionRoot;
import org.tmatesoft.svn.core.internal.io.fs.FSRoot;
import org.tmatesoft.svn.core.internal.io.fs.FSTransactionInfo;
import org.tmatesoft.svn.core.internal.io.fs.FSTransactionRoot;
import org.tmatesoft.svn.core.internal.server.dav.DAVException;
import org.tmatesoft.svn.core.internal.server.dav.DAVIFHeader;
import org.tmatesoft.svn.core.internal.server.dav.DAVIFState;
import org.tmatesoft.svn.core.internal.server.dav.DAVIFStateType;
import org.tmatesoft.svn.core.internal.server.dav.DAVPathUtil;
import org.tmatesoft.svn.core.internal.server.dav.DAVResource;
import org.tmatesoft.svn.core.internal.server.dav.DAVResourceType;
import org.tmatesoft.svn.core.internal.server.dav.DAVResourceURI;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.util.SVNLogType;

public class DAVServletUtil {
    public static final String HEADER_FORWARDHOST = "X-Forwarded-Host";

    public static long getSafeCreatedRevision(FSRevisionRoot root, String path) {
        long revision = root.getRevision();
        FSFS fsfs = root.getOwner();
        FSID id = null;
        try {
            FSRevisionNode node = root.getRevisionNode(path);
            id = node.getId();
        }
        catch (SVNException svne) {
            return revision;
        }
        FSNodeHistory history = null;
        long historyRev = -1L;
        try {
            history = root.getNodeHistory(path);
            history = history.getPreviousHistory(false);
            historyRev = history.getHistoryEntry().getRevision();
        }
        catch (SVNException svne) {
            return revision;
        }
        FSRevisionRoot otherRoot = null;
        try {
            otherRoot = fsfs.createRevisionRoot(historyRev);
        }
        catch (SVNException svne) {
            return revision;
        }
        FSID otherID = null;
        try {
            FSRevisionNode node = otherRoot.getRevisionNode(path);
            otherID = node.getId();
        }
        catch (SVNException svne) {
            return revision;
        }
        if (id.compareTo(otherID) == 0) {
            return historyRev;
        }
        return revision;
    }

    public static URI lookUpURI(String uri, HttpServletRequest request, boolean mustBeAbsolute) throws DAVException {
        int domainInd;
        URI parsedURI = null;
        try {
            parsedURI = new URI(uri);
        }
        catch (URISyntaxException urise) {
            throw new DAVException("Invalid syntax in Destination URI.", 400, 0);
        }
        if (parsedURI.getScheme() == null && mustBeAbsolute) {
            throw new DAVException("Destination URI must be an absolute URI.", 400, 0);
        }
        if (parsedURI.getQuery() != null || parsedURI.getFragment() != null) {
            throw new DAVException("Destination URI contains invalid components (a query or a fragment).", 400, 0);
        }
        String serverHost = request.getServerName();
        String forwardedHost = request.getHeader(HEADER_FORWARDHOST);
        if (forwardedHost == null || forwardedHost.length() == 0) {
            if (parsedURI.getScheme() != null || parsedURI.getPort() != -1 || mustBeAbsolute) {
                String scheme = request.getScheme();
                if (scheme == null) {
                    scheme = "http";
                }
                int parsedPort = parsedURI.getPort();
                if (parsedURI.getPort() == -1) {
                    parsedPort = request.getServerPort();
                }
                if (!scheme.equals(parsedURI.getScheme()) || parsedPort != request.getServerPort()) {
                    throw new DAVException("Destination URI refers to different scheme or port ({0}://hostname:{1})\n(want: {2}://hostname:{3})", new Object[]{parsedURI.getScheme() != null ? parsedURI.getScheme() : scheme, String.valueOf(parsedPort), scheme, String.valueOf(request.getServerPort())}, 400, 0);
                }
            }
        } else {
            serverHost = forwardedHost;
        }
        String parsedHost = parsedURI.getHost();
        String domain = null;
        int n = domainInd = serverHost != null ? serverHost.indexOf(46) : -1;
        if (domainInd != -1) {
            domain = serverHost.substring(domainInd);
        }
        if (parsedHost != null && parsedHost.indexOf(46) == -1 && domain != null) {
            parsedHost = parsedHost + domain;
        }
        serverHost = DAVServletUtil.removeUsernameFromHost(serverHost);
        if (parsedHost != null && !parsedHost.equals(serverHost)) {
            throw new DAVException("Destination URI refers to a different server.", 502, 0);
        }
        return parsedURI;
    }

    private static String removeUsernameFromHost(String host) {
        String result = host;
        int at = host.indexOf(64);
        if (at >= 0 && at + 1 < host.length()) {
            result = host.substring(at + 1);
        }
        return result;
    }

    public static void setAutoRevisionProperties(DAVResource resource) throws DAVException {
        if (resource.getType() != DAVResourceType.WORKING || !resource.isAutoCheckedOut()) {
            throw new DAVException("Set_auto_revprops called on invalid resource.", 500, 0);
        }
        try {
            DAVServletUtil.attachAutoRevisionProperties(resource.getTxnInfo(), resource.getResourceURI().getPath(), resource.getFSFS());
        }
        catch (SVNException svne) {
            throw DAVException.convertError(svne.getErrorMessage(), 500, "Error setting a revision property ", null);
        }
    }

    public static void attachAutoRevisionProperties(FSTransactionInfo txn, String path, FSFS fsfs) throws SVNException {
        String logMessage = "Autoversioning commit:  a non-deltaV client made a change to\n" + path;
        SVNProperties props = new SVNProperties();
        props.put("svn:log", logMessage);
        props.put("svn:autoversioned", "*");
        fsfs.changeTransactionProperties(txn.getTxnId(), props);
    }

    public static void deleteActivity(DAVResource resource, String activityID) throws DAVException {
        File activitiesDB = resource.getActivitiesDB();
        String txnName = DAVServletUtil.getTxn(activitiesDB, activityID);
        if (txnName == null) {
            throw new DAVException("could not find activity.", 404, 0);
        }
        FSFS fsfs = resource.getFSFS();
        FSTransactionInfo txn = null;
        if (txnName != null) {
            block9: {
                try {
                    txn = fsfs.openTxn(txnName);
                }
                catch (SVNException svne) {
                    if (svne.getErrorMessage().getErrorCode() == SVNErrorCode.FS_NO_SUCH_TRANSACTION) break block9;
                    throw DAVException.convertError(svne.getErrorMessage(), 500, "could not open transaction.", null);
                }
            }
            if (txn != null) {
                try {
                    FSCommitter.abortTransaction((FSFS)fsfs, (String)txn.getTxnId());
                }
                catch (SVNException svne) {
                    throw DAVException.convertError(svne.getErrorMessage(), 500, "could not abort transaction.", null);
                }
            }
        }
        try {
            SVNFileUtil.deleteFile((File)DAVPathUtil.getActivityPath(activitiesDB, activityID));
        }
        catch (SVNException svne) {
            throw DAVException.convertError(svne.getErrorMessage(), 500, "unable to remove activity.", null);
        }
    }

    public static void storeActivity(DAVResource resource, String txnName) throws DAVException {
        DAVResourceURI resourceURI = resource.getResourceURI();
        String activityID = resourceURI.getActivityID();
        File activitiesDB = resource.getActivitiesDB();
        if (!activitiesDB.exists() && !activitiesDB.mkdirs()) {
            throw new DAVException("could not initialize activity db.", null, 500, null, SVNLogType.NETWORK, Level.FINE, null, null, null, 0, null);
        }
        File finalActivityFile = DAVPathUtil.getActivityPath(activitiesDB, activityID);
        File tmpFile = null;
        try {
            tmpFile = SVNFileUtil.createUniqueFile((File)finalActivityFile.getParentFile(), (String)finalActivityFile.getName(), (String)"tmp", (boolean)false);
        }
        catch (SVNException svne) {
            SVNErrorMessage err = svne.getErrorMessage().wrap("Can't open activity db");
            throw DAVException.convertError(err, 500, "could not open files.", null);
        }
        StringBuffer activitiesContents = new StringBuffer();
        activitiesContents.append(txnName);
        activitiesContents.append('\n');
        activitiesContents.append(activityID);
        activitiesContents.append('\n');
        try {
            SVNFileUtil.writeToFile((File)tmpFile, (String)activitiesContents.toString(), null);
        }
        catch (SVNException svne) {
            SVNErrorMessage err = svne.getErrorMessage().wrap("Can't write to activity db");
            try {
                SVNFileUtil.deleteFile((File)tmpFile);
            }
            catch (SVNException sVNException) {
                // empty catch block
            }
            throw DAVException.convertError(err, 500, "could not write files.", null);
        }
        try {
            SVNFileUtil.rename((File)tmpFile, (File)finalActivityFile);
        }
        catch (SVNException svne) {
            try {
                SVNFileUtil.deleteFile((File)tmpFile);
            }
            catch (SVNException sVNException) {
                // empty catch block
            }
            throw DAVException.convertError(svne.getErrorMessage(), 500, "could not replace files.", null);
        }
    }

    public static FSTransactionInfo createActivity(DAVResource resource, FSFS fsfs) throws DAVException {
        SVNProperties properties = new SVNProperties();
        properties.put("svn:author", resource.getUserName());
        long revision = -1L;
        try {
            revision = fsfs.getYoungestRevision();
        }
        catch (SVNException svne) {
            throw DAVException.convertError(svne.getErrorMessage(), 500, "could not determine youngest revision", null);
        }
        FSTransactionInfo txnInfo = null;
        try {
            txnInfo = FSTransactionRoot.beginTransactionForCommit((long)revision, (SVNProperties)properties, (FSFS)fsfs);
        }
        catch (SVNException svne) {
            throw DAVException.convertError(svne.getErrorMessage(), 500, "could not begin a transaction", null);
        }
        return txnInfo;
    }

    public static LinkedList processIfHeader(String value) throws DAVException {
        if (value == null) {
            return null;
        }
        StringBuffer valueBuffer = new StringBuffer(value);
        ListType listType = ListType.UNKNOWN;
        String uri = null;
        LinkedList<DAVIFHeader> ifHeaders = new LinkedList<DAVIFHeader>();
        DAVIFHeader ifHeader = null;
        while (valueBuffer.length() > 0) {
            if (valueBuffer.charAt(0) == '<') {
                if (listType == ListType.NO_TAGGED || (uri = DAVServletUtil.fetchNextToken(valueBuffer, '>')) == null) {
                    throw new DAVException("Invalid If-header: unclosed \"<\" or unexpected tagged-list production.", 400, 104);
                }
                URI parsedURI = null;
                try {
                    parsedURI = new URI(uri);
                }
                catch (URISyntaxException urise) {
                    throw new DAVException("Invalid URI in tagged If-header.", 400, 104);
                }
                uri = parsedURI.getPath();
                uri = uri.length() > 1 && uri.endsWith("/") ? uri.substring(0, uri.length() - 1) : uri;
                listType = ListType.TAGGED;
            } else if (valueBuffer.charAt(0) == '(') {
                if (listType == ListType.UNKNOWN) {
                    listType = ListType.NO_TAGGED;
                }
                StringBuffer listBuffer = null;
                String list = null;
                list = DAVServletUtil.fetchNextToken(valueBuffer, ')');
                if (list == null) {
                    throw new DAVException("Invalid If-header: unclosed \"(\".", 400, 105);
                }
                ifHeader = new DAVIFHeader(uri);
                ifHeaders.addFirst(ifHeader);
                int condition = 0;
                String stateToken = null;
                listBuffer = new StringBuffer(list);
                while (listBuffer.length() > 0) {
                    if (listBuffer.charAt(0) == '<') {
                        stateToken = DAVServletUtil.fetchNextToken(listBuffer, '>');
                        if (stateToken == null) {
                            throw new DAVException(null, 400, 100);
                        }
                        DAVServletUtil.addIfState(stateToken, DAVIFStateType.IF_OPAQUE_LOCK, condition, ifHeader);
                        condition = 0;
                    } else if (listBuffer.charAt(0) == '[') {
                        stateToken = DAVServletUtil.fetchNextToken(listBuffer, ']');
                        if (stateToken == null) {
                            throw new DAVException(null, 400, 100);
                        }
                        DAVServletUtil.addIfState(stateToken, DAVIFStateType.IF_ETAG, condition, ifHeader);
                        condition = 0;
                    } else if (listBuffer.charAt(0) == 'N') {
                        if (listBuffer.length() > 2 && listBuffer.charAt(1) == 'o' && listBuffer.charAt(2) == 't') {
                            if (condition != 0) {
                                throw new DAVException("Invalid \"If:\" header: Multiple \"not\" entries for the same state.", 400, 101);
                            }
                            condition = 1;
                        }
                        listBuffer.delete(0, 2);
                    } else if (listBuffer.charAt(0) != ' ' && listBuffer.charAt(0) != '\t') {
                        throw new DAVException("Invalid \"If:\" header: Unexpected character encountered ({0}, ''{1}'').", new Object[]{Integer.toHexString(listBuffer.charAt(0)), new Character(listBuffer.charAt(0))}, 400, 102);
                    }
                    listBuffer.deleteCharAt(0);
                }
            } else if (valueBuffer.charAt(0) != ' ' && valueBuffer.charAt(0) != '\t') {
                throw new DAVException("Invalid \"If:\" header: Unexpected character encountered ({0}, ''{1}'').", new Object[]{Integer.toHexString(valueBuffer.charAt(0)), new Character(valueBuffer.charAt(0))}, 400, 102);
            }
            valueBuffer.deleteCharAt(0);
        }
        return ifHeaders;
    }

    public static FSTransactionInfo openTxn(FSFS fsfs, String txnName) throws DAVException {
        FSTransactionInfo txnInfo = null;
        try {
            txnInfo = fsfs.openTxn(txnName);
        }
        catch (SVNException svne) {
            if (svne.getErrorMessage().getErrorCode() == SVNErrorCode.FS_NO_SUCH_TRANSACTION) {
                throw DAVException.convertError(svne.getErrorMessage(), 500, "The transaction specified by the activity does not exist", null);
            }
            throw DAVException.convertError(svne.getErrorMessage(), 500, "There was a problem opening the transaction specified by this activity.", null);
        }
        return txnInfo;
    }

    public static String getTxn(File activitiesDB, String activityID) {
        File activityFile = DAVPathUtil.getActivityPath(activitiesDB, activityID);
        return DAVServletUtil.readTxn(activityFile);
    }

    public static String readTxn(File activityFile) {
        String txnName = null;
        for (int i = 0; i < 10; ++i) {
            try {
                txnName = SVNFileUtil.readSingleLine((File)activityFile);
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return txnName;
    }

    public static SVNNodeKind checkPath(FSRoot root, String path) throws DAVException {
        try {
            return root.checkNodeKind(path);
        }
        catch (SVNException svne) {
            if (svne.getErrorMessage().getErrorCode() == SVNErrorCode.FS_NOT_DIRECTORY) {
                return SVNNodeKind.NONE;
            }
            throw DAVException.convertError(svne.getErrorMessage(), 500, "Error checking kind of path ''{0}'' in repository", new Object[]{path});
        }
    }

    private static void addIfState(String stateToken, DAVIFStateType type, int condition, DAVIFHeader ifHeader) {
        String eTag = null;
        String lockToken = null;
        if (type == DAVIFStateType.IF_OPAQUE_LOCK) {
            lockToken = stateToken;
        } else {
            eTag = stateToken;
        }
        DAVIFState ifState = new DAVIFState(condition, eTag, lockToken, type);
        ifHeader.addIFState(ifState);
    }

    private static String fetchNextToken(StringBuffer string, char term) {
        String token = string.substring(1);
        token = token.trim();
        int ind = -1;
        ind = token.indexOf(term);
        if (ind == -1) {
            return null;
        }
        token = token.substring(0, ind);
        string.delete(0, string.indexOf(token) + token.length());
        return token;
    }

    public static SVNURL createAbsoluteURL(HttpServletRequest request, String path) throws SVNException {
        if (!path.contains("://")) {
            StringBuilder buffer = new StringBuilder(request.getScheme());
            buffer.append("://").append(request.getServerName());
            buffer.append(":").append(String.valueOf(request.getServerPort()));
            buffer.append(path);
            path = buffer.toString();
        }
        return SVNURL.parseURIEncoded((String)path);
    }

    private static class ListType {
        public static final ListType NO_TAGGED = new ListType();
        public static final ListType TAGGED = new ListType();
        public static final ListType UNKNOWN = new ListType();

        private ListType() {
        }
    }
}

