/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.server.dav;

import java.io.File;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Level;
import org.tmatesoft.svn.core.ISVNDirEntryHandler;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.io.fs.FSFS;
import org.tmatesoft.svn.core.internal.io.fs.FSRepository;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionNode;
import org.tmatesoft.svn.core.internal.io.fs.FSRoot;
import org.tmatesoft.svn.core.internal.io.fs.FSTransactionInfo;
import org.tmatesoft.svn.core.internal.server.dav.DAVAutoVersion;
import org.tmatesoft.svn.core.internal.server.dav.DAVConfig;
import org.tmatesoft.svn.core.internal.server.dav.DAVException;
import org.tmatesoft.svn.core.internal.server.dav.DAVPathUtil;
import org.tmatesoft.svn.core.internal.server.dav.DAVRepositoryManager;
import org.tmatesoft.svn.core.internal.server.dav.DAVResourceHelper;
import org.tmatesoft.svn.core.internal.server.dav.DAVResourceKind;
import org.tmatesoft.svn.core.internal.server.dav.DAVResourceType;
import org.tmatesoft.svn.core.internal.server.dav.DAVResourceURI;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class DAVResource {
    public static final long INVALID_REVISION = -1L;
    public static final String DEFAULT_COLLECTION_CONTENT_TYPE = "text/html; charset=\"utf-8\"";
    public static final String DEFAULT_FILE_CONTENT_TYPE = "text/plain";
    private DAVRepositoryManager myRepositoryManager;
    private DAVResourceURI myResourceURI;
    private FSRepository myRepository;
    private long myRevision;
    private long myVersion;
    private boolean myIsCollection;
    private boolean myIsSVNClient;
    private boolean myIsAutoCheckedOut;
    private String myDeltaBase;
    private String myClientOptions;
    private String myBaseChecksum;
    private String myResultChecksum;
    private String myUserName;
    private SVNProperties mySVNProperties;
    private Collection myDeadProperties;
    private Collection myEntries;
    private File myActivitiesDB;
    private FSFS myFSFS;
    private String myTxnName;
    private FSRoot myRoot;
    private FSTransactionInfo myTxnInfo;
    private Map myClientCapabilities;
    private Collection myLockTokens;

    public DAVResource(SVNRepository repository, DAVRepositoryManager manager, DAVResourceURI resourceURI, boolean isSVNClient, String deltaBase, long version, String clientOptions, String baseChecksum, String resultChecksum, String userName, File activitiesDB, Collection lockTokens, Map clientCapabilities) throws DAVException {
        this.myRepositoryManager = manager;
        this.myRepository = (FSRepository)repository;
        try {
            this.myRepository.testConnection();
        }
        catch (SVNException svne) {
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.FSFS, svne.getMessage());
            SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)svne.getErrorMessage().getErrorCode(), (String)"Could not open the requested SVN filesystem");
            throw DAVException.convertError(err, 500, "Could not fetch resource information.", null);
        }
        this.myLockTokens = lockTokens;
        this.myClientCapabilities = clientCapabilities;
        this.myFSFS = this.myRepository.getFSFS();
        this.myResourceURI = resourceURI;
        this.myIsSVNClient = isSVNClient;
        this.myDeltaBase = deltaBase;
        this.myVersion = version;
        this.myClientOptions = clientOptions;
        this.myBaseChecksum = baseChecksum;
        this.myResultChecksum = resultChecksum;
        this.myRevision = resourceURI.getRevision();
        this.myUserName = userName;
        this.myActivitiesDB = activitiesDB;
        DAVResourceHelper.prepareResource(this);
    }

    public DAVResource(DAVRepositoryManager manager, SVNRepository repository, DAVResourceURI resourceURI, long revision, boolean isSVNClient, String deltaBase, long version, String clientOptions, String baseChecksum, String resultChecksum, String userName, File activitiesDB, Collection lockTokens, Map clientCapabilities) {
        this.myRepositoryManager = manager;
        this.myResourceURI = resourceURI;
        this.myRepository = (FSRepository)repository;
        this.myFSFS = this.myRepository.getFSFS();
        this.myRevision = revision;
        this.myIsSVNClient = isSVNClient;
        this.myDeltaBase = deltaBase;
        this.myVersion = version;
        this.myClientOptions = clientOptions;
        this.myBaseChecksum = baseChecksum;
        this.myResultChecksum = resultChecksum;
        this.myUserName = userName;
        this.myActivitiesDB = activitiesDB;
        this.myLockTokens = lockTokens;
        this.myClientCapabilities = clientCapabilities;
    }

    public DAVResource() {
    }

    public void setRoot(FSRoot root) {
        this.myRoot = root;
    }

    public FSRoot getRoot() {
        return this.myRoot;
    }

    public FSTransactionInfo getTxnInfo() {
        return this.myTxnInfo;
    }

    public void setTxnInfo(FSTransactionInfo txnInfo) {
        this.myTxnInfo = txnInfo;
    }

    public DAVResourceURI getResourceURI() {
        return this.myResourceURI;
    }

    public SVNRepository getRepository() {
        return this.myRepository;
    }

    public long getRevision() {
        return this.myRevision;
    }

    public boolean exists() {
        return this.myResourceURI.exists();
    }

    public boolean isVersioned() {
        return this.myResourceURI.isVersioned();
    }

    public boolean isWorking() {
        return this.myResourceURI.isWorking();
    }

    public boolean isBaseLined() {
        return this.myResourceURI.isBaseLined();
    }

    public DAVResourceType getType() {
        return this.getResourceURI().getType();
    }

    public DAVResourceKind getKind() {
        return this.getResourceURI().getKind();
    }

    public String getActivityID() {
        return this.myResourceURI.getActivityID();
    }

    public boolean lacksETagPotential() {
        DAVResourceType type = this.getResourceURI().getType();
        return !this.exists() || type != DAVResourceType.REGULAR && type != DAVResourceType.VERSION || type == DAVResourceType.VERSION && this.isBaseLined();
    }

    public boolean canBeActivity() {
        return this.isAutoCheckedOut() || this.getType() == DAVResourceType.ACTIVITY && !this.exists();
    }

    public boolean isCollection() {
        return this.myIsCollection;
    }

    public boolean isSVNClient() {
        return this.myIsSVNClient;
    }

    public DAVAutoVersion getAutoVersion() {
        if (this.getType() == DAVResourceType.VERSION && this.isBaseLined()) {
            return DAVAutoVersion.ALWAYS;
        }
        DAVConfig config = this.myRepositoryManager.getDAVConfig();
        if (config.isAutoVersioning()) {
            if (this.getType() == DAVResourceType.REGULAR) {
                return DAVAutoVersion.ALWAYS;
            }
            if (this.getType() == DAVResourceType.WORKING && this.isAutoCheckedOut()) {
                return DAVAutoVersion.ALWAYS;
            }
        }
        return DAVAutoVersion.NEVER;
    }

    public String getUserName() {
        return this.myUserName;
    }

    public String getDeltaBase() {
        return this.myDeltaBase;
    }

    public long getVersion() {
        return this.myVersion;
    }

    public String getClientOptions() {
        return this.myClientOptions;
    }

    public String getBaseChecksum() {
        return this.myBaseChecksum;
    }

    public String getResultChecksum() {
        return this.myResultChecksum;
    }

    public File getActivitiesDB() {
        return this.myActivitiesDB;
    }

    public void versionControl(String target) throws DAVException {
        if (this.exists()) {
            throw new DAVException("vsn_control called on already-versioned resource.", 400, 0);
        }
        if (target != null) {
            throw new DAVException("vsn_control called with non-null target.", null, 501, null, SVNLogType.NETWORK, Level.FINE, null, "error", "svn:", SVNErrorCode.UNSUPPORTED_FEATURE.getCode(), null);
        }
    }

    public Iterator getChildren() throws SVNException {
        return new Iterator(){
            Iterator entriesIterator;
            {
                this.entriesIterator = DAVResource.this.getEntries().iterator();
            }

            @Override
            public void remove() {
            }

            @Override
            public boolean hasNext() {
                return this.entriesIterator.hasNext();
            }

            public Object next() {
                SVNDirEntry entry = (SVNDirEntry)this.entriesIterator.next();
                String childURI = DAVPathUtil.append(DAVResource.this.getResourceURI().getURI(), entry.getName());
                try {
                    DAVResourceURI newResourceURI = new DAVResourceURI(DAVResource.this.getResourceURI().getContext(), childURI, null, false);
                    return new DAVResource(DAVResource.this.myRepositoryManager, DAVResource.this.getRepository(), newResourceURI, DAVResource.this.getRevision(), DAVResource.this.isSVNClient(), DAVResource.this.getDeltaBase(), DAVResource.this.getVersion(), DAVResource.this.getClientOptions(), null, null, DAVResource.this.getUserName(), DAVResource.this.getActivitiesDB(), DAVResource.this.getLockTokens(), DAVResource.this.getClientCapabilities());
                }
                catch (SVNException e) {
                    return null;
                }
            }
        };
    }

    public Map getClientCapabilities() {
        return this.myClientCapabilities;
    }

    public Collection getLockTokens() {
        return this.myLockTokens;
    }

    public void setLockTokens(Collection lockTokens) {
        if (this.myLockTokens != null) {
            this.myLockTokens.addAll(lockTokens);
        }
        this.myLockTokens = lockTokens;
    }

    public Collection getEntries() throws SVNException {
        if (this.isCollection() && this.myEntries == null) {
            this.myEntries = new LinkedList();
            this.getRepository().getDir(this.getResourceURI().getPath(), this.getRevision(), null, 1, this.myEntries);
        }
        return this.myEntries;
    }

    public long getCreatedRevision() throws SVNException {
        String revisionParameter = this.getProperty("svn:entry:committed-rev");
        try {
            return Long.parseLong(revisionParameter);
        }
        catch (NumberFormatException e) {
            return this.getRevision();
        }
    }

    public long getCreatedRevisionUsingFS(String path) throws SVNException {
        path = path == null ? this.getResourceURI().getPath() : path;
        FSRevisionNode node = this.myRoot.getRevisionNode(path);
        return node.getCreatedRevision();
    }

    public Date getLastModified() throws SVNException {
        if (this.lacksETagPotential()) {
            return null;
        }
        return this.getRevisionDate(this.getCreatedRevision());
    }

    public Date getRevisionDate(long revision) throws SVNException {
        return SVNDate.parseDate((String)this.getRevisionProperty(revision, "svn:date"));
    }

    public String getETag() {
        if (this.lacksETagPotential()) {
            return null;
        }
        long createdRevision = -1L;
        try {
            createdRevision = this.getCreatedRevisionUsingFS(null);
        }
        catch (SVNException svne) {
            return null;
        }
        StringBuffer eTag = new StringBuffer();
        eTag.append(this.isCollection() ? "W/" : "");
        eTag.append("\"");
        eTag.append(createdRevision);
        eTag.append("/");
        eTag.append(SVNEncodingUtil.xmlEncodeCDATA((String)this.getResourceURI().getPath(), (boolean)true));
        eTag.append("\"");
        return eTag.toString();
    }

    public String getRepositoryUUID(boolean forceConnect) throws SVNException {
        return this.getRepository().getRepositoryUUID(forceConnect);
    }

    public String getContentType() throws SVNException {
        if (this.getResourceURI().isBaseLined() && this.getResourceURI().getType() == DAVResourceType.VERSION) {
            SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.RA_DAV_PROPS_NOT_FOUND, (String)"Failed to determine property"), (SVNLogType)SVNLogType.NETWORK);
            return null;
        }
        if (this.getResourceURI().getType() == DAVResourceType.PRIVATE && this.getResourceURI().getKind() == DAVResourceKind.VCC) {
            SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.RA_DAV_PROPS_NOT_FOUND, (String)"Failed to determine property"), (SVNLogType)SVNLogType.NETWORK);
            return null;
        }
        if (this.isCollection()) {
            return DEFAULT_COLLECTION_CONTENT_TYPE;
        }
        String contentType = this.getProperty("svn:mime-type");
        if (contentType != null) {
            return contentType;
        }
        return DEFAULT_FILE_CONTENT_TYPE;
    }

    public long getLatestRevision() throws SVNException {
        return this.getRepository().getLatestRevision();
    }

    public long getContentLength() throws SVNException {
        SVNDirEntry entry = this.getRepository().getDir(this.getResourceURI().getPath(), this.getRevision(), false, null);
        return entry.getSize();
    }

    public long getContentLength(String path) throws SVNException {
        path = path == null ? this.getResourceURI().getPath() : path;
        FSRevisionNode node = this.myRoot.getRevisionNode(path);
        return node.getFileLength();
    }

    public SVNLock[] getLocks() throws SVNException {
        if (this.getResourceURI().getPath() == null) {
            SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.RA_DAV_REQUEST_FAILED, (String)"get-locks-report run on resource which doesn't represent a path within a repository."), (SVNLogType)SVNLogType.NETWORK);
        }
        return this.getRepository().getLocks(this.getResourceURI().getPath());
    }

    public SVNLock getLock() throws SVNException {
        return this.getRepository().getLock(this.getResourceURI().getPath());
    }

    public void unlock(String token, boolean force) throws SVNException {
        HashMap<String, String> pathsToTokens = new HashMap<String, String>();
        pathsToTokens.put(this.getResourceURI().getPath(), token);
        this.getRepository().unlock(pathsToTokens, force, null);
    }

    public String getAuthor(long revision) throws SVNException {
        return this.getRevisionProperty(revision, "svn:author");
    }

    public String getMD5Checksum() throws SVNException {
        return this.getProperty("svn:entry:checksum");
    }

    public String getMD5Checksum(String path) throws SVNException {
        path = path == null ? this.getResourceURI().getPath() : path;
        FSRevisionNode node = this.myRoot.getRevisionNode(path);
        return node.getFileMD5Checksum();
    }

    public String getLog(long revision) throws SVNException {
        return this.getRevisionProperty(revision, "svn:log");
    }

    public String getProperty(String propertyName) throws SVNException {
        return this.getSVNProperties().getStringValue(propertyName);
    }

    public SVNPropertyValue getProperty(String path, String propertyName) throws SVNException {
        return this.getSVNProperties(path).getSVNPropertyValue(propertyName);
    }

    public String getRevisionProperty(long revision, String propertyName) throws SVNException {
        SVNPropertyValue value = this.getRepository().getRevisionPropertyValue(revision, propertyName);
        return value == null ? null : value.getString();
    }

    public void writeTo(OutputStream out) throws SVNException {
        if (this.isCollection()) {
            SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.RA_DAV_REQUEST_FAILED), (SVNLogType)SVNLogType.NETWORK);
        }
        this.getRepository().getFile(this.getResourceURI().getPath(), this.getRevision(), null, out);
    }

    public boolean isAutoCheckedOut() {
        return this.myIsAutoCheckedOut;
    }

    public void setIsAutoCkeckedOut(boolean isAutoCheckedOut) {
        this.myIsAutoCheckedOut = isAutoCheckedOut;
    }

    public String getTxnName() {
        return this.myTxnName;
    }

    public void setExists(boolean exists) {
        this.myResourceURI.setExists(exists);
    }

    public void setVersioned(boolean isVersioned) {
        this.myResourceURI.setVersioned(isVersioned);
    }

    public void setWorking(boolean isWorking) {
        this.myResourceURI.setWorking(isWorking);
    }

    public void setBaseLined(boolean isBaseLined) {
        this.myResourceURI.setBaseLined(isBaseLined);
    }

    public void setCollection(boolean isCollection) {
        this.myIsCollection = isCollection;
    }

    public void setTxnName(String txnName) {
        this.myTxnName = txnName;
    }

    public void setRevision(long revision) {
        this.myRevision = revision;
        this.myResourceURI.setRevision(revision);
    }

    public void setResourceURI(DAVResourceURI resourceURI) {
        this.myResourceURI = resourceURI;
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        if (o == this) {
            return true;
        }
        DAVResource otherResource = (DAVResource)o;
        if (!this.isOurResource(otherResource)) {
            return false;
        }
        String myRequestURI = this.myResourceURI.getRequestURI();
        String otherRequestURI = otherResource.getResourceURI().getRequestURI();
        return myRequestURI.equals(otherRequestURI);
    }

    public DAVResource dup() {
        DAVResource copy = new DAVResource();
        this.copyTo(copy);
        return copy;
    }

    public FSFS getFSFS() {
        return this.myFSFS;
    }

    public DAVRepositoryManager getRepositoryManager() {
        return this.myRepositoryManager;
    }

    public boolean isParentResource(DAVResource resource) {
        if (!this.isOurResource(resource)) {
            return false;
        }
        String thisURIPath = this.myResourceURI.getURI();
        String otherURIPath = resource.getResourceURI().getURI();
        return otherURIPath.length() > thisURIPath.length() && otherURIPath.startsWith(thisURIPath) && otherURIPath.charAt(thisURIPath.length()) == '/';
    }

    public SVNProperties getSVNProperties(String path) throws SVNException {
        String string = path = path == null ? this.getResourceURI().getPath() : path;
        if (this.mySVNProperties == null) {
            this.mySVNProperties = this.myFSFS.getProperties(this.myRoot.getRevisionNode(path));
        }
        return this.mySVNProperties;
    }

    private boolean isOurResource(DAVResource resource) {
        File reposRoot2;
        File reposRoot1 = this.myFSFS.getDBRoot();
        return reposRoot1.equals(reposRoot2 = resource.myFSFS.getDBRoot());
    }

    public SVNProperties getSVNProperties() throws SVNException {
        if (this.mySVNProperties == null) {
            this.mySVNProperties = new SVNProperties();
            if (this.getResourceURI().getType() == DAVResourceType.REGULAR) {
                if (this.isCollection()) {
                    this.getRepository().getDir(this.getResourceURI().getPath(), this.getRevision(), this.mySVNProperties, (ISVNDirEntryHandler)null);
                } else {
                    this.getRepository().getFile(this.getResourceURI().getPath(), this.getRevision(), this.mySVNProperties, null);
                }
            }
        }
        return this.mySVNProperties;
    }

    protected void copyTo(DAVResource copy) {
        copy.myRepositoryManager = this.myRepositoryManager;
        copy.myResourceURI = this.myResourceURI.dup();
        copy.myRepository = this.myRepository;
        copy.myRevision = this.myRevision;
        copy.myIsCollection = this.myIsCollection;
        copy.myIsSVNClient = this.myIsCollection;
        copy.myIsAutoCheckedOut = this.myIsAutoCheckedOut;
        copy.myDeltaBase = this.myDeltaBase;
        copy.myVersion = this.myVersion;
        copy.myClientOptions = this.myClientOptions;
        copy.myBaseChecksum = this.myBaseChecksum;
        copy.myResultChecksum = this.myResultChecksum;
        copy.myUserName = this.myUserName;
        copy.mySVNProperties = this.mySVNProperties;
        copy.myDeadProperties = this.myDeadProperties;
        copy.myEntries = this.myEntries;
        copy.myActivitiesDB = this.myActivitiesDB;
        copy.myFSFS = this.myFSFS;
        copy.myTxnName = this.myTxnName;
        copy.myRoot = this.myRoot;
        copy.myTxnInfo = this.myTxnInfo;
        copy.myClientCapabilities = this.myClientCapabilities;
        copy.myLockTokens = this.myLockTokens;
    }
}

