/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.server.dav;

import java.text.MessageFormat;
import java.util.logging.Level;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVResponse;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class DAVException
extends SVNException {
    private static final long serialVersionUID = 4845L;
    private String myMessage;
    private int myResponseCode;
    private int myErrorID;
    private DAVException myPreviousException;
    private String myTagName;
    private String myNameSpace;
    private DAVResponse myResponse;

    public DAVException(String message, Object[] objects, int responseCode, SVNErrorMessage error, SVNLogType logType, Level level, DAVException previousException, String tagName, String nameSpace, int errorID, DAVResponse response) {
        super(error != null ? error : SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.UNKNOWN));
        this.myMessage = objects == null ? message : MessageFormat.format(message, objects);
        this.myResponseCode = responseCode;
        this.myPreviousException = previousException;
        this.myTagName = tagName;
        this.myNameSpace = nameSpace;
        this.myErrorID = errorID;
        this.myResponse = response;
        SVNDebugLog.getDefaultLog().log(logType, message, level);
    }

    public DAVException(String message, int respondCode, DAVException previousException, int errorID) {
        this(message, null, respondCode, null, SVNLogType.NETWORK, Level.FINE, previousException, null, null, errorID, null);
    }

    public DAVException(String message, Object[] objects, int respondCode, DAVException previousException, int errorID) {
        this(message, objects, respondCode, null, SVNLogType.NETWORK, Level.FINE, previousException, null, null, errorID, null);
    }

    public DAVException(String message, int responseCode, SVNLogType logType) {
        this(message, null, responseCode, null, logType, Level.FINE, null, null, null, 0, null);
    }

    public DAVException(String message, int responseCode, SVNLogType logType, DAVResponse response) {
        this(message, null, responseCode, null, logType, Level.FINE, null, null, null, 0, response);
    }

    public DAVException(String message, int responseCode, SVNLogType logType, String tagName, String nameSpace) {
        this(message, null, responseCode, null, logType, Level.FINE, null, tagName, nameSpace, 0, null);
    }

    public DAVException(String message, Object[] objects, int responseCode, int errorID) {
        this(message, objects, responseCode, null, SVNLogType.NETWORK, Level.FINE, null, null, null, errorID, null);
    }

    public DAVException(String message, Object[] objects, int responseCode, int errorID, DAVResponse response) {
        this(message, objects, responseCode, null, SVNLogType.NETWORK, Level.FINE, null, null, null, errorID, response);
    }

    public DAVException(String message, int responseCode, int errorID) {
        this(message, null, responseCode, errorID);
    }

    public DAVException(String message, int responseCode, int errorID, DAVResponse response) {
        this(message, null, responseCode, errorID, response);
    }

    public int getErrorID() {
        return this.myErrorID;
    }

    public String getTagName() {
        return this.myTagName;
    }

    public int getResponseCode() {
        return this.myResponseCode;
    }

    public String getMessage() {
        return this.myMessage;
    }

    public DAVException getPreviousException() {
        return this.myPreviousException;
    }

    public String getNameSpace() {
        return this.myNameSpace;
    }

    public DAVResponse getResponse() {
        return this.myResponse;
    }

    public void setResponse(DAVResponse response) {
        this.myResponse = response;
    }

    public void setPreviousException(DAVException previousException) {
        this.myPreviousException = previousException;
    }

    public static DAVException convertError(SVNErrorMessage err, int statusCode, String message, Object[] objects) {
        if (err.getErrorCode() == SVNErrorCode.FS_NOT_FOUND) {
            statusCode = 404;
        } else if (err.getErrorCode() == SVNErrorCode.UNSUPPORTED_FEATURE) {
            statusCode = 501;
        } else if (err.getErrorCode() == SVNErrorCode.FS_PATH_ALREADY_LOCKED) {
            statusCode = 423;
        }
        DAVException error = DAVException.buildErrorChain(err, statusCode);
        if (message != null && err.getErrorCode() != SVNErrorCode.REPOS_HOOK_FAILURE) {
            if (objects != null) {
                message = MessageFormat.format(message, objects);
            }
            error = new DAVException(message, null, statusCode, null, SVNLogType.NETWORK, Level.FINE, error, null, null, err.getErrorCode().getCode(), null);
        }
        return error;
    }

    private static DAVException buildErrorChain(SVNErrorMessage err, int statusCode) {
        DAVException error = new DAVException(err.getMessage(), null, statusCode, err, SVNLogType.NETWORK, Level.FINE, null, "error", "svn:", err.getErrorCode().getCode(), null);
        if (err.getChildErrorMessage() != null) {
            error.setPreviousException(DAVException.buildErrorChain(err.getChildErrorMessage(), statusCode));
        }
        return error;
    }
}

