/*
 * Decompiled with CFR 0.152.
 */
package play.db.ebean;

import com.avaje.ebean.EbeanServer;
import com.avaje.ebean.EbeanServerFactory;
import com.avaje.ebean.config.ServerConfig;
import com.avaje.ebeaninternal.api.SpiEbeanServer;
import com.avaje.ebeaninternal.server.ddl.DdlGenerator;
import java.io.File;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Logger;
import javax.sql.DataSource;
import play.Application;
import play.Configuration;
import play.Plugin;
import play.api.libs.Files;
import play.db.DB;
import play.libs.Classpath;

public class EbeanPlugin
extends Plugin {
    private final Application application;
    private final Map<String, EbeanServer> servers = new HashMap<String, EbeanServer>();

    public EbeanPlugin(Application application) {
        this.application = application;
    }

    public String defaultServer() {
        return this.application.configuration().getString("ebeanconfig.datasource.default", "default");
    }

    public void onStart() {
        Configuration configuration = Configuration.root().getConfig("ebean");
        if (configuration != null) {
            for (String string : configuration.keys()) {
                File file;
                String string2;
                boolean bl;
                ServerConfig serverConfig = new ServerConfig();
                serverConfig.setName(string);
                serverConfig.loadFromProperties();
                try {
                    serverConfig.setDataSource((DataSource)new WrappingDatasource(DB.getDataSource((String)string)));
                }
                catch (Exception exception) {
                    throw configuration.reportError(string, exception.getMessage(), (Throwable)exception);
                }
                if (this.defaultServer().equals(string)) {
                    serverConfig.setDefaultServer(true);
                }
                String[] stringArray = configuration.getString(string).split(",");
                HashSet<String> hashSet = new HashSet<String>();
                for (String string3 : stringArray) {
                    if ((string3 = string3.trim()).endsWith(".*")) {
                        hashSet.addAll(Classpath.getTypes((Application)this.application, (String)string3.substring(0, string3.length() - 2)));
                        continue;
                    }
                    hashSet.add(string3);
                }
                for (String string4 : hashSet) {
                    try {
                        serverConfig.addClass(Class.forName(string4, true, this.application.classloader()));
                    }
                    catch (Throwable throwable) {
                        throw configuration.reportError(string, "Cannot register class [" + string4 + "] in Ebean server", throwable);
                    }
                }
                this.servers.put(string, EbeanServerFactory.create((ServerConfig)serverConfig));
                if (this.application.isProd() || !(bl = !"disabled".equals(this.application.configuration().getString("evolutionplugin"))) || (string2 = EbeanPlugin.generateEvolutionScript(this.servers.get(string), serverConfig)) == null || (file = this.application.getFile("conf/evolutions/" + string + "/1.sql")).exists() && !Files.readFile((File)file).startsWith("# --- Created by Ebean DDL")) continue;
                Files.createDirectory((File)this.application.getFile("conf/evolutions/" + string));
                Files.writeFileIfChanged((File)file, (String)string2);
            }
        }
    }

    public static String generateEvolutionScript(EbeanServer ebeanServer, ServerConfig serverConfig) {
        DdlGenerator ddlGenerator = new DdlGenerator();
        ddlGenerator.setup((SpiEbeanServer)ebeanServer, serverConfig.getDatabasePlatform(), serverConfig);
        String string = ddlGenerator.generateCreateDdl();
        String string2 = ddlGenerator.generateDropDdl();
        if (string == null || string.trim().isEmpty()) {
            return null;
        }
        return "# --- Created by Ebean DDL\r\n# To stop Ebean DDL generation, remove this comment and start using Evolutions\r\n\r\n# --- !Ups\r\n\r\n" + string + "\r\n" + "# --- !Downs\r\n" + "\r\n" + string2;
    }

    static class WrappingDatasource
    implements DataSource {
        final DataSource wrapped;

        public Connection wrap(Connection connection) throws SQLException {
            connection.setAutoCommit(false);
            return connection;
        }

        public WrappingDatasource(DataSource dataSource) {
            this.wrapped = dataSource;
        }

        @Override
        public Connection getConnection() throws SQLException {
            return this.wrap(this.wrapped.getConnection());
        }

        @Override
        public Connection getConnection(String string, String string2) throws SQLException {
            return this.wrap(this.wrapped.getConnection(string, string2));
        }

        @Override
        public int getLoginTimeout() throws SQLException {
            return this.wrapped.getLoginTimeout();
        }

        @Override
        public PrintWriter getLogWriter() throws SQLException {
            return this.wrapped.getLogWriter();
        }

        @Override
        public void setLoginTimeout(int n) throws SQLException {
            this.wrapped.setLoginTimeout(n);
        }

        @Override
        public void setLogWriter(PrintWriter printWriter) throws SQLException {
            this.wrapped.setLogWriter(printWriter);
        }

        @Override
        public boolean isWrapperFor(Class<?> clazz) throws SQLException {
            return this.wrapped.isWrapperFor(clazz);
        }

        @Override
        public <T> T unwrap(Class<T> clazz) throws SQLException {
            return this.wrapped.unwrap(clazz);
        }

        @Override
        public Logger getParentLogger() {
            return null;
        }
    }
}

