/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.btree;

import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.tmatesoft.sqljet.core.SqlJetErrorCode;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.SqlJetTransactionMode;
import org.tmatesoft.sqljet.core.internal.ISqlJetBackend;
import org.tmatesoft.sqljet.core.internal.ISqlJetBtree;
import org.tmatesoft.sqljet.core.internal.ISqlJetBtreeCursor;
import org.tmatesoft.sqljet.core.internal.ISqlJetDbHandle;
import org.tmatesoft.sqljet.core.internal.ISqlJetFile;
import org.tmatesoft.sqljet.core.internal.ISqlJetFileSystem;
import org.tmatesoft.sqljet.core.internal.ISqlJetKeyInfo;
import org.tmatesoft.sqljet.core.internal.ISqlJetMemoryPointer;
import org.tmatesoft.sqljet.core.internal.ISqlJetPage;
import org.tmatesoft.sqljet.core.internal.ISqlJetPageCallback;
import org.tmatesoft.sqljet.core.internal.ISqlJetPager;
import org.tmatesoft.sqljet.core.internal.SqlJetAutoVacuumMode;
import org.tmatesoft.sqljet.core.internal.SqlJetBtreeFlags;
import org.tmatesoft.sqljet.core.internal.SqlJetBtreeTableCreateFlags;
import org.tmatesoft.sqljet.core.internal.SqlJetDbFlags;
import org.tmatesoft.sqljet.core.internal.SqlJetFileOpenPermission;
import org.tmatesoft.sqljet.core.internal.SqlJetFileType;
import org.tmatesoft.sqljet.core.internal.SqlJetPagerJournalMode;
import org.tmatesoft.sqljet.core.internal.SqlJetSafetyLevel;
import org.tmatesoft.sqljet.core.internal.SqlJetSavepointOperation;
import org.tmatesoft.sqljet.core.internal.SqlJetUtility;
import org.tmatesoft.sqljet.core.internal.btree.SqlJetBtreeCursor;
import org.tmatesoft.sqljet.core.internal.btree.SqlJetBtreeLock;
import org.tmatesoft.sqljet.core.internal.btree.SqlJetBtreeLockMode;
import org.tmatesoft.sqljet.core.internal.btree.SqlJetBtreeShared;
import org.tmatesoft.sqljet.core.internal.btree.SqlJetMemPage;
import org.tmatesoft.sqljet.core.internal.mutex.SqlJetMutex;
import org.tmatesoft.sqljet.core.internal.pager.SqlJetPager;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetSchema;
import org.tmatesoft.sqljet.core.table.ISqlJetBusyHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlJetBtree
implements ISqlJetBtree {
    private static Logger btreeLogger = Logger.getLogger("SQLJET_LOG_BTREE");
    private static final boolean SQLJET_LOG_BTREE = SqlJetUtility.getBoolSysProp("SQLJET_LOG_BTREE", false);
    private static final ISqlJetMemoryPointer PAGE1_21 = SqlJetUtility.wrapPtr(new byte[]{64, 32, 32});
    ISqlJetDbHandle db;
    SqlJetBtreeShared pBt;
    TransMode inTrans;
    boolean sharable;
    boolean locked;
    int wantToLock;
    SqlJetBtree pNext;
    SqlJetBtree pPrev;
    private SqlJetTransactionMode transMode = null;
    static List<SqlJetBtreeShared> sharedCacheList = new LinkedList<SqlJetBtreeShared>();

    static void TRACE(String format, Object ... args) {
        if (SQLJET_LOG_BTREE) {
            SqlJetUtility.log(btreeLogger, format, args);
        }
    }

    private void integrity() {
        assert (this.pBt.inTransaction != TransMode.NONE || this.pBt.nTransaction == 0);
        assert (this.pBt.inTransaction.compareTo(this.inTrans) >= 0);
    }

    @Override
    public ISqlJetDbHandle getDb() {
        return this.db;
    }

    @Override
    public SqlJetTransactionMode getTransMode() {
        return this.transMode;
    }

    public boolean invokeBusyHandler(int number) {
        assert (this.db != null);
        assert (this.db.getMutex().held());
        ISqlJetBusyHandler busyHandler = this.db.getBusyHandler();
        if (busyHandler == null) {
            return false;
        }
        return busyHandler.call(number);
    }

    @Override
    public void enter() {
        SqlJetBtree p = this;
        assert (p.pNext == null || p.pNext.pBt.hashCode() > p.pBt.hashCode());
        assert (p.pPrev == null || p.pPrev.pBt.hashCode() < p.pBt.hashCode());
        assert (p.pNext == null || p.pNext.db == p.db);
        assert (p.pPrev == null || p.pPrev.db == p.db);
        assert (p.sharable || p.pNext == null && p.pPrev == null);
        assert (!p.locked || p.wantToLock > 0);
        assert (p.sharable || p.wantToLock == 0);
        assert (p.db.getMutex().held());
        if (!p.sharable) {
            return;
        }
        ++p.wantToLock;
        if (p.locked) {
            return;
        }
        if (p.pBt.mutex.attempt()) {
            p.locked = true;
            return;
        }
        SqlJetBtree pLater = p.pNext;
        while (pLater != null) {
            assert (pLater.sharable);
            assert (pLater.pNext == null || pLater.pNext.pBt.hashCode() > pLater.pBt.hashCode());
            assert (!pLater.locked || pLater.wantToLock > 0);
            if (pLater.locked) {
                pLater.pBt.mutex.leave();
                pLater.locked = false;
            }
            pLater = pLater.pNext;
        }
        p.pBt.mutex.enter();
        p.locked = true;
        pLater = p.pNext;
        while (pLater != null) {
            if (pLater.wantToLock > 0) {
                pLater.pBt.mutex.enter();
                pLater.locked = true;
            }
            pLater = pLater.pNext;
        }
    }

    @Override
    public void leave() {
        SqlJetBtree p = this;
        if (p.sharable) {
            assert (p.wantToLock > 0);
            --p.wantToLock;
            if (p.wantToLock == 0) {
                assert (p.locked);
                p.pBt.mutex.leave();
                p.locked = false;
            }
        }
    }

    boolean holdsMutex() {
        return !this.sharable || this.locked && this.wantToLock != 0 && this.pBt.mutex.held();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open(File filename, ISqlJetDbHandle db, Set<SqlJetBtreeFlags> flags, SqlJetFileType type, Set<SqlJetFileOpenPermission> permissions) throws SqlJetException {
        block25: {
            List<SqlJetBtreeShared> fullPathname;
            boolean isMemdb;
            SqlJetBtreeShared pBt2 = null;
            ISqlJetMemoryPointer zDbHeader = SqlJetUtility.allocatePtr(100);
            boolean bl = isMemdb = filename != null && ":memory:".equals(filename.getPath());
            assert (db != null);
            ISqlJetFileSystem pVfs = db.getFileSystem();
            this.inTrans = TransMode.NONE;
            this.db = db;
            if (!isMemdb && !db.getFlags().contains((Object)SqlJetDbFlags.Vtab) && filename != null && !"".equals(filename.getPath()) && db.getConfig().isSharedCacheEnabled()) {
                this.sharable = true;
                db.getFlags().add(SqlJetDbFlags.SharedCache);
                fullPathname = pVfs.getFullPath(filename);
                List<SqlJetBtreeShared> list = sharedCacheList;
                synchronized (list) {
                    for (SqlJetBtreeShared pBt2 : sharedCacheList) {
                        assert (pBt2.nRef > 0);
                        String pagerFilename = pVfs.getFullPath(pBt2.pPager.getFileName());
                        if (!((String)((Object)fullPathname)).equals(pagerFilename) || pVfs != pBt2.pPager.getFileSystem()) continue;
                        this.pBt = pBt2;
                        ++pBt2.nRef;
                        break;
                    }
                }
            }
            try {
                if (this.pBt == null) {
                    int nReserve;
                    pBt2 = new SqlJetBtreeShared();
                    pBt2.pPager = new SqlJetPager();
                    pBt2.pPager.open(pVfs, filename, SqlJetBtreeFlags.toPagerFlags(flags), type, permissions);
                    pBt2.pPager.readFileHeader(zDbHeader.remaining(), zDbHeader);
                    pBt2.pPager.setBusyhandler(new ISqlJetBusyHandler(){

                        public boolean call(int number) {
                            return SqlJetBtree.this.invokeBusyHandler(number);
                        }
                    });
                    this.pBt = pBt2;
                    pBt2.pPager.setReiniter(new ISqlJetPageCallback(){

                        public void pageCallback(ISqlJetPage page) throws SqlJetException {
                            SqlJetBtree.this.pageReinit(page);
                        }
                    });
                    pBt2.pCursor = null;
                    pBt2.pPage1 = null;
                    pBt2.readOnly = pBt2.pPager.isReadOnly();
                    pBt2.pageSize = SqlJetUtility.get2byte(zDbHeader, 16);
                    if (pBt2.pageSize < 512 || pBt2.pageSize > 32768 || (pBt2.pageSize - 1 & pBt2.pageSize) != 0) {
                        pBt2.pageSize = 1024;
                        pBt2.pageSize = pBt2.pPager.setPageSize(pBt2.pageSize);
                        if (null != filename && !isMemdb) {
                            pBt2.autoVacuum = SQLJET_DEFAULT_AUTOVACUUM != SqlJetAutoVacuumMode.NONE;
                            pBt2.incrVacuum = SQLJET_DEFAULT_AUTOVACUUM == SqlJetAutoVacuumMode.FULL;
                        }
                        nReserve = 0;
                    } else {
                        nReserve = SqlJetUtility.getUnsignedByte(zDbHeader, 20);
                        pBt2.pageSizeFixed = true;
                        pBt2.autoVacuum = SqlJetUtility.get4byte(zDbHeader, 52) != 0;
                        pBt2.incrVacuum = SqlJetUtility.get4byte(zDbHeader, 64) != 0;
                    }
                    pBt2.usableSize = pBt2.pageSize - nReserve;
                    assert ((pBt2.pageSize & 7) == 0);
                    pBt2.pageSize = pBt2.pPager.setPageSize(pBt2.pageSize);
                    if (this.sharable) {
                        pBt2.mutex = new SqlJetMutex();
                        pBt2.nRef = 1;
                        fullPathname = sharedCacheList;
                        synchronized (fullPathname) {
                            sharedCacheList.add(pBt2);
                        }
                    }
                }
                if (!this.sharable) break block25;
                for (ISqlJetBackend backend : db.getBackends()) {
                    ISqlJetBtree btree = backend.getBtree();
                    if (btree == null || !(btree instanceof SqlJetBtree)) continue;
                    SqlJetBtree pSib = (SqlJetBtree)btree;
                    if (!pSib.sharable) continue;
                    while (pSib.pPrev != null) {
                        pSib = pSib.pPrev;
                    }
                    if (this.pBt.hashCode() < pSib.pBt.hashCode()) {
                        this.pNext = pSib;
                        this.pPrev = null;
                        pSib.pPrev = this;
                    } else {
                        while (pSib.pNext != null && pSib.pNext.pBt.hashCode() < this.pBt.hashCode()) {
                            pSib = pSib.pNext;
                        }
                        this.pNext = pSib.pNext;
                        this.pPrev = pSib;
                        if (this.pNext != null) {
                            this.pNext.pPrev = this;
                        }
                        pSib.pNext = this;
                    }
                    break;
                }
            }
            catch (SqlJetException e) {
                if (pBt2 != null && pBt2.pPager != null) {
                    pBt2.pPager.close();
                }
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SqlJetException {
        SqlJetBtree p = this;
        assert (p.db.getMutex().held());
        p.enter();
        try {
            this.pBt.db = this.db;
            SqlJetBtreeCursor pCur = this.pBt.pCursor;
            while (pCur != null) {
                SqlJetBtreeCursor pTmp = pCur;
                pCur = pCur.pNext;
                if (pTmp.pBtree != p) continue;
                pTmp.closeCursor();
            }
            p.rollback();
        }
        finally {
            p.leave();
        }
        assert (p.wantToLock == 0 && !p.locked);
        if (!p.sharable || SqlJetBtree.removeFromSharingList(this.pBt)) {
            assert (this.pBt.pCursor == null);
            this.pBt.pPager.close();
            this.pBt.pSchema = null;
            this.pBt.pTmpSpace = null;
        }
        this.pBt = null;
        assert (p.wantToLock == 0);
        assert (!p.locked);
        if (p.pPrev != null) {
            p.pPrev.pNext = p.pNext;
        }
        if (p.pNext != null) {
            p.pNext.pPrev = p.pPrev;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean removeFromSharingList(SqlJetBtreeShared pBt) {
        boolean removed = false;
        List<SqlJetBtreeShared> list = sharedCacheList;
        synchronized (list) {
            pBt.mutex.enter();
            try {
                --pBt.nRef;
            }
            finally {
                pBt.mutex.leave();
            }
            if (pBt.nRef <= 0) {
                sharedCacheList.remove(pBt);
                removed = true;
            }
        }
        return removed;
    }

    @Override
    public void setCacheSize(int mxPage) {
        assert (this.db.getMutex().held());
        this.enter();
        try {
            this.pBt.pPager.setCacheSize(mxPage);
        }
        finally {
            this.leave();
        }
    }

    @Override
    public int getCacheSize() {
        assert (this.db.getMutex().held());
        this.enter();
        try {
            int n = this.pBt.pPager.getCacheSize();
            return n;
        }
        finally {
            this.leave();
        }
    }

    @Override
    public void setSafetyLevel(SqlJetSafetyLevel level) {
        assert (this.db.getMutex().held());
        this.enter();
        try {
            this.pBt.pPager.setSafetyLevel(level);
        }
        finally {
            this.leave();
        }
    }

    @Override
    public SqlJetSafetyLevel getSafetyLevel() {
        assert (this.db.getMutex().held());
        this.enter();
        try {
            SqlJetSafetyLevel sqlJetSafetyLevel = this.pBt.pPager.getSafetyLevel();
            return sqlJetSafetyLevel;
        }
        finally {
            this.leave();
        }
    }

    @Override
    public void setJournalMode(SqlJetPagerJournalMode mode) {
        assert (this.db.getMutex().held());
        this.enter();
        try {
            this.pBt.pPager.setJournalMode(mode);
        }
        finally {
            this.leave();
        }
    }

    @Override
    public SqlJetPagerJournalMode getJournalMode() {
        assert (this.db.getMutex().held());
        this.enter();
        try {
            SqlJetPagerJournalMode sqlJetPagerJournalMode = this.pBt.pPager.getJournalMode();
            return sqlJetPagerJournalMode;
        }
        finally {
            this.leave();
        }
    }

    @Override
    public boolean isSyncDisabled() {
        assert (this.db.getMutex().held());
        this.enter();
        try {
            assert (this.pBt != null && this.pBt.pPager != null);
            boolean bl = this.pBt.pPager.isNoSync();
            return bl;
        }
        finally {
            this.leave();
        }
    }

    @Override
    public void setPageSize(int pageSize, int reserve) throws SqlJetException {
        assert (reserve >= -1 && reserve <= 255);
        this.enter();
        try {
            if (this.pBt.pageSizeFixed) {
                throw new SqlJetException(SqlJetErrorCode.READONLY);
            }
            if (reserve < 0) {
                reserve = this.pBt.pageSize - this.pBt.usableSize;
            }
            assert (reserve >= 0 && reserve <= 255);
            if (pageSize >= 512 && pageSize <= 32768 && (pageSize - 1 & pageSize) == 0) {
                assert ((pageSize & 7) == 0);
                assert (this.pBt.pPage1 == null && this.pBt.pCursor == null);
                this.pBt.pageSize = pageSize;
                this.pBt.pTmpSpace = null;
                this.pBt.pageSize = this.pBt.pPager.setPageSize(this.pBt.pageSize);
            }
            this.pBt.usableSize = this.pBt.pageSize - reserve;
        }
        finally {
            this.leave();
        }
    }

    @Override
    public int getPageSize() {
        return this.pBt.pageSize;
    }

    @Override
    public void setMaxPageCount(int mxPage) throws SqlJetException {
        this.enter();
        try {
            this.pBt.pPager.setMaxPageCount(mxPage);
        }
        finally {
            this.leave();
        }
    }

    @Override
    public int getReserve() {
        this.enter();
        try {
            int n = this.pBt.pageSize - this.pBt.usableSize;
            return n;
        }
        finally {
            this.leave();
        }
    }

    @Override
    public void setAutoVacuum(SqlJetAutoVacuumMode autoVacuum) throws SqlJetException {
        boolean av = autoVacuum != SqlJetAutoVacuumMode.NONE;
        this.enter();
        try {
            if (this.pBt.pageSizeFixed && av != this.pBt.autoVacuum) {
                throw new SqlJetException(SqlJetErrorCode.READONLY);
            }
            this.pBt.autoVacuum = av;
        }
        finally {
            this.leave();
        }
    }

    @Override
    public SqlJetAutoVacuumMode getAutoVacuum() {
        this.enter();
        try {
            SqlJetAutoVacuumMode sqlJetAutoVacuumMode = !this.pBt.autoVacuum ? SqlJetAutoVacuumMode.NONE : (!this.pBt.incrVacuum ? SqlJetAutoVacuumMode.FULL : SqlJetAutoVacuumMode.INCR);
            return sqlJetAutoVacuumMode;
        }
        finally {
            this.leave();
        }
    }

    private void lockBtree() throws SqlJetException {
        SqlJetErrorCode rc = null;
        assert (this.pBt.mutex.held());
        if (this.pBt.pPage1 != null) {
            return;
        }
        SqlJetMemPage pPage1 = this.pBt.getPage(1, false);
        try {
            int nPage = this.pBt.pPager.getPageCount();
            if (nPage > 0) {
                ISqlJetMemoryPointer page1 = pPage1.aData;
                rc = SqlJetErrorCode.NOTADB;
                if (SqlJetUtility.memcmp(page1, zMagicHeader, 16) != 0) {
                    throw new SqlJetException(rc);
                }
                if (SqlJetUtility.getUnsignedByte(page1, 18) > 1) {
                    this.pBt.readOnly = true;
                }
                if (SqlJetUtility.getUnsignedByte(page1, 19) > 1) {
                    throw new SqlJetException(rc);
                }
                if (SqlJetUtility.memcmp(page1, 21, PAGE1_21, 0, 3) != 0) {
                    throw new SqlJetException(rc);
                }
                int pageSize = SqlJetUtility.get2byte(page1, 16);
                if ((pageSize - 1 & pageSize) != 0 || pageSize < 512) {
                    throw new SqlJetException(rc);
                }
                assert ((pageSize & 7) == 0);
                int usableSize = pageSize - SqlJetUtility.getUnsignedByte(page1, 20);
                if (pageSize != this.pBt.pageSize) {
                    SqlJetMemPage.releasePage(pPage1);
                    this.pBt.usableSize = usableSize;
                    this.pBt.pageSize = pageSize;
                    this.freeTempSpace(this.pBt);
                    this.pBt.pageSize = this.pBt.pPager.setPageSize(this.pBt.pageSize);
                    return;
                }
                if (usableSize < 500) {
                    throw new SqlJetException(rc);
                }
                this.pBt.pageSize = pageSize;
                this.pBt.usableSize = usableSize;
                this.pBt.autoVacuum = SqlJetUtility.get4byte(page1, 52) > 0;
                this.pBt.incrVacuum = SqlJetUtility.get4byte(page1, 64) > 0;
            }
            this.pBt.maxLocal = (this.pBt.usableSize - 12) * 64 / 255 - 23;
            this.pBt.minLocal = (this.pBt.usableSize - 12) * 32 / 255 - 23;
            this.pBt.maxLeaf = this.pBt.usableSize - 35;
            this.pBt.minLeaf = (this.pBt.usableSize - 12) * 32 / 255 - 23;
            assert (this.pBt.maxLeaf + 23 <= this.pBt.MX_CELL_SIZE());
            this.pBt.pPage1 = pPage1;
            return;
        }
        catch (SqlJetException e) {
            SqlJetMemPage.releasePage(pPage1);
            this.pBt.pPage1 = null;
            throw e;
        }
    }

    private void freeTempSpace(SqlJetBtreeShared bt) {
        bt.pTmpSpace = null;
    }

    private void newDatabase() throws SqlJetException {
        assert (this.pBt.mutex.held());
        int nPage = this.pBt.pPager.getPageCount();
        if (nPage > 0) {
            return;
        }
        SqlJetMemPage pP1 = this.pBt.pPage1;
        assert (pP1 != null);
        ISqlJetMemoryPointer data = pP1.aData;
        pP1.pDbPage.write();
        SqlJetUtility.memcpy(data, zMagicHeader, zMagicHeader.remaining());
        assert (zMagicHeader.remaining() == 16);
        SqlJetUtility.put2byte(data, 16, this.pBt.pageSize);
        SqlJetUtility.putUnsignedByte(data, 18, 1);
        SqlJetUtility.putUnsignedByte(data, 19, 1);
        assert (this.pBt.usableSize <= this.pBt.pageSize && this.pBt.usableSize + 255 >= this.pBt.pageSize);
        SqlJetUtility.putUnsignedByte(data, 20, (byte)(this.pBt.pageSize - this.pBt.usableSize));
        SqlJetUtility.putUnsignedByte(data, 21, 64);
        SqlJetUtility.putUnsignedByte(data, 22, 32);
        SqlJetUtility.putUnsignedByte(data, 23, 32);
        SqlJetUtility.memset(data, 24, (byte)0, 76);
        pP1.zeroPage(13);
        this.pBt.pageSizeFixed = true;
        SqlJetUtility.put4byte(data, 52, this.pBt.autoVacuum ? 1L : 0L);
        SqlJetUtility.put4byte(data, 64, this.pBt.incrVacuum ? 1L : 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beginTrans(SqlJetTransactionMode mode) throws SqlJetException {
        block32: {
            SqlJetException rc = null;
            this.enter();
            try {
                this.pBt.db = this.db;
                this.integrity();
                if (this.inTrans == TransMode.WRITE || this.inTrans == TransMode.READ && mode == SqlJetTransactionMode.READ_ONLY) {
                    return;
                }
                if (this.pBt.readOnly && mode != SqlJetTransactionMode.READ_ONLY) {
                    throw new SqlJetException(SqlJetErrorCode.READONLY);
                }
                if (this.pBt.inTransaction == TransMode.WRITE && mode != SqlJetTransactionMode.READ_ONLY) {
                    throw new SqlJetException(SqlJetErrorCode.BUSY);
                }
                if (mode == SqlJetTransactionMode.EXCLUSIVE) {
                    Iterator<SqlJetBtreeLock> pIter = this.pBt.pLock.iterator();
                    while (pIter.hasNext()) {
                        if (pIter.next().pBtree == this) continue;
                        throw new SqlJetException(SqlJetErrorCode.BUSY);
                    }
                }
                int nBusy = 0;
                do {
                    rc = null;
                    try {
                        if (this.pBt.pPage1 == null) {
                            do {
                                this.lockBtree();
                            } while (this.pBt.pPage1 == null);
                        }
                        if (mode != SqlJetTransactionMode.READ_ONLY) {
                            if (this.pBt.readOnly) {
                                throw new SqlJetException(SqlJetErrorCode.READONLY);
                            }
                            this.pBt.pPager.begin(mode == SqlJetTransactionMode.EXCLUSIVE);
                            this.newDatabase();
                        }
                        if (mode == SqlJetTransactionMode.READ_ONLY) continue;
                        this.pBt.inStmt = false;
                    }
                    catch (SqlJetException e) {
                        rc = e;
                        this.pBt.unlockBtreeIfUnused();
                    }
                } while (rc != null && rc.getErrorCode() == SqlJetErrorCode.BUSY && this.pBt.inTransaction == TransMode.NONE && this.invokeBusyHandler(nBusy) && nBusy++ > -1);
                if (rc == null) {
                    if (this.inTrans == TransMode.NONE) {
                        ++this.pBt.nTransaction;
                    }
                    TransMode transMode = this.inTrans = mode != SqlJetTransactionMode.READ_ONLY ? TransMode.WRITE : TransMode.READ;
                    if (this.inTrans.compareTo(this.pBt.inTransaction) > 0) {
                        this.pBt.inTransaction = this.inTrans;
                    }
                    if (mode == SqlJetTransactionMode.EXCLUSIVE) {
                        assert (this.pBt.pExclusive == null);
                        this.pBt.pExclusive = this;
                    }
                }
                this.transMode = mode;
            }
            catch (SqlJetException e) {
                rc = e;
            }
            finally {
                if (rc == null && mode != SqlJetTransactionMode.READ_ONLY) {
                    try {
                        this.pBt.pPager.openSavepoint(this.db.getSavepointNum());
                    }
                    catch (SqlJetException e) {
                        rc = e;
                    }
                }
                this.integrity();
                this.leave();
                if (rc == null) break block32;
                throw rc;
            }
        }
    }

    @Override
    public void commitPhaseOne(String master) throws SqlJetException {
        if (this.inTrans == TransMode.WRITE) {
            this.enter();
            try {
                this.pBt.db = this.db;
                if (this.pBt.autoVacuum) {
                    this.pBt.autoVacuumCommit();
                }
                this.pBt.pPager.commitPhaseOne(master, false);
            }
            finally {
                this.leave();
            }
        }
    }

    private void unlockAllTables() {
        Iterator<SqlJetBtreeLock> ppIter = this.pBt.pLock.iterator();
        assert (this.holdsMutex());
        assert (this.sharable || !ppIter.hasNext());
        while (ppIter.hasNext()) {
            SqlJetBtreeLock pLock = ppIter.next();
            assert (this.pBt.pExclusive == null || this.pBt.pExclusive == pLock.pBtree);
            if (pLock.pBtree != this) continue;
            ppIter.remove();
        }
        if (this.pBt.pExclusive == this) {
            this.pBt.pExclusive = null;
        }
    }

    @Override
    public void commitPhaseTwo() throws SqlJetException {
        this.enter();
        try {
            this.pBt.db = this.db;
            this.integrity();
            if (this.inTrans == TransMode.WRITE) {
                assert (this.pBt.inTransaction == TransMode.WRITE);
                assert (this.pBt.nTransaction > 0);
                this.pBt.pPager.commitPhaseTwo();
                this.pBt.inTransaction = TransMode.READ;
                this.pBt.inStmt = false;
            }
            this.unlockAllTables();
            if (this.inTrans != TransMode.NONE) {
                --this.pBt.nTransaction;
                if (0 == this.pBt.nTransaction) {
                    this.pBt.inTransaction = TransMode.NONE;
                }
            }
            this.inTrans = TransMode.NONE;
            this.pBt.unlockBtreeIfUnused();
            this.integrity();
        }
        finally {
            this.leave();
        }
    }

    @Override
    public void commit() throws SqlJetException {
        this.enter();
        try {
            this.commitPhaseOne(null);
            this.commitPhaseTwo();
            this.transMode = null;
        }
        finally {
            this.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() throws SqlJetException {
        this.enter();
        try {
            block19: {
                block17: {
                    this.pBt.db = this.db;
                    try {
                        this.pBt.saveAllCursors(0, null);
                    }
                    catch (SqlJetException e) {
                        this.tripAllCursors(e.getErrorCode());
                    }
                    this.integrity();
                    this.unlockAllTables();
                    try {
                        Object v1;
                        if (this.inTrans != TransMode.WRITE) break block17;
                        assert (TransMode.WRITE == this.pBt.inTransaction);
                        try {
                            this.pBt.pPager.rollback();
                            Object var4_2 = null;
                        }
                        catch (Throwable throwable) {
                            Object v0;
                            Object var4_3 = null;
                            try {
                                SqlJetMemPage pPage1 = this.pBt.getPage(1, false);
                                SqlJetMemPage.releasePage(pPage1);
                                v0 = null;
                            }
                            catch (Throwable throwable2) {
                                v0 = null;
                            }
                            Object var6_9 = v0;
                            this.pBt.inTransaction = TransMode.READ;
                            throw throwable;
                        }
                        try {
                            SqlJetMemPage pPage1 = this.pBt.getPage(1, false);
                            SqlJetMemPage.releasePage(pPage1);
                            v1 = null;
                        }
                        catch (Throwable throwable) {
                            v1 = null;
                        }
                        Object var6_8 = v1;
                        this.pBt.inTransaction = TransMode.READ;
                        {
                        }
                    }
                    catch (Throwable throwable) {
                        Object var8_12 = null;
                        if (this.inTrans != TransMode.NONE) {
                            assert (this.pBt.nTransaction > 0);
                            --this.pBt.nTransaction;
                            if (0 == this.pBt.nTransaction) {
                                this.pBt.inTransaction = TransMode.NONE;
                            }
                        }
                        this.inTrans = TransMode.NONE;
                        this.pBt.inStmt = false;
                        this.pBt.unlockBtreeIfUnused();
                        this.integrity();
                        throw throwable;
                    }
                }
                Object var8_11 = null;
                if (this.inTrans == TransMode.NONE) break block19;
                assert (this.pBt.nTransaction > 0);
                --this.pBt.nTransaction;
                if (0 == this.pBt.nTransaction) {
                    this.pBt.inTransaction = TransMode.NONE;
                }
            }
            this.inTrans = TransMode.NONE;
            this.pBt.inStmt = false;
            this.pBt.unlockBtreeIfUnused();
            this.integrity();
            this.transMode = null;
        }
        catch (Throwable throwable) {
            Object var10_15 = null;
            this.leave();
            throw throwable;
        }
        Object var10_14 = null;
        this.leave();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beginStmt() throws SqlJetException {
        this.enter();
        try {
            this.pBt.db = this.db;
            assert (this.inTrans == TransMode.WRITE);
            assert (!this.pBt.inStmt);
            assert (!this.pBt.readOnly);
            if (this.inTrans != TransMode.WRITE || this.pBt.inStmt || this.pBt.readOnly) {
                throw new SqlJetException(SqlJetErrorCode.INTERNAL);
            }
            assert (this.pBt.inTransaction == TransMode.WRITE);
            try {
                this.pBt.pPager.openSavepoint(this.db.getSavepointNum() + 1);
                Object var2_1 = null;
                this.pBt.inStmt = true;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.pBt.inStmt = true;
                throw throwable;
            }
            Object var4_4 = null;
            this.leave();
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.leave();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commitStmt() throws SqlJetException {
        this.enter();
        try {
            this.pBt.db = this.db;
            assert (!this.pBt.readOnly);
            if (this.pBt.inStmt) {
                try {
                    int iStmtpoint = this.db.getSavepointNum();
                    this.pBt.pPager.savepoint(SqlJetSavepointOperation.RELEASE, iStmtpoint);
                    Object var3_2 = null;
                    this.pBt.inStmt = false;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    this.pBt.inStmt = false;
                    throw throwable;
                }
            }
            Object var5_5 = null;
            this.leave();
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.leave();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollbackStmt() throws SqlJetException {
        this.enter();
        try {
            this.pBt.db = this.db;
            assert (!this.pBt.readOnly);
            if (this.pBt.inStmt) {
                try {
                    int iStmtpoint = this.db.getSavepointNum();
                    this.pBt.pPager.savepoint(SqlJetSavepointOperation.ROLLBACK, iStmtpoint);
                    this.pBt.pPager.savepoint(SqlJetSavepointOperation.RELEASE, iStmtpoint);
                    Object var3_2 = null;
                    this.pBt.inStmt = false;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    this.pBt.inStmt = false;
                    throw throwable;
                }
            }
            Object var5_5 = null;
            this.leave();
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.leave();
            throw throwable;
        }
    }

    protected void pageReinit(ISqlJetPage page) throws SqlJetException {
        SqlJetMemPage pPage = (SqlJetMemPage)page.getExtra();
        if (pPage != null && pPage.isInit) {
            assert (pPage.pBt.mutex.held());
            pPage.isInit = false;
            if (page.getRefCount() > 0) {
                pPage.initPage();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int createTable(Set<SqlJetBtreeTableCreateFlags> flags) throws SqlJetException {
        this.enter();
        try {
            this.pBt.db = this.db;
            int n = this.doCreateTable(flags);
            Object var4_3 = null;
            this.leave();
            return n;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.leave();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doCreateTable(Set<SqlJetBtreeTableCreateFlags> flags) throws SqlJetException {
        SqlJetMemPage pRoot;
        int pgnoRoot;
        assert (this.holdsMutex());
        assert (this.pBt.inTransaction == TransMode.WRITE);
        assert (!this.pBt.readOnly);
        if (this.pBt.autoVacuum) {
            int[] pgnoMove = new int[1];
            this.pBt.invalidateAllOverflowCache();
            pgnoRoot = this.getMeta(4);
            ++pgnoRoot;
            while (pgnoRoot == this.pBt.PTRMAP_PAGENO(pgnoRoot) || pgnoRoot == this.pBt.PENDING_BYTE_PAGE()) {
                ++pgnoRoot;
            }
            assert (pgnoRoot >= 3);
            SqlJetMemPage pPageMove = this.pBt.allocatePage(pgnoMove, pgnoRoot, true);
            if (pgnoMove[0] != pgnoRoot) {
                short[] eType = new short[]{0};
                int[] iPtrPage = new int[]{0};
                SqlJetMemPage.releasePage(pPageMove);
                pRoot = this.pBt.getPage(pgnoRoot, false);
                try {
                    this.pBt.ptrmapGet(pgnoRoot, eType, iPtrPage);
                    if (eType[0] == 1 || eType[0] == 2) {
                        throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                    }
                }
                catch (SqlJetException e) {
                    SqlJetMemPage.releasePage(pRoot);
                    throw e;
                }
                assert (eType[0] != 1);
                assert (eType[0] != 2);
                try {
                    pRoot.pDbPage.write();
                }
                catch (SqlJetException e) {
                    SqlJetMemPage.releasePage(pRoot);
                    throw e;
                }
                try {
                    this.pBt.relocatePage(pRoot, eType[0], iPtrPage[0], pgnoMove[0], false);
                    Object var10_14 = null;
                }
                catch (Throwable throwable) {
                    Object var10_15 = null;
                    SqlJetMemPage.releasePage(pRoot);
                    throw throwable;
                }
                SqlJetMemPage.releasePage(pRoot);
                pRoot = this.pBt.getPage(pgnoRoot, false);
                try {
                    pRoot.pDbPage.write();
                }
                catch (SqlJetException e) {
                    SqlJetMemPage.releasePage(pRoot);
                    throw e;
                }
            }
            pRoot = pPageMove;
            try {
                this.pBt.ptrmapPut(pgnoRoot, (short)1, 0);
            }
            catch (SqlJetException e) {
                SqlJetMemPage.releasePage(pRoot);
                throw e;
            }
            try {
                this.updateMeta(4, pgnoRoot);
            }
            catch (SqlJetException e) {
                SqlJetMemPage.releasePage(pRoot);
                throw e;
            }
        }
        int[] a = new int[1];
        pRoot = this.pBt.allocatePage(a, 1, false);
        pgnoRoot = a[0];
        try {
            pRoot.zeroPage(SqlJetBtreeTableCreateFlags.toByte(flags) | 8);
            Object var12_17 = null;
        }
        catch (Throwable throwable) {
            Object var12_18 = null;
            pRoot.pDbPage.unref();
            throw throwable;
        }
        pRoot.pDbPage.unref();
        return pgnoRoot;
    }

    @Override
    public boolean isInTrans() {
        assert (this.db.getMutex().held());
        return this.inTrans == TransMode.WRITE;
    }

    @Override
    public boolean isInStmt() {
        assert (this.holdsMutex());
        return this.pBt != null && this.pBt.inStmt;
    }

    @Override
    public boolean isInReadTrans() {
        assert (this.db.getMutex().held());
        return this.inTrans == TransMode.NONE;
    }

    @Override
    public SqlJetSchema getSchema() {
        return (SqlJetSchema)this.pBt.pSchema;
    }

    @Override
    public void setSchema(SqlJetSchema schema) {
        this.pBt.pSchema = schema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSchemaLocked() {
        assert (this.db.getMutex().held());
        this.enter();
        try {
            boolean bl = this.queryTableLock(1, SqlJetBtreeLockMode.READ);
            Object var3_2 = null;
            this.leave();
            return bl;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.leave();
            throw throwable;
        }
    }

    private boolean queryTableLock(int iTab, SqlJetBtreeLockMode eLock) {
        assert (this.holdsMutex());
        assert (eLock != null);
        assert (this.db != null);
        if (!this.sharable) {
            return true;
        }
        if (this.pBt.pExclusive != null && this.pBt.pExclusive != this) {
            return false;
        }
        if (!this.db.getFlags().contains((Object)SqlJetDbFlags.ReadUncommitted) || eLock == SqlJetBtreeLockMode.WRITE || iTab == 1) {
            for (SqlJetBtreeLock pIter : this.pBt.pLock) {
                if (pIter.pBtree == this || pIter.iTable != iTab || pIter.eLock == eLock && eLock == SqlJetBtreeLockMode.READ) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lockTable(int table, boolean isWriteLock) {
        if (this.sharable) {
            this.enter();
            try {
                SqlJetBtreeLockMode lockType;
                SqlJetBtreeLockMode sqlJetBtreeLockMode = lockType = isWriteLock ? SqlJetBtreeLockMode.WRITE : SqlJetBtreeLockMode.READ;
                if (this.queryTableLock(table, lockType)) {
                    this.lockTable(table, lockType);
                }
                Object var5_4 = null;
                this.leave();
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.leave();
                throw throwable;
            }
        }
    }

    private void lockTable(int iTable, SqlJetBtreeLockMode eLock) {
        assert (this.holdsMutex());
        assert (eLock != null);
        assert (this.db != null);
        if (!this.sharable) {
            return;
        }
        assert (this.queryTableLock(iTable, eLock));
        if (this.db.getFlags().contains((Object)SqlJetDbFlags.ReadUncommitted) && eLock == SqlJetBtreeLockMode.READ && iTable != 1) {
            return;
        }
        SqlJetBtreeLock pLock = null;
        for (SqlJetBtreeLock pIter : this.pBt.pLock) {
            if (pIter.iTable != iTable || pIter.pBtree != this) continue;
            pLock = pIter;
            break;
        }
        if (null == pLock) {
            pLock = new SqlJetBtreeLock();
            pLock.iTable = iTable;
            pLock.pBtree = this;
            this.pBt.pLock.add(pLock);
            pLock.eLock = eLock;
        }
        if (eLock == SqlJetBtreeLockMode.WRITE && pLock.eLock == SqlJetBtreeLockMode.READ) {
            pLock.eLock = eLock;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void savepoint(SqlJetSavepointOperation op, int savepoint) throws SqlJetException {
        if (this.inTrans == TransMode.WRITE) {
            assert (!this.pBt.inStmt);
            assert (op == SqlJetSavepointOperation.RELEASE || op == SqlJetSavepointOperation.ROLLBACK);
            assert (savepoint >= 0 || savepoint == -1 && op == SqlJetSavepointOperation.ROLLBACK);
            this.enter();
            try {
                this.pBt.db = this.db;
                this.pBt.pPager.savepoint(op, savepoint);
                this.newDatabase();
                Object var4_3 = null;
                this.leave();
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.leave();
                throw throwable;
            }
        }
    }

    @Override
    public File getFilename() {
        assert (this.pBt.pPager != null);
        return this.pBt.pPager.getFileName();
    }

    @Override
    public File getDirname() {
        assert (this.pBt.pPager != null);
        return this.pBt.pPager.getDirectoryName();
    }

    @Override
    public File getJournalname() {
        assert (this.pBt.pPager != null);
        return this.pBt.pPager.getJournalName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copyFile(ISqlJetBtree from) throws SqlJetException {
        this.enter();
        try {
            SqlJetBtree pFrom = (SqlJetBtree)from;
            pFrom.enter();
            try {
                this.doCopyFile(pFrom);
                Object var4_3 = null;
                this.leave();
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.leave();
                throw throwable;
            }
            Object var6_6 = null;
            this.leave();
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.leave();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCopyFile(SqlJetBtree pFrom) throws SqlJetException {
        SqlJetBtree pTo = this;
        SqlJetBtreeShared pBtTo = pTo.pBt;
        SqlJetBtreeShared pBtFrom = pFrom.pBt;
        pBtTo.db = pTo.db;
        pBtFrom.db = pFrom.db;
        int nToPageSize = pBtTo.pageSize;
        int nFromPageSize = pBtFrom.pageSize;
        assert (pTo.inTrans == TransMode.WRITE);
        assert (pFrom.inTrans == TransMode.WRITE);
        if (pBtTo.pCursor != null) {
            throw new SqlJetException(SqlJetErrorCode.BUSY);
        }
        int nToPage = pBtTo.pPager.getPageCount();
        int nFromPage = pBtFrom.pPager.getPageCount();
        int iSkip = pBtTo.PENDING_BYTE_PAGE();
        int nNewPage = (int)(((long)nFromPage * (long)nFromPageSize + (long)nToPageSize - 1L) / (long)nToPageSize);
        for (int i = 1; i <= nToPage || i <= nNewPage; ++i) {
            if (i != iSkip && i <= nToPage) {
                Object var14_15;
                ISqlJetPage pDbPage = null;
                pDbPage = pBtTo.pPager.getPage(i);
                try {
                    pDbPage.write();
                    if (i > nFromPage) {
                        pDbPage.dontWrite();
                    }
                    var14_15 = null;
                }
                catch (Throwable throwable) {
                    var14_15 = null;
                    pDbPage.unref();
                    throw throwable;
                }
                pDbPage.unref();
                {
                }
            }
            if (i == iSkip || i > nNewPage) continue;
            ISqlJetPage pToPage = null;
            pToPage = pBtTo.pPager.getPage(i);
            pToPage.write();
            for (long iOff = (long)(i - 1) * (long)nToPageSize; iOff < (long)i * (long)nToPageSize; iOff += (long)nFromPageSize) {
                int nCopy;
                ISqlJetPage pFromPage = null;
                int iFrom = (int)(iOff / (long)nFromPageSize) + 1;
                if (iFrom == pBtFrom.PENDING_BYTE_PAGE()) continue;
                pFromPage = pBtFrom.pPager.getPage(iFrom);
                ISqlJetMemoryPointer zTo = pToPage.getData();
                ISqlJetMemoryPointer zFrom = pFromPage.getData();
                int nFrom = 0;
                int nTo = 0;
                if (nFromPageSize >= nToPageSize) {
                    nFrom += (i - 1) * nToPageSize - (iFrom - 1) * nFromPageSize;
                    nCopy = nToPageSize;
                } else {
                    nTo += (iFrom - 1) * nFromPageSize - (i - 1) * nToPageSize;
                    nCopy = nFromPageSize;
                }
                SqlJetUtility.memcpy(zTo, nTo, zFrom, nFrom, nCopy);
                pFromPage.unref();
            }
            if (pToPage == null) continue;
            SqlJetMemPage p = (SqlJetMemPage)pToPage.getExtra();
            p.isInit = false;
            pToPage.unref();
        }
        ISqlJetFile pFile = pBtTo.pPager.getFile();
        long iSize = (long)nFromPageSize * (long)nFromPage;
        long iNow = (long)(nToPage > nNewPage ? nToPage : nNewPage) * (long)nToPageSize;
        long iPending = ((long)pBtTo.PENDING_BYTE_PAGE() - 1L) * (long)nToPageSize;
        assert (iSize <= iNow);
        pBtTo.db = pTo.db;
        pBtTo.pPager.commitPhaseOne(null, true);
        if (iSize < iNow) {
            pFile.truncate(iSize);
        }
        if (nFromPageSize < nToPageSize && iSize > iPending) {
            for (long iOff = iPending; iOff < iPending + (long)nToPageSize; iOff += (long)nFromPageSize) {
                ISqlJetPage pFromPage = null;
                int iFrom = (int)(iOff / (long)nFromPageSize) + 1;
                if (iFrom == pBtFrom.PENDING_BYTE_PAGE() || iFrom > nFromPage) continue;
                pFromPage = pBtFrom.pPager.getPage(iFrom);
                ISqlJetMemoryPointer zFrom = pFromPage.getData();
                pFile.write(zFrom, nFromPageSize, iOff);
                pFromPage.unref();
            }
        }
        try {
            pBtTo.pPager.sync();
            pBtTo.pageSizeFixed = false;
        }
        catch (SqlJetException e) {
            pTo.rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void incrVacuum() throws SqlJetException {
        this.enter();
        try {
            this.pBt.db = this.db;
            assert (this.pBt.inTransaction == TransMode.WRITE && this.inTrans == TransMode.WRITE);
            if (!this.pBt.autoVacuum) {
                throw new SqlJetException(SqlJetErrorCode.DONE);
            }
            this.pBt.invalidateAllOverflowCache();
            this.pBt.incrVacuumStep(0, this.pBt.pPager.imageSize());
            Object var2_1 = null;
            this.leave();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.leave();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int dropTable(int table) throws SqlJetException {
        this.enter();
        try {
            this.pBt.db = this.db;
            int n = this.doDropTable(table);
            Object var4_3 = null;
            this.leave();
            return n;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.leave();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int doDropTable(int iTable) throws SqlJetException {
        SqlJetMemPage pPage = null;
        assert (this.holdsMutex());
        assert (this.inTrans == TransMode.WRITE);
        if (this.pBt.pCursor != null) {
            throw new SqlJetException(SqlJetErrorCode.LOCKED);
        }
        pPage = this.pBt.getPage(iTable, false);
        try {
            this.clearTable(iTable, null);
        }
        catch (SqlJetException e) {
            SqlJetMemPage.releasePage(pPage);
            throw e;
        }
        int piMoved = 0;
        if (iTable > 1) {
            if (this.pBt.autoVacuum) {
                int maxRootPgno;
                block23: {
                    try {
                        maxRootPgno = this.getMeta(4);
                    }
                    catch (SqlJetException e) {
                        SqlJetMemPage.releasePage(pPage);
                        throw e;
                    }
                    if (iTable == maxRootPgno) {
                        try {
                            pPage.freePage();
                            Object var7_8 = null;
                        }
                        catch (Throwable throwable) {
                            Object var7_9 = null;
                            SqlJetMemPage.releasePage(pPage);
                            throw throwable;
                        }
                        SqlJetMemPage.releasePage(pPage);
                        {
                            break block23;
                        }
                    }
                    SqlJetMemPage.releasePage(pPage);
                    SqlJetMemPage pMove = this.pBt.getPage(maxRootPgno, false);
                    try {
                        this.pBt.relocatePage(pMove, (short)1, 0, iTable, false);
                        Object var9_11 = null;
                    }
                    catch (Throwable throwable) {
                        Object var9_12 = null;
                        SqlJetMemPage.releasePage(pMove);
                        throw throwable;
                    }
                    SqlJetMemPage.releasePage(pMove);
                    pMove = this.pBt.getPage(maxRootPgno, false);
                    try {
                        pMove.freePage();
                        Object var11_14 = null;
                    }
                    catch (Throwable throwable) {
                        Object var11_15 = null;
                        SqlJetMemPage.releasePage(pMove);
                        throw throwable;
                    }
                    SqlJetMemPage.releasePage(pMove);
                    piMoved = maxRootPgno;
                }
                if (--maxRootPgno == this.pBt.PENDING_BYTE_PAGE()) {
                    --maxRootPgno;
                }
                if (maxRootPgno == this.pBt.PTRMAP_PAGENO(maxRootPgno)) {
                    --maxRootPgno;
                }
                assert (maxRootPgno != this.pBt.PENDING_BYTE_PAGE());
                this.updateMeta(4, maxRootPgno);
                return piMoved;
            }
            try {
                pPage.freePage();
                Object var13_17 = null;
            }
            catch (Throwable throwable) {
                Object var13_18 = null;
                SqlJetMemPage.releasePage(pPage);
                throw throwable;
            }
            SqlJetMemPage.releasePage(pPage);
            return piMoved;
        }
        try {
            pPage.zeroPage(9);
            Object var15_20 = null;
        }
        catch (Throwable throwable) {
            Object var15_21 = null;
            SqlJetMemPage.releasePage(pPage);
            throw throwable;
        }
        SqlJetMemPage.releasePage(pPage);
        return piMoved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearTable(int table, int[] change) throws SqlJetException {
        this.enter();
        try {
            this.pBt.db = this.db;
            assert (this.inTrans == TransMode.WRITE);
            if (!this.checkReadLocks(table, null, 1L) && this.pBt.saveAllCursors(table, null)) {
                this.pBt.clearDatabasePage(table, false, change);
            }
            Object var4_3 = null;
            this.leave();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.leave();
            throw throwable;
        }
    }

    boolean checkReadLocks(int pgnoRoot, SqlJetBtreeCursor pExclude, long iRow) {
        assert (this.holdsMutex());
        SqlJetBtreeCursor p = this.pBt.pCursor;
        while (p != null) {
            if (p != pExclude && p.pgnoRoot == pgnoRoot) {
                ISqlJetDbHandle dbOther;
                if (p.isIncrblobHandle && (pExclude == null && iRow != 0L || pExclude != null && !pExclude.isIncrblobHandle && p.info.nKey == iRow)) {
                    p.eState = SqlJetBtreeCursor.CursorState.INVALID;
                }
                if (!(p.eState != SqlJetBtreeCursor.CursorState.VALID || p.wrFlag && !p.isIncrblobHandle || (dbOther = p.pBtree.db) != null && (dbOther == this.db || dbOther.getFlags().contains((Object)SqlJetDbFlags.ReadUncommitted)))) {
                    return true;
                }
            }
            p = p.pNext;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMeta(int idx) throws SqlJetException {
        this.enter();
        try {
            ISqlJetMemoryPointer pP1;
            ISqlJetPage pDbPage = null;
            this.pBt.db = this.db;
            this.queryTableLock(1, SqlJetBtreeLockMode.READ);
            assert (idx >= 0 && idx <= 15);
            if (this.pBt.pPage1 != null) {
                pP1 = this.pBt.pPage1.aData;
            } else {
                pDbPage = this.pBt.pPager.acquirePage(1, true);
                pP1 = pDbPage.getData();
            }
            int pMeta = SqlJetUtility.get4byte(pP1, 36 + idx * 4);
            if (this.pBt.pPage1 == null) {
                pDbPage.unref();
            }
            this.lockTable(1, SqlJetBtreeLockMode.READ);
            int n = pMeta;
            Object var7_6 = null;
            this.leave();
            return n;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.leave();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateMeta(int idx, int value) throws SqlJetException {
        assert (idx >= 1 && idx <= 15);
        this.enter();
        try {
            this.pBt.db = this.db;
            assert (this.inTrans == TransMode.WRITE);
            assert (this.pBt.pPage1 != null);
            ISqlJetMemoryPointer pP1 = this.pBt.pPage1.aData;
            this.pBt.pPage1.pDbPage.write();
            SqlJetUtility.put4byte(pP1, 36 + idx * 4, value);
            if (idx == 7) {
                assert (this.pBt.autoVacuum || value == 0);
                assert (value == 0 || value == 1);
                this.pBt.incrVacuum = value != 0;
            }
            Object var5_4 = null;
            this.leave();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.leave();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tripAllCursors(SqlJetErrorCode errCode) throws SqlJetException {
        this.enter();
        try {
            SqlJetBtreeCursor p = this.pBt.pCursor;
            while (p != null) {
                p.clearCursor();
                p.eState = SqlJetBtreeCursor.CursorState.FAULT;
                p.error = errCode;
                p.skip = errCode != null ? 1 : 0;
                for (int i = 0; i <= p.iPage; ++i) {
                    SqlJetMemPage.releasePage(p.apPage[i]);
                    p.apPage[i] = null;
                }
                p = p.pNext;
            }
            Object var5_4 = null;
            this.leave();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.leave();
            throw throwable;
        }
    }

    @Override
    public ISqlJetPager getPager() {
        return this.pBt.pPager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ISqlJetBtreeCursor getCursor(int table, boolean wrFlag, ISqlJetKeyInfo keyInfo) throws SqlJetException {
        this.enter();
        try {
            this.pBt.db = this.db;
            SqlJetBtreeCursor sqlJetBtreeCursor = new SqlJetBtreeCursor(this, table, wrFlag, keyInfo);
            Object var6_5 = null;
            this.leave();
            return sqlJetBtreeCursor;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.leave();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void lockWithRetry() throws SqlJetException {
        assert (this.holdsMutex());
        if (this.inTrans == TransMode.NONE) {
            TransMode inTransaction = this.pBt.inTransaction;
            this.integrity();
            try {
                this.beginTrans(SqlJetTransactionMode.READ_ONLY);
                Object var3_2 = null;
                this.pBt.inTransaction = inTransaction;
                this.inTrans = TransMode.NONE;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.pBt.inTransaction = inTransaction;
                this.inTrans = TransMode.NONE;
                throw throwable;
            }
            --this.pBt.nTransaction;
            this.integrity();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeAllCursors() throws SqlJetException {
        this.enter();
        try {
            SqlJetBtreeCursor p = this.pBt.pCursor;
            while (p != null) {
                p.closeCursor();
                p = p.pNext;
            }
            Object var3_2 = null;
            this.leave();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.leave();
            throw throwable;
        }
    }

    @Override
    public String integrityCheck(int[] root, int root2, int mxErr, int[] err) {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum TransMode {
        NONE,
        READ,
        WRITE;

    }
}

