/*
 * Decompiled with CFR 0.152.
 */
package play.libs;

import com.fasterxml.jackson.databind.JsonNode;
import org.apache.commons.lang3.StringEscapeUtils;
import play.PlayInternal;
import play.api.libs.EventSource;
import play.api.mvc.Codec;
import play.core.j.JavaResults;
import play.libs.F;
import play.libs.Json;
import play.libs.Scala;
import play.mvc.Results;

public abstract class EventSource
extends Results.Chunks<String> {
    private Results.Chunks.Out<String> out;

    public EventSource() {
        super(JavaResults.writeString((String)"text/event-stream", (Codec)Codec.javaSupported((String)"utf-8")));
    }

    public void onReady(Results.Chunks.Out<String> out) {
        this.out = out;
        this.onConnected();
    }

    @Deprecated
    public void sendDataByName(String string, String string2) {
        this.out.write((Object)("event: " + string + "\r\n" + "data: " + StringEscapeUtils.escapeEcmaScript((String)string2) + "\r\n\r\n"));
    }

    @Deprecated
    public void sendDataById(String string, String string2) {
        this.out.write((Object)("id: " + string + "\r\n" + "data: " + StringEscapeUtils.escapeEcmaScript((String)string2) + "\r\n\r\n"));
    }

    @Deprecated
    public void sendData(String string) {
        this.out.write((Object)("data: " + StringEscapeUtils.escapeEcmaScript((String)string) + "\r\n\r\n"));
    }

    public void send(Event event) {
        this.out.write((Object)event.formatted());
    }

    public abstract void onConnected();

    public void onDisconnected(F.Callback0 callback0) {
        this.out.onDisconnected(callback0);
    }

    public void close() {
        this.out.close();
    }

    public static EventSource whenConnected(F.Callback<EventSource> callback) {
        return new WhenConnectedEventSource(callback);
    }

    public static class Event {
        private final String name;
        private final String id;
        private final String data;

        public Event(String string, String string2, String string3) {
            this.name = string3;
            this.id = string2;
            this.data = string;
        }

        public Event withName(String string) {
            return new Event(this.data, this.id, string);
        }

        public Event withId(String string) {
            return new Event(this.data, string, this.name);
        }

        public String formatted() {
            return new EventSource.Event(this.data, Scala.Option((Object)this.id), Scala.Option((Object)this.name)).formatted();
        }

        public static Event event(String string) {
            return new Event(string, null, null);
        }

        public static Event event(JsonNode jsonNode) {
            return new Event(Json.stringify((JsonNode)jsonNode), null, null);
        }
    }

    static final class WhenConnectedEventSource
    extends EventSource {
        private final F.Callback<EventSource> callback;

        WhenConnectedEventSource(F.Callback<EventSource> callback) {
            if (callback == null) {
                throw new NullPointerException("EventSource onConnected callback cannot be null");
            }
            this.callback = callback;
        }

        @Override
        public void onConnected() {
            try {
                this.callback.invoke((Object)this);
            }
            catch (Throwable throwable) {
                PlayInternal.logger().error("Exception in EventSource.onConnected", throwable);
            }
        }
    }
}

