/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.util.scheduler;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class FixedSizedSchedulerImpl
extends ScheduledThreadPoolExecutor {
    private static final AtomicInteger POOL_ID = new AtomicInteger();

    public FixedSizedSchedulerImpl(int corePoolSize) {
        super(corePoolSize, new ThreadFactory(){
            private final int thisPoolId = FixedSizedSchedulerImpl.access$000().incrementAndGet();
            private final ThreadFactory parentFactory = Executors.defaultThreadFactory();
            private final AtomicInteger threadId = new AtomicInteger();

            @Override
            public Thread newThread(Runnable runnable) {
                Thread result = this.parentFactory.newThread(runnable);
                result.setName("mariaDb-connection-validity-" + this.thisPoolId + "-" + this.threadId.incrementAndGet());
                return result;
            }
        });
        this.setKeepAliveTime(2L, TimeUnit.HOURS);
        this.allowCoreThreadTimeOut(true);
    }

    static /* synthetic */ AtomicInteger access$000() {
        return POOL_ID;
    }
}

