/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.protocol;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.mariadb.jdbc.UrlParser;
import org.mariadb.jdbc.internal.MariaDbType;
import org.mariadb.jdbc.internal.packet.dao.ColumnInformation;
import org.mariadb.jdbc.internal.packet.dao.parameters.LongDataParameterHolder;
import org.mariadb.jdbc.internal.packet.dao.parameters.ParameterHolder;
import org.mariadb.jdbc.internal.packet.read.RawPacket;
import org.mariadb.jdbc.internal.packet.read.ReadResultPacketFactory;
import org.mariadb.jdbc.internal.packet.result.AbstractResultPacket;
import org.mariadb.jdbc.internal.packet.result.ErrorPacket;
import org.mariadb.jdbc.internal.packet.result.LocalInfilePacket;
import org.mariadb.jdbc.internal.packet.result.OkPacket;
import org.mariadb.jdbc.internal.packet.result.ResultSetPacket;
import org.mariadb.jdbc.internal.packet.send.SendChangeDbPacket;
import org.mariadb.jdbc.internal.packet.send.SendClosePrepareStatementPacket;
import org.mariadb.jdbc.internal.packet.send.SendExecutePrepareStatementPacket;
import org.mariadb.jdbc.internal.packet.send.SendPingPacket;
import org.mariadb.jdbc.internal.packet.send.SendPrepareParameterPacket;
import org.mariadb.jdbc.internal.packet.send.SendPrepareStatementPacket;
import org.mariadb.jdbc.internal.packet.send.SendTextQueryPacket;
import org.mariadb.jdbc.internal.protocol.AbstractConnectProtocol;
import org.mariadb.jdbc.internal.protocol.MasterProtocol;
import org.mariadb.jdbc.internal.protocol.Protocol;
import org.mariadb.jdbc.internal.query.MariaDbQuery;
import org.mariadb.jdbc.internal.query.Query;
import org.mariadb.jdbc.internal.queryresults.AbstractQueryResult;
import org.mariadb.jdbc.internal.queryresults.CachedSelectResult;
import org.mariadb.jdbc.internal.queryresults.SelectQueryResult;
import org.mariadb.jdbc.internal.queryresults.StreamingSelectResult;
import org.mariadb.jdbc.internal.queryresults.UpdateResult;
import org.mariadb.jdbc.internal.stream.MaxAllowedPacketException;
import org.mariadb.jdbc.internal.util.ExceptionMapper;
import org.mariadb.jdbc.internal.util.PrepareStatementCache;
import org.mariadb.jdbc.internal.util.buffer.Reader;
import org.mariadb.jdbc.internal.util.constant.ServerStatus;
import org.mariadb.jdbc.internal.util.dao.PrepareResult;
import org.mariadb.jdbc.internal.util.dao.QueryException;

public class AbstractQueryProtocol
extends AbstractConnectProtocol
implements Protocol {
    private int transactionIsolationLevel = 0;
    private InputStream localInfileInputStream;
    private int maxRows;

    public AbstractQueryProtocol(UrlParser urlParser, ReentrantLock lock) {
        super(urlParser, lock);
    }

    public static String hexdump(byte[] buffer, int offset) {
        StringBuffer dump = new StringBuffer();
        if (buffer.length - offset > 0) {
            dump.append(String.format("%02x", buffer[offset]));
            for (int i = offset + 1; i < buffer.length; ++i) {
                dump.append(String.format("%02x", buffer[i]));
            }
        }
        return dump.toString();
    }

    public static String hexdump(ByteBuffer bb, int offset) {
        byte[] bit = new byte[bb.remaining()];
        bb.mark();
        bb.get(bit);
        bb.reset();
        return AbstractQueryProtocol.hexdump(bit, offset);
    }

    @Override
    public PrepareResult prepare(String sql) throws QueryException {
        this.checkClose();
        try {
            if (this.urlParser.getOptions().cachePrepStmts && this.prepareStatementCache.containsKey(sql)) {
                PrepareResult pr = (PrepareResult)this.prepareStatementCache.get(sql);
                pr.addUse();
                return pr;
            }
            SendPrepareStatementPacket sendPrepareStatementPacket = new SendPrepareStatementPacket(sql);
            sendPrepareStatementPacket.send(this.writer);
            ByteBuffer byteBuffer = this.packetFetcher.getReusableBuffer();
            if (byteBuffer.get(0) == -1) {
                ErrorPacket ep = new ErrorPacket(byteBuffer);
                String message = ep.getMessage();
                throw new QueryException("Error preparing query: " + message, ep.getErrorNumber(), ep.getSqlState());
            }
            byte bit = byteBuffer.get(0);
            if (bit == 0) {
                Reader reader = new Reader(byteBuffer);
                reader.readByte();
                int statementId = reader.readInt();
                int numColumns = reader.readShort();
                int numParams = reader.readShort();
                reader.readByte();
                this.hasWarnings = reader.readShort() > 0;
                ColumnInformation[] params = new ColumnInformation[numParams];
                if (numParams > 0) {
                    for (int i = 0; i < numParams; ++i) {
                        params[i] = new ColumnInformation(this.packetFetcher.getRawPacket().getByteBuffer());
                    }
                    this.readEofPacket();
                }
                ColumnInformation[] columns = new ColumnInformation[numColumns];
                if (numColumns > 0) {
                    for (int i = 0; i < numColumns; ++i) {
                        columns[i] = new ColumnInformation(this.packetFetcher.getRawPacket().getByteBuffer());
                    }
                    this.readEofPacket();
                }
                PrepareResult prepareResult = new PrepareResult(statementId, columns, params);
                if (this.urlParser.getOptions().cachePrepStmts && sql != null && sql.length() < this.urlParser.getOptions().prepStmtCacheSqlLimit) {
                    this.prepareStatementCache.putIfNone(sql, prepareResult);
                }
                return prepareResult;
            }
            throw new QueryException("Unexpected packet returned by server, first byte " + bit);
        }
        catch (IOException e) {
            throw new QueryException(e.getMessage(), -1, ExceptionMapper.SqlStates.CONNECTION_EXCEPTION.getSqlState(), e);
        }
    }

    @Override
    public void closePreparedStatement(int statementId) throws QueryException {
        this.lock.lock();
        try {
            this.writer.startPacket(0);
            this.writer.write(25);
            this.writer.write(statementId);
            this.writer.finishPacket();
        }
        catch (IOException e) {
            throw new QueryException(e.getMessage(), -1, ExceptionMapper.SqlStates.CONNECTION_EXCEPTION.getSqlState(), e);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean getAutocommit() {
        this.lock.lock();
        try {
            boolean bl = (this.serverStatus & ServerStatus.AUTOCOMMIT) != 0;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean inTransaction() {
        return (this.serverStatus & ServerStatus.IN_TRANSACTION) != 0;
    }

    @Override
    public boolean hasMoreResults() {
        return this.moreResults;
    }

    @Override
    public void closeExplicit() {
        this.explicitClosed = true;
        this.close();
    }

    @Override
    public void rollback() {
        this.lock.lock();
        try {
            if (this.inTransaction()) {
                this.executeQuery(new MariaDbQuery("ROLLBACK"));
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.lock.unlock();
        }
    }

    private SelectQueryResult createQueryResult(ResultSetPacket packet, boolean streaming, boolean binaryProtocol) throws IOException, QueryException {
        StreamingSelectResult streamingResult = StreamingSelectResult.createStreamingSelectResult(packet, this.packetFetcher, this, binaryProtocol);
        if (streaming) {
            return streamingResult;
        }
        return CachedSelectResult.createCachedSelectResult(streamingResult);
    }

    @Override
    public void setCatalog(String database) throws QueryException {
        this.lock.lock();
        try {
            this.checkClose();
            SendChangeDbPacket packet = new SendChangeDbPacket(database);
            packet.send(this.writer);
            ByteBuffer byteBuffer = this.packetFetcher.getReusableBuffer();
            if (byteBuffer.get(0) == -1) {
                AbstractResultPacket rs = ReadResultPacketFactory.createResultPacket(byteBuffer);
                ErrorPacket ep = (ErrorPacket)rs;
                throw new QueryException("Could not select database '" + database + "' : " + ep.getMessage(), ep.getErrorNumber(), ep.getSqlState());
            }
            this.database = database;
        }
        catch (IOException e) {
            throw new QueryException("Could not select database '" + database + "' :" + e.getMessage(), -1, ExceptionMapper.SqlStates.CONNECTION_EXCEPTION.getSqlState(), e);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean ping() throws QueryException {
        this.lock.lock();
        try {
            this.checkClose();
            SendPingPacket pingPacket = new SendPingPacket();
            try {
                pingPacket.send(this.writer);
                ByteBuffer byteBuffer = this.packetFetcher.getReusableBuffer();
                boolean bl = byteBuffer.get(0) == 0;
                return bl;
            }
            catch (IOException e) {
                throw new QueryException("Could not ping: " + e.getMessage(), -1, ExceptionMapper.SqlStates.CONNECTION_EXCEPTION.getSqlState(), e);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public AbstractQueryResult executeQuery(Query query) throws QueryException {
        return this.executeQuery(query, false);
    }

    @Override
    public AbstractQueryResult executeQuery(Query query, boolean streaming) throws QueryException {
        query.validate();
        this.moreResults = false;
        SendTextQueryPacket packet = new SendTextQueryPacket(query);
        return this.executeQuery(query, packet, streaming);
    }

    @Override
    public AbstractQueryResult executeQuery(List<Query> queries, boolean streaming, boolean isRewritable, int rewriteOffset) throws QueryException {
        int queriesSend;
        for (Query query : queries) {
            query.validate();
        }
        this.moreResults = false;
        AbstractQueryResult result = null;
        do {
            SendTextQueryPacket packet = new SendTextQueryPacket(queries, isRewritable, rewriteOffset);
            queriesSend = this.sendQuery(packet);
            if (result == null) {
                result = this.result(queries, streaming);
            } else {
                result.addResult(this.result(queries, streaming));
            }
            if (queries.size() != queriesSend) continue;
            return result;
        } while ((queries = queries.subList(queriesSend, queries.size())).size() > 0);
        return result;
    }

    private AbstractQueryResult executeQuery(Object queriesObj, SendTextQueryPacket packet, boolean streaming) throws QueryException {
        this.sendQuery(packet);
        return this.result(queriesObj, streaming);
    }

    private int sendQuery(SendTextQueryPacket packet) throws QueryException {
        this.checkClose();
        try {
            return packet.send(this.writer);
        }
        catch (MaxAllowedPacketException e) {
            if (e.isMustReconnect()) {
                this.connect();
            }
            throw new QueryException("Could not send query: " + e.getMessage(), -1, ExceptionMapper.SqlStates.INTERRUPTED_EXCEPTION.getSqlState(), e);
        }
        catch (IOException e) {
            throw new QueryException("Could not send query: " + e.getMessage(), -1, ExceptionMapper.SqlStates.CONNECTION_EXCEPTION.getSqlState(), e);
        }
    }

    private AbstractQueryResult result(Object queriesObj, boolean streaming) throws QueryException {
        try {
            return this.getResult(queriesObj, streaming, false);
        }
        catch (QueryException qex) {
            if (qex.getCause() instanceof SocketTimeoutException) {
                throw new QueryException("Connection timed out", -1, ExceptionMapper.SqlStates.CONNECTION_EXCEPTION.getSqlState(), qex);
            }
            throw qex;
        }
    }

    @Override
    public AbstractQueryResult getResult(Object queriesObj, boolean streaming, boolean binaryProtocol) throws QueryException {
        AbstractResultPacket resultPacket;
        RawPacket rawPacket = null;
        try {
            rawPacket = this.packetFetcher.getReusableRawPacket();
            resultPacket = ReadResultPacketFactory.createResultPacket(rawPacket.getByteBuffer());
            if (resultPacket.getResultType() == AbstractResultPacket.ResultType.LOCALINFILE) {
                InputStream is;
                if (this.localInfileInputStream == null) {
                    if (!this.getUrlParser().getOptions().allowLocalInfile) {
                        this.writer.writeEmptyPacket(rawPacket.getPacketSeq() + 1);
                        throw new QueryException("Usage of LOCAL INFILE is disabled. To use it enable it via the connection property allowLocalInfile=true", -1, ExceptionMapper.SqlStates.FEATURE_NOT_SUPPORTED.getSqlState());
                    }
                    LocalInfilePacket localInfilePacket = (LocalInfilePacket)resultPacket;
                    String localInfile = localInfilePacket.getFileName();
                    try {
                        URL url = new URL(localInfile);
                        is = url.openStream();
                    }
                    catch (IOException ioe) {
                        try {
                            is = new FileInputStream(localInfile);
                        }
                        catch (FileNotFoundException f) {
                            this.writer.writeEmptyPacket(rawPacket.getPacketSeq() + 1);
                            ReadResultPacketFactory.createResultPacket(this.packetFetcher);
                            throw new QueryException("Could not send file : " + f.getMessage(), -1, "22000", f);
                        }
                    }
                } else {
                    is = this.localInfileInputStream;
                    this.localInfileInputStream = null;
                }
                this.writer.sendFile(is, rawPacket.getPacketSeq() + 1);
                is.close();
                resultPacket = ReadResultPacketFactory.createResultPacket(this.packetFetcher);
            }
        }
        catch (SocketTimeoutException ste) {
            this.close();
            throw new QueryException("Could not read resultset: " + ste.getMessage(), -1, ExceptionMapper.SqlStates.CONNECTION_EXCEPTION.getSqlState(), ste);
        }
        catch (IOException e) {
            try {
                if (this.writer != null && rawPacket != null) {
                    this.writer.writeEmptyPacket(rawPacket.getPacketSeq() + 1);
                    ReadResultPacketFactory.createResultPacket(this.packetFetcher);
                }
            }
            catch (IOException localInfilePacket) {
                // empty catch block
            }
            throw new QueryException("Could not read resultset: " + e.getMessage(), -1, ExceptionMapper.SqlStates.CONNECTION_EXCEPTION.getSqlState(), e);
        }
        switch (resultPacket.getResultType()) {
            case ERROR: {
                this.moreResults = false;
                this.hasWarnings = false;
                ErrorPacket ep = (ErrorPacket)resultPacket;
                throw new QueryException(ep.getMessage(), ep.getErrorNumber(), ep.getSqlState());
            }
            case OK: {
                OkPacket okpacket = (OkPacket)resultPacket;
                this.serverStatus = okpacket.getServerStatus();
                this.moreResults = (this.serverStatus & ServerStatus.MORE_RESULTS_EXISTS) != 0;
                this.hasWarnings = okpacket.getWarnings() > 0;
                UpdateResult updateResult = new UpdateResult(okpacket.getAffectedRows(), okpacket.getWarnings(), okpacket.getMessage(), okpacket.getInsertId());
                return updateResult;
            }
            case RESULTSET: {
                this.hasWarnings = false;
                ResultSetPacket resultSetPacket = (ResultSetPacket)resultPacket;
                try {
                    return this.createQueryResult(resultSetPacket, streaming, binaryProtocol);
                }
                catch (IOException e) {
                    throw new QueryException("Could not read result set: " + e.getMessage(), -1, ExceptionMapper.SqlStates.CONNECTION_EXCEPTION.getSqlState(), e);
                }
            }
        }
        throw new QueryException("Could not parse result", -1, ExceptionMapper.SqlStates.INTERRUPTED_EXCEPTION.getSqlState());
    }

    public AbstractQueryResult executeBatch(List<Query> queries, boolean streaming, boolean isRewritable, int rewriteOffset) throws QueryException {
        this.checkClose();
        for (Query query : queries) {
            query.validate();
        }
        this.moreResults = false;
        SendTextQueryPacket packet = new SendTextQueryPacket(queries, isRewritable, rewriteOffset);
        try {
            packet.send(this.writer);
        }
        catch (MaxAllowedPacketException e) {
            if (e.isMustReconnect()) {
                this.connect();
            }
            throw new QueryException("Could not send query: " + e.getMessage(), -1, ExceptionMapper.SqlStates.INTERRUPTED_EXCEPTION.getSqlState(), e);
        }
        catch (IOException e) {
            throw new QueryException("Could not send query: " + e.getMessage(), -1, ExceptionMapper.SqlStates.CONNECTION_EXCEPTION.getSqlState(), e);
        }
        try {
            return this.getResult(queries, streaming, false);
        }
        catch (QueryException qex) {
            if (qex.getCause() instanceof SocketTimeoutException) {
                throw new QueryException("Connection timed out", -1, ExceptionMapper.SqlStates.CONNECTION_EXCEPTION.getSqlState(), qex);
            }
            throw qex;
        }
    }

    @Override
    public AbstractQueryResult executePreparedQueryAfterFailover(String sql, ParameterHolder[] parameters, PrepareResult oldPrepareResult, MariaDbType[] parameterTypeHeader, boolean isStreaming) throws QueryException {
        PrepareResult prepareResult = this.prepare(sql);
        AbstractQueryResult queryResult = this.executePreparedQuery(sql, parameters, prepareResult, parameterTypeHeader, isStreaming);
        queryResult.setFailureObject(prepareResult);
        return queryResult;
    }

    @Override
    public AbstractQueryResult executePreparedQuery(String sql, ParameterHolder[] parameters, PrepareResult prepareResult, MariaDbType[] parameterTypeHeader, boolean isStreaming) throws QueryException {
        this.checkClose();
        this.moreResults = false;
        try {
            int parameterCount = parameters.length;
            for (int i = 0; i < parameterCount; ++i) {
                if (!parameters[i].isLongData()) continue;
                SendPrepareParameterPacket.send(i, (LongDataParameterHolder)parameters[i], prepareResult.statementId, this.writer);
            }
            SendExecutePrepareStatementPacket packet = new SendExecutePrepareStatementPacket(prepareResult.statementId, parameters, parameterCount, parameterTypeHeader);
            packet.send(this.writer);
        }
        catch (MaxAllowedPacketException e) {
            if (e.isMustReconnect()) {
                this.connect();
            }
            throw new QueryException("Could not send query: " + e.getMessage(), -1, ExceptionMapper.SqlStates.INTERRUPTED_EXCEPTION.getSqlState(), e);
        }
        catch (IOException e) {
            throw new QueryException("Could not send query: " + e.getMessage(), -1, ExceptionMapper.SqlStates.CONNECTION_EXCEPTION.getSqlState(), e);
        }
        try {
            return this.getResult(sql, isStreaming, true);
        }
        catch (QueryException qex) {
            if (qex.getCause() instanceof SocketTimeoutException) {
                throw new QueryException("Connection timed out", -1, ExceptionMapper.SqlStates.CONNECTION_EXCEPTION.getSqlState(), qex);
            }
            throw qex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releasePrepareStatement(String sql, int statementId) throws QueryException {
        this.checkClose();
        this.lock.lock();
        try {
            if (this.urlParser.getOptions().cachePrepStmts && this.prepareStatementCache.containsKey(sql)) {
                PrepareResult pr = (PrepareResult)this.prepareStatementCache.get(sql);
                pr.removeUse();
                if (!pr.hasToBeClose()) {
                    return;
                }
                this.prepareStatementCache.remove(sql);
            }
            SendClosePrepareStatementPacket packet = new SendClosePrepareStatementPacket(statementId);
            try {
                packet.send(this.writer);
            }
            catch (IOException e) {
                throw new QueryException("Could not send query: " + e.getMessage(), -1, ExceptionMapper.SqlStates.CONNECTION_EXCEPTION.getSqlState(), e);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void cancelCurrentQuery() throws QueryException, IOException {
        MasterProtocol copiedProtocol = new MasterProtocol(this.urlParser, new ReentrantLock());
        copiedProtocol.setHostAddress(this.getHostAddress());
        copiedProtocol.connect();
        copiedProtocol.executeQuery(new MariaDbQuery("KILL QUERY " + this.serverThreadId));
        copiedProtocol.close();
    }

    @Override
    public AbstractQueryResult getMoreResults(boolean streaming) throws QueryException {
        if (!this.moreResults) {
            return null;
        }
        return this.getResult(null, streaming, this.activeResult != null ? this.activeResult.isBinaryProtocol() : false);
    }

    @Override
    public boolean hasUnreadData() {
        this.lock.lock();
        try {
            boolean bl = this.activeResult != null;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void setInternalMaxRows(int max) {
        if (this.maxRows != max) {
            this.maxRows = max;
        }
    }

    @Override
    public int getMaxRows() {
        return this.maxRows;
    }

    @Override
    public void setMaxRows(int max) throws QueryException {
        if (this.maxRows != max) {
            if (max == 0) {
                this.executeQuery(new MariaDbQuery("set @@SQL_SELECT_LIMIT=DEFAULT"));
            } else {
                this.executeQuery(new MariaDbQuery("set @@SQL_SELECT_LIMIT=" + max));
            }
            this.maxRows = max;
        }
    }

    @Override
    public void setLocalInfileInputStream(InputStream inputStream) {
        this.localInfileInputStream = inputStream;
    }

    @Override
    public int getTimeout() throws SocketException {
        return this.socket.getSoTimeout();
    }

    @Override
    public void setTimeout(int timeout) throws SocketException {
        this.lock.lock();
        try {
            this.getOptions().socketTimeout = timeout;
            this.socket.setSoTimeout(timeout);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void setTransactionIsolation(int level) throws QueryException {
        this.lock.lock();
        try {
            String query = "SET SESSION TRANSACTION ISOLATION LEVEL";
            switch (level) {
                case 1: {
                    query = query + " READ UNCOMMITTED";
                    break;
                }
                case 2: {
                    query = query + " READ COMMITTED";
                    break;
                }
                case 4: {
                    query = query + " REPEATABLE READ";
                    break;
                }
                case 8: {
                    query = query + " SERIALIZABLE";
                    break;
                }
                default: {
                    throw new QueryException("Unsupported transaction isolation level");
                }
            }
            this.executeQuery(new MariaDbQuery(query));
            this.transactionIsolationLevel = level;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int getTransactionIsolationLevel() {
        return this.transactionIsolationLevel;
    }

    private void checkClose() throws QueryException {
        if (!this.connected) {
            throw new QueryException("Connection is close", 1220, "08000");
        }
    }

    @Override
    public void closeIfActiveResult() {
        if (this.activeResult != null) {
            this.activeResult.close();
        }
    }

    @Override
    public PrepareStatementCache prepareStatementCache() {
        return this.prepareStatementCache;
    }
}

