/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.packet.result;

import java.nio.ByteBuffer;
import org.mariadb.jdbc.internal.packet.result.AbstractResultPacket;

public class OkPacket
extends AbstractResultPacket {
    private final long affectedRows;
    private final long insertId;
    private final short serverStatus;
    private final short warnings;
    private final String message;

    public OkPacket(ByteBuffer byteBuffer) {
        super(byteBuffer);
        byteBuffer.get();
        this.affectedRows = this.getLengthEncodedBinary();
        this.insertId = this.getLengthEncodedBinary();
        this.serverStatus = byteBuffer.getShort();
        this.warnings = byteBuffer.getShort();
        this.message = this.getStringLengthEncodedBytes();
    }

    @Override
    public AbstractResultPacket.ResultType getResultType() {
        return AbstractResultPacket.ResultType.OK;
    }

    public String toString() {
        return "affectedRows = " + this.affectedRows + "&insertId = " + this.insertId + "&serverStatus=" + this.serverStatus + "&warnings=" + this.warnings + "&message=" + this.message;
    }

    public long getAffectedRows() {
        return this.affectedRows;
    }

    public long getInsertId() {
        return this.insertId;
    }

    public short getServerStatus() {
        return this.serverStatus;
    }

    public short getWarnings() {
        return this.warnings;
    }

    public String getMessage() {
        return this.message;
    }
}

