/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.packet.read;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.mariadb.jdbc.internal.packet.read.ReadPacketFetcher;
import org.mariadb.jdbc.internal.packet.result.AbstractResultPacket;
import org.mariadb.jdbc.internal.packet.result.EndOfFilePacket;
import org.mariadb.jdbc.internal.packet.result.ErrorPacket;
import org.mariadb.jdbc.internal.packet.result.LocalInfilePacket;
import org.mariadb.jdbc.internal.packet.result.OkPacket;
import org.mariadb.jdbc.internal.packet.result.ResultSetPacket;

public class ReadResultPacketFactory {
    public static final byte ERROR = -1;
    public static final byte OK = 0;
    public static final byte EOF = -2;
    public static final byte LOCALINFILE = -5;

    private ReadResultPacketFactory() {
    }

    public static AbstractResultPacket createResultPacket(ReadPacketFetcher packetFetcher) throws IOException {
        return ReadResultPacketFactory.createResultPacket(packetFetcher.getReusableBuffer());
    }

    public static AbstractResultPacket createResultPacket(ByteBuffer byteBuffer) throws IOException {
        byte buf = byteBuffer.get(0);
        switch (buf) {
            case -1: {
                return new ErrorPacket(byteBuffer);
            }
            case 0: {
                return new OkPacket(byteBuffer);
            }
            case -2: {
                return new EndOfFilePacket(byteBuffer);
            }
            case -5: {
                return new LocalInfilePacket(byteBuffer);
            }
        }
        return new ResultSetPacket(byteBuffer);
    }
}

