/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.mariadb.jdbc.MariaDbBlob;
import org.mariadb.jdbc.MariaDbClob;
import org.mariadb.jdbc.MariaDbConnection;
import org.mariadb.jdbc.MariaDbResultSetMetaData;
import org.mariadb.jdbc.MariaDbStatement;
import org.mariadb.jdbc.internal.MariaDbType;
import org.mariadb.jdbc.internal.packet.dao.ColumnInformation;
import org.mariadb.jdbc.internal.protocol.Protocol;
import org.mariadb.jdbc.internal.queryresults.AbstractQueryResult;
import org.mariadb.jdbc.internal.queryresults.CachedSelectResult;
import org.mariadb.jdbc.internal.queryresults.ColumnNameMap;
import org.mariadb.jdbc.internal.queryresults.MariaDbValueObject;
import org.mariadb.jdbc.internal.queryresults.NoSuchColumnException;
import org.mariadb.jdbc.internal.queryresults.ResultSetType;
import org.mariadb.jdbc.internal.queryresults.SelectQueryResult;
import org.mariadb.jdbc.internal.queryresults.StreamingSelectResult;
import org.mariadb.jdbc.internal.queryresults.ValueObject;
import org.mariadb.jdbc.internal.util.ExceptionMapper;
import org.mariadb.jdbc.internal.util.dao.QueryException;

public class MariaDbResultSet
implements ResultSet {
    public static final MariaDbResultSet EMPTY = MariaDbResultSet.createEmptyResultSet();
    ColumnNameMap columnNameMap;
    Calendar cal;
    private AbstractQueryResult queryResult;
    private MariaDbStatement statement;
    private Protocol protocol;
    private boolean lastGetWasNull;
    private boolean warningsCleared;

    protected MariaDbResultSet() {
    }

    public MariaDbResultSet(AbstractQueryResult dqr, MariaDbStatement statement, Protocol protocol) {
        this.queryResult = dqr;
        this.statement = statement;
        this.protocol = protocol;
        this.cal = protocol != null ? protocol.getCalendar() : null;
        this.columnNameMap = new ColumnNameMap(dqr.getColumnInformation());
    }

    private static MariaDbResultSet createEmptyResultSet() {
        ColumnInformation[] colList = new ColumnInformation[]{};
        List<ValueObject[]> voList = Collections.emptyList();
        CachedSelectResult qr = new CachedSelectResult(colList, voList, 0);
        return new MariaDbResultSet(qr, null, null);
    }

    static ResultSet createResultSet(String[] columnNames, MariaDbType[] columnTypes, String[][] data, Protocol protocol, boolean findColumnReturnsOne, boolean binaryData) {
        int columnNameLength = columnNames.length;
        ColumnInformation[] columns = new ColumnInformation[columnNameLength];
        for (int i = 0; i < columnNameLength; ++i) {
            columns[i] = ColumnInformation.create(columnNames[i], columnTypes[i]);
        }
        byte[] boolTrue = new byte[]{1};
        byte[] boolFalse = new byte[]{0};
        ArrayList<ValueObject[]> rows = new ArrayList<ValueObject[]>();
        for (String[] rowData : data) {
            ValueObject[] row = new ValueObject[columnNameLength];
            if (rowData.length != columnNameLength) {
                throw new RuntimeException("Number of elements in the row != number of columns :" + rowData.length + " vs " + columnNameLength);
            }
            for (int i = 0; i < columnNameLength; ++i) {
                byte[] bytes;
                if (rowData[i] == null) {
                    bytes = null;
                } else if (columnTypes[i] == MariaDbType.BIT) {
                    bytes = rowData[i].equals("0") ? boolFalse : boolTrue;
                } else {
                    try {
                        bytes = rowData[i].getBytes("UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        bytes = new byte[]{};
                    }
                }
                row[i] = new MariaDbValueObject(bytes, columns[i], protocol.getOptions());
            }
            rows.add(row);
        }
        if (findColumnReturnsOne) {
            return new MariaDbResultSet(new CachedSelectResult(columns, rows, 0), null, protocol){

                @Override
                public int findColumn(String name) {
                    return 1;
                }
            };
        }
        return new MariaDbResultSet(new CachedSelectResult(columns, rows, 0), null, protocol);
    }

    static ResultSet createResultSet(String[] columnNames, MariaDbType[] columnTypes, String[][] data, Protocol protocol) {
        return MariaDbResultSet.createResultSet(columnNames, columnTypes, data, protocol, false, false);
    }

    static ResultSet createResultSet(ColumnInformation[] columns, String[][] data, Protocol protocol, boolean findColumnReturnsOne) {
        int columnLength = columns.length;
        byte[] boolTrue = new byte[]{1};
        byte[] boolFalse = new byte[]{0};
        ArrayList<ValueObject[]> rows = new ArrayList<ValueObject[]>();
        for (String[] rowData : data) {
            ValueObject[] row = new ValueObject[columnLength];
            if (rowData.length != columnLength) {
                throw new RuntimeException("Number of elements in the row != number of columns :" + rowData.length + " vs " + columnLength);
            }
            for (int i = 0; i < columnLength; ++i) {
                byte[] bytes;
                if (rowData[i] == null) {
                    bytes = null;
                } else if (columns[i].getType() == MariaDbType.BIT) {
                    bytes = rowData[i].equals("0") ? boolFalse : boolTrue;
                } else {
                    try {
                        bytes = rowData[i].getBytes("UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        bytes = new byte[]{};
                    }
                }
                row[i] = new MariaDbValueObject(bytes, columns[i], protocol.getOptions());
            }
            rows.add(row);
        }
        if (findColumnReturnsOne) {
            return new MariaDbResultSet(new CachedSelectResult(columns, rows, 0), null, protocol){

                @Override
                public int findColumn(String name) {
                    return 1;
                }
            };
        }
        return new MariaDbResultSet(new CachedSelectResult(columns, rows, 0), null, protocol);
    }

    static ResultSet createResultSet(ColumnInformation[] columns, String[][] data, Protocol protocol) {
        return MariaDbResultSet.createResultSet(columns, data, protocol, false);
    }

    static ResultSet createEmptyGeneratedKeysResultSet(MariaDbConnection connection) {
        String[][] data = new String[][]{};
        return MariaDbResultSet.createResultSet(new String[]{"insert_id"}, new MariaDbType[]{MariaDbType.BIGINT}, data, connection.getProtocol(), true, false);
    }

    static ResultSet createGeneratedKeysResultSet(long lastInsertId, int updateCount, MariaDbConnection connection, boolean binaryData) {
        if (updateCount <= 0) {
            return null;
        }
        int autoIncrementIncrement = 1;
        if (updateCount > 1) {
            autoIncrementIncrement = connection.getAutoIncrementIncrement();
        }
        String[][] data = new String[updateCount][];
        for (int i = 0; i < updateCount; ++i) {
            long id = lastInsertId + (long)(i * autoIncrementIncrement);
            data[i] = new String[]{"" + id};
        }
        return MariaDbResultSet.createResultSet(new String[]{"insert_id"}, new MariaDbType[]{MariaDbType.BIGINT}, data, connection.getProtocol(), true, binaryData);
    }

    static ResultSet createGeneratedKeysResultSet(long[] lastInsertIds, int[] updateCounts, MariaDbConnection connection, boolean binaryData) {
        String[][] data = new String[updateCounts.length][];
        boolean hasSeekAutoIncrement = false;
        int autoIncrementIncrement = 1;
        for (int incr = 0; incr < updateCounts.length; ++incr) {
            int updateCount = updateCounts[incr];
            if (updateCount <= 0) {
                data[incr] = new String[0];
                continue;
            }
            if (updateCount == 1) {
                data[incr] = new String[]{"" + lastInsertIds[incr]};
                continue;
            }
            String[] insertIdsMultiple = new String[updateCount];
            if (!hasSeekAutoIncrement) {
                autoIncrementIncrement = connection.getAutoIncrementIncrement();
                hasSeekAutoIncrement = true;
            }
            for (int i = 0; i < updateCount; ++i) {
                insertIdsMultiple[i] = "" + (lastInsertIds[incr] + (long)(i * autoIncrementIncrement));
            }
            data[incr] = insertIdsMultiple;
        }
        return MariaDbResultSet.createResultSet(new String[]{"insert_id"}, new MariaDbType[]{MariaDbType.BIGINT}, data, connection.getProtocol(), true, binaryData);
    }

    @Override
    public boolean next() throws SQLException {
        try {
            return this.queryResult.getResultSetType() == ResultSetType.SELECT && ((SelectQueryResult)this.queryResult).next();
        }
        catch (IOException ioe) {
            throw new SQLException(ioe);
        }
        catch (QueryException qe) {
            throw new SQLException(qe);
        }
    }

    @Override
    public void close() throws SQLException {
        if (this.queryResult != null) {
            this.queryResult.close();
        }
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.lastGetWasNull;
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        return this.getAsciiStream(this.findColumn(columnLabel));
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        return this.getValueObject(columnIndex).getInputStream();
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        return this.getValueObject(columnIndex).getString(this.cal);
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        return this.getString(this.findColumn(columnLabel));
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        return this.getValueObject(columnIndex).getBinaryInputStream();
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        return this.getBinaryStream(this.findColumn(columnLabel));
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        return this.getValueObject(columnIndex).getInt();
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        return this.getInt(this.findColumn(columnLabel));
    }

    private ValueObject getValueObject(int columnIndex) throws SQLException {
        if (this.queryResult.getResultSetType() == ResultSetType.SELECT) {
            ValueObject vo;
            try {
                vo = ((SelectQueryResult)this.queryResult).getValueObject(columnIndex - 1);
            }
            catch (NoSuchColumnException e) {
                throw ExceptionMapper.getSqlException(e.getMessage(), e);
            }
            this.lastGetWasNull = vo.isNull();
            return vo;
        }
        throw ExceptionMapper.getSqlException("Cannot get data from update-result sets");
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        return this.getLong(this.findColumn(columnLabel));
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        return this.getValueObject(columnIndex).getLong();
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        return this.getFloat(this.findColumn(columnLabel));
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        return this.getValueObject(columnIndex).getFloat();
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        return this.getDouble(this.findColumn(columnLabel));
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        return this.getValueObject(columnIndex).getDouble();
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnLabel), scale);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        return this.getValueObject(columnIndex).getBigDecimal();
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        return this.getValueObject(columnIndex).getBigDecimal();
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        return this.getValueObject(this.findColumn(columnLabel)).getBigDecimal();
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        return this.getBytes(this.findColumn(columnLabel));
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        return this.getValueObject(columnIndex).getBytes();
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        try {
            return this.getValueObject(columnIndex).getDate(this.cal);
        }
        catch (ParseException e) {
            throw ExceptionMapper.getSqlException("Could not parse column as date, was: \"" + this.getValueObject(columnIndex).getString() + "\"", e);
        }
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        return this.getDate(this.findColumn(columnLabel));
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        try {
            return this.getValueObject(columnIndex).getDate(cal);
        }
        catch (ParseException e) {
            throw ExceptionMapper.getSqlException("Could not parse as date");
        }
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        return this.getDate(this.findColumn(columnLabel), cal);
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        try {
            return this.getValueObject(columnIndex).getTime(this.cal);
        }
        catch (ParseException e) {
            throw ExceptionMapper.getSqlException("Could not parse column as time, was: \"" + this.getValueObject(columnIndex).getString() + "\"", e);
        }
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        return this.getTime(this.findColumn(columnLabel));
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        try {
            return this.getValueObject(columnIndex).getTime(cal);
        }
        catch (ParseException e) {
            throw ExceptionMapper.getSqlException("Could not parse time", e);
        }
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        return this.getTime(this.findColumn(columnLabel), cal);
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        return this.getTimestamp(this.findColumn(columnLabel));
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        try {
            Timestamp result = this.getValueObject(columnIndex).getTimestamp(cal);
            if (result == null) {
                return null;
            }
            return new Timestamp(result.getTime());
        }
        catch (ParseException e) {
            throw ExceptionMapper.getSqlException("Could not parse timestamp", e);
        }
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        return this.getTimestamp(this.findColumn(columnLabel), cal);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        try {
            return this.getValueObject(columnIndex).getTimestamp(this.cal);
        }
        catch (ParseException e) {
            throw ExceptionMapper.getSqlException("Could not parse column as timestamp, was: \"" + this.getValueObject(columnIndex).getString() + "\"", e);
        }
    }

    @Override
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        return this.getUnicodeStream(this.findColumn(columnLabel));
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        return this.getValueObject(columnIndex).getInputStream();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        if (this.statement == null || this.warningsCleared) {
            return null;
        }
        return this.statement.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.warningsCleared = true;
    }

    @Override
    public String getCursorName() throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Cursors not supported");
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return new MariaDbResultSetMetaData(this.queryResult.getColumnInformation(), this.protocol.getDataTypeMappingFlags(), this.protocol.getOptions().useOldAliasMetadataBehavior);
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        try {
            return this.getValueObject(columnIndex).getObject(this.protocol.getDataTypeMappingFlags(), this.cal);
        }
        catch (ParseException e) {
            throw ExceptionMapper.getSqlException("Could not get object: " + e.getMessage(), "S1009", e);
        }
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        return this.getObject(this.findColumn(columnLabel));
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        return this.getObject(columnIndex);
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Type map getting is not supported");
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> arg1) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Type getObject getting is not supported");
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> arg1) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Type getObject getting is not supported");
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        if (this.queryResult.getResultSetType() == ResultSetType.SELECT) {
            return this.columnNameMap.getIndex(columnLabel) + 1;
        }
        throw ExceptionMapper.getSqlException("Cannot get column id of update result sets");
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        return this.getCharacterStream(this.findColumn(columnLabel));
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        String value = this.getValueObject(columnIndex).getString();
        if (value == null) {
            return null;
        }
        return new StringReader(value);
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        return this.getCharacterStream(columnIndex);
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        return this.getCharacterStream(columnLabel);
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("The isBeforeFirst() method cannot be used on a closed ResultSet");
        }
        return this.queryResult.getResultSetType() == ResultSetType.SELECT && ((SelectQueryResult)this.queryResult).isBeforeFirst();
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("The isAfterLast() method cannot be used on a closed ResultSet");
        }
        return this.queryResult.getResultSetType() == ResultSetType.SELECT && ((SelectQueryResult)this.queryResult).isAfterLast();
    }

    @Override
    public boolean isFirst() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("The isFirst() method cannot be used on a closed ResultSet");
        }
        if (this.queryResult.getRows() == 0) {
            return false;
        }
        return this.queryResult.getResultSetType() != ResultSetType.MODIFY && ((SelectQueryResult)this.queryResult).getRowPointer() == 0;
    }

    @Override
    public boolean isLast() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("The isLast() method cannot be used on a closed ResultSet");
        }
        if (this.queryResult.getRows() == 0) {
            return false;
        }
        if (this.queryResult.getResultSetType() == ResultSetType.SELECT && this.queryResult instanceof CachedSelectResult) {
            return ((SelectQueryResult)this.queryResult).getRowPointer() == this.queryResult.getRows() - 1;
        }
        throw new SQLFeatureNotSupportedException("isLast is not supported for TYPE_FORWARD_ONLY result sets");
    }

    @Override
    public void beforeFirst() throws SQLException {
        if (this.queryResult.getResultSetType() == ResultSetType.SELECT) {
            if (!(this.queryResult instanceof CachedSelectResult)) {
                throw new SQLException("Invalid operation for result set type TYPE_FORWARD_ONLY");
            }
            ((SelectQueryResult)this.queryResult).moveRowPointerTo(-1);
        }
    }

    @Override
    public void afterLast() throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Cannot move after last row");
    }

    @Override
    public boolean first() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Invalid operation on a closed result set");
        }
        if (this.queryResult.getResultSetType() == ResultSetType.SELECT) {
            if (!(this.queryResult instanceof CachedSelectResult)) {
                throw new SQLException("Invalid operation for result set type TYPE_FORWARD_ONLY");
            }
            if (this.queryResult.getRows() > 0) {
                ((SelectQueryResult)this.queryResult).moveRowPointerTo(0);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean last() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Invalid operation on a closed result set");
        }
        if (this.queryResult.getResultSetType() == ResultSetType.SELECT && this.queryResult.getRows() > 0) {
            ((SelectQueryResult)this.queryResult).moveRowPointerTo(this.queryResult.getRows() - 1);
            return true;
        }
        return false;
    }

    @Override
    public int getRow() throws SQLException {
        if (this.queryResult.getResultSetType() == ResultSetType.SELECT) {
            return ((SelectQueryResult)this.queryResult).getRowPointer() + 1;
        }
        return 0;
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        if (this.queryResult.getResultSetType() != ResultSetType.SELECT) {
            return false;
        }
        SelectQueryResult sqr = (SelectQueryResult)this.queryResult;
        if (sqr.getRows() > 0) {
            if (row >= 0 && row <= sqr.getRows()) {
                sqr.moveRowPointerTo(row - 1);
                return true;
            }
            if (row < 0) {
                sqr.moveRowPointerTo(sqr.getRows() + row);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        int newPos;
        if (this.queryResult.getResultSetType() != ResultSetType.SELECT) {
            return false;
        }
        SelectQueryResult sqr = (SelectQueryResult)this.queryResult;
        if (this.queryResult.getRows() > 0 && (newPos = sqr.getRowPointer() + rows) > -1 && newPos <= this.queryResult.getRows()) {
            sqr.moveRowPointerTo(newPos);
            return true;
        }
        return false;
    }

    @Override
    public boolean previous() throws SQLException {
        if (this.queryResult.getResultSetType() != ResultSetType.SELECT) {
            return false;
        }
        SelectQueryResult sqr = (SelectQueryResult)this.queryResult;
        if (sqr.isBeforeFirst()) {
            return false;
        }
        if (sqr.getRows() >= 0) {
            sqr.moveRowPointerTo(sqr.getRowPointer() - 1);
            return !sqr.isBeforeFirst();
        }
        return false;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 1002;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
    }

    @Override
    public int getFetchSize() throws SQLException {
        return 0;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
    }

    @Override
    public int getType() throws SQLException {
        return this.queryResult instanceof StreamingSelectResult ? 1003 : 1004;
    }

    @Override
    public int getConcurrency() throws SQLException {
        return 1007;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Detecting row updates are not supported");
    }

    @Override
    public boolean rowInserted() throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Detecting inserts are not supported");
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Row deletes are not supported");
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateNull(String columnLabel) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateBoolean(int columnIndex, boolean bool) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateBoolean(String columnLabel, boolean value) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateByte(int columnIndex, byte value) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateByte(String columnLabel, byte value) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateShort(int columnIndex, short value) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateShort(String columnLabel, short value) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateInt(int columnIndex, int value) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateInt(String columnLabel, int value) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateFloat(int columnIndex, float value) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateFloat(String columnLabel, float value) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateDouble(int columnIndex, double value) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateDouble(String columnLabel, double value) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal value) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateBigDecimal(String columnLabel, BigDecimal value) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateString(int columnIndex, String value) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateString(String columnLabel, String value) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateBytes(int columnIndex, byte[] value) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateBytes(String columnLabel, byte[] value) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateDate(int columnIndex, Date date) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateDate(String columnLabel, Date value) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateTime(int columnIndex, Time time) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateTime(String columnLabel, Time value) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp timeStamp) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateTimestamp(String columnLabel, Timestamp value) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream inputStream, int length) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream inputStream) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates not supported");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream value, int length) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream inputStream, long length) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates not supported");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream inputStream, long length) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates not supported");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream inputStream) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates not supported");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream inputStream, int length) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream inputStream, long length) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates not supported");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream value, int length) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream inputStream, long length) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates not supported");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream inputStream) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates not supported");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream inputStream) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates not supported");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader value, int length) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader value) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates not supported");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, int length) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader value, long length) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates not supported");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates not supported");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates not supported");
    }

    @Override
    public void updateObject(int columnIndex, Object value, int scaleOrLength) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateObject(int columnIndex, Object value) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateObject(String columnLabel, Object value, int scaleOrLength) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateObject(String columnLabel, Object value) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateLong(String columnLabel, long value) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateLong(int columnIndex, long value) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void insertRow() throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateRow() throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void deleteRow() throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void refreshRow() throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Row refresh is not supported");
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public Statement getStatement() throws SQLException {
        return this.statement;
    }

    public void setStatement(MariaDbStatement st) {
        this.statement = st;
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public Ref getRef(String columnLabel) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Getting REFs not supported");
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        byte[] bytes = this.getValueObject(columnIndex).getBytes();
        if (bytes == null) {
            return null;
        }
        return new MariaDbBlob(bytes);
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        return this.getBlob(this.findColumn(columnLabel));
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        byte[] bytes = this.getValueObject(columnIndex).getBytes();
        if (bytes == null) {
            return null;
        }
        return new MariaDbClob(bytes);
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        return this.getClob(this.findColumn(columnLabel));
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Arrays are not supported");
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        return this.getArray(this.findColumn(columnLabel));
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        try {
            return new URL(this.getValueObject(columnIndex).getString());
        }
        catch (MalformedURLException e) {
            throw ExceptionMapper.getSqlException("Could not parse as URL");
        }
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        return this.getURL(this.findColumn(columnLabel));
    }

    @Override
    public void updateRef(int columnIndex, Ref ref) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateRef(String columnLabel, Ref ref) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateBlob(int columnIndex, Blob blob) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateBlob(String columnLabel, Blob blob) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates not supported");
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates not supported");
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates not supported");
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates not supported");
    }

    @Override
    public void updateClob(int columnIndex, Clob clob) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateClob(String columnLabel, Clob clob) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates not supported");
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates not supported");
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates not supported");
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates not supported");
    }

    @Override
    public void updateArray(int columnIndex, Array array) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateArray(String columnLabel, Array array) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("RowIDs not supported");
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("RowIDs not supported");
    }

    @Override
    public void updateRowId(int columnIndex, RowId rowId) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateRowId(String columnLabel, RowId rowId) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public int getHoldability() throws SQLException {
        return 1;
    }

    @Override
    public boolean isClosed() throws SQLException {
        if (this.queryResult == null) {
            return true;
        }
        return this.queryResult.isClosed();
    }

    @Override
    public void updateNString(int columnIndex, String nstring) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateNString(String columnLabel, String nstring) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateNClob(int columnIndex, NClob nclob) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateNClob(String columnLabel, NClob nclob) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates not supported");
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates not supported");
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates not supported");
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates not supported");
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("NClobs are not supported");
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("NClobs are not supported");
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("SQLXML not supported");
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("SQLXML not supported");
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("SQLXML not supported");
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("SQLXML not supported");
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("NString not supported");
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("NString not supported");
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader value, long length) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates not supported");
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates not supported");
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader reader) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates not supported");
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates not supported");
    }

    @Override
    public boolean getBoolean(int index) throws SQLException {
        return this.getValueObject(index).getBoolean();
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        return this.getBoolean(this.findColumn(columnLabel));
    }

    @Override
    public byte getByte(int index) throws SQLException {
        return this.getValueObject(index).getByte();
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        return this.getByte(this.findColumn(columnLabel));
    }

    @Override
    public short getShort(int index) throws SQLException {
        return this.getValueObject(index).getShort();
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        return this.getShort(this.findColumn(columnLabel));
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    public MariaDbResultSet joinResultSets(MariaDbResultSet resultSet) throws SQLException {
        int j;
        ColumnInformation[] otherColumnInfo;
        int resultSetColumnNumber;
        ColumnInformation[] columnInfo = this.queryResult.getColumnInformation();
        int thisColumnNumber = columnInfo.length;
        if (thisColumnNumber != (resultSetColumnNumber = (otherColumnInfo = resultSet.queryResult.getColumnInformation()).length)) {
            throw new SQLException("The two result sets do not have the same column number.");
        }
        for (int count = 0; count < columnInfo.length; ++count) {
            if (columnInfo[count].getType() == otherColumnInfo[count].getType()) continue;
            throw new SQLException("The two result sets differ in column types.");
        }
        int rowNumber = this.queryResult.getRows() + resultSet.queryResult.getRows();
        String[][] data = new String[rowNumber][columnInfo.length];
        int rowNumberCounter = 0;
        this.beforeFirst();
        while (this.next()) {
            for (j = 0; j < columnInfo.length; ++j) {
                data[rowNumberCounter][j] = this.getString(j + 1);
            }
            ++rowNumberCounter;
        }
        resultSet.beforeFirst();
        while (resultSet.next()) {
            for (j = 0; j < columnInfo.length; ++j) {
                data[rowNumberCounter][j] = resultSet.getString(j + 1);
            }
            ++rowNumberCounter;
        }
        return (MariaDbResultSet)MariaDbResultSet.createResultSet(columnInfo, data, this.protocol);
    }

    public MariaDbResultSet joinResultSets(MariaDbResultSet[] resultSets) throws SQLException {
        MariaDbResultSet result = null;
        for (MariaDbResultSet resultSet : resultSets) {
            result = this.joinResultSets(resultSet);
        }
        return result;
    }
}

