/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.util;

import com.avaje.ebean.config.GlobalProperties;
import com.avaje.ebeaninternal.api.ClassUtil;
import com.avaje.ebeaninternal.server.util.ClassPathReader;
import com.avaje.ebeaninternal.server.util.ClassPathSearchFilter;
import com.avaje.ebeaninternal.server.util.ClassPathSearchMatcher;
import com.avaje.ebeaninternal.server.util.DefaultClassPathReader;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassPathSearch {
    private static final Logger logger = LoggerFactory.getLogger(ClassPathSearch.class);
    private ClassLoader classLoader;
    private List<Object> classPath = new ArrayList<Object>();
    private ClassPathSearchFilter filter;
    private ClassPathSearchMatcher matcher;
    private ArrayList<Class<?>> matchList = new ArrayList();
    private HashSet<String> jarHits = new HashSet();
    private HashSet<String> packageHits = new HashSet();
    private ClassPathReader classPathReader = new DefaultClassPathReader();
    private ArrayList<URI> scannedUris = new ArrayList();

    public ClassPathSearch(ClassLoader classLoader, ClassPathSearchFilter filter, ClassPathSearchMatcher matcher) {
        this.classLoader = classLoader;
        this.filter = filter;
        this.matcher = matcher;
        this.initClassPaths();
    }

    private void initClassPaths() {
        try {
            Object[] rawClassPaths;
            String cn = GlobalProperties.get("ebean.classpathreader", null);
            if (cn != null) {
                logger.info("Using [" + cn + "] to read the searchable class path");
                this.classPathReader = (ClassPathReader)ClassUtil.newInstance(cn, this.getClass());
            }
            if ((rawClassPaths = this.classPathReader.readPath(this.classLoader)) == null || rawClassPaths.length == 0) {
                logger.warn("ClassPath is EMPTY using ClassPathReader [" + this.classPathReader + "]");
                return;
            }
            for (int i = 0; i < rawClassPaths.length; ++i) {
                List<URI> classPathFromManifest = ClassPathSearch.getClassPathFromManifest(rawClassPaths[i]);
                if (classPathFromManifest.isEmpty()) {
                    this.classPath.add(rawClassPaths[i]);
                    continue;
                }
                this.classPath.addAll(classPathFromManifest);
            }
            if (logger.isDebugEnabled()) {
                for (Object entry : this.classPath) {
                    logger.debug("Classpath Entry: {}", entry);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error trying to read the classpath entries", e);
        }
    }

    public Set<String> getJarHits() {
        return this.jarHits;
    }

    public Set<String> getPackageHits() {
        return this.packageHits;
    }

    private void registerHit(String jarFileName, Class<?> cls) {
        Package pkg;
        if (jarFileName != null) {
            this.jarHits.add(jarFileName);
        }
        if ((pkg = cls.getPackage()) != null) {
            this.packageHits.add(pkg.getName());
        } else {
            this.packageHits.add("");
        }
    }

    public List<Class<?>> findClasses() throws IOException {
        if (this.classPath.isEmpty()) {
            return this.matchList;
        }
        int classPathSize = this.classPath.size();
        for (int i = 0; i < classPathSize; ++i) {
            ClassPathElement element = this.getClassPathElement(this.classPath.get(i));
            if (element.isDirectory()) {
                this.scanDirectory(element);
                continue;
            }
            if (element.isJarOrWar()) {
                if (classPathSize != 1 && !this.filter.isSearchJar(element.getJarNameWithOffset())) continue;
                this.scanJar(element);
                continue;
            }
            logger.error("Error: expected classPath entry [" + element + "] to be a directory or a .jar file but it is not either of those?");
        }
        if (this.matchList.isEmpty()) {
            logger.warn("No Entities found in ClassPath using ClassPathReader [" + this.classPathReader + "] Classpath Searched[" + this.classPath + "]");
        }
        return this.matchList;
    }

    private ClassPathElement getClassPathElement(Object classPathEntry) throws MalformedURLException {
        URL fileUrl = null;
        if (URI.class.isInstance(classPathEntry)) {
            fileUrl = ((URI)classPathEntry).toURL();
        } else {
            if (!URL.class.isInstance(classPathEntry)) {
                return new ClassPathElement(classPathEntry.toString());
            }
            fileUrl = (URL)classPathEntry;
        }
        if (!fileUrl.getPath().contains("!")) {
            return new ClassPathElement(new File(fileUrl.getFile()));
        }
        String[] parts = fileUrl.getPath().split("!");
        String fileName = parts[0];
        String jarOffset = parts[1];
        if (fileName.startsWith("file:")) {
            fileName = fileName.substring("file:".length());
        }
        return new ClassPathElement(new File(fileName), jarOffset);
    }

    private void scanDirectory(ClassPathElement classPathEntry) {
        this.scanDirectory(classPathEntry.classPath);
    }

    private void scanDirectory(File directory) {
        List<String> directoryFiles = this.getDirectoryFiles(directory);
        this.searchFiles(Collections.enumeration(directoryFiles), null, null);
    }

    private void scanUri(URI uri) throws IOException {
        File file;
        if (uri.getScheme().equals("file") && this.scannedUris.add(uri) && (file = new File(uri)).exists()) {
            if (file.isDirectory()) {
                this.scanDirectory(file);
            } else {
                this.scanJar(new ClassPathElement(file));
            }
        }
    }

    private void scanJar(ClassPathElement classPathEntry) throws IOException {
        ZipFile module = null;
        try {
            File file = classPathEntry.classPath;
            module = new JarFile(file);
            List<URI> classPathFromManifest = ClassPathSearch.getClassPathFromManifest(file, ((JarFile)module).getManifest());
            for (URI uri : classPathFromManifest) {
                this.scanUri(uri);
            }
            this.searchFiles(((JarFile)module).entries(), classPathEntry.getJarName(), classPathEntry.jarOffset);
        }
        catch (MalformedURLException ex) {
            throw new IOException("Bad classpath error: ", ex);
        }
        finally {
            if (module != null) {
                try {
                    module.close();
                }
                catch (IOException e) {
                    throw new IOException("Error closing jar", e);
                }
            }
        }
    }

    private List<String> getDirectoryFiles(File classPath) {
        ArrayList<String> fileNameList = new ArrayList<String>();
        Set<String> includePkgs = this.filter.getIncludePackages();
        if (includePkgs.size() > 0) {
            for (String pkg : includePkgs) {
                String relativePath = pkg.replace('.', '/');
                File dir = new File(classPath, relativePath);
                if (!dir.exists()) continue;
                this.recursivelyListDir(fileNameList, dir, new StringBuilder(relativePath));
            }
        } else {
            this.recursivelyListDir(fileNameList, classPath, new StringBuilder());
        }
        return fileNameList;
    }

    private void searchFiles(Enumeration<?> files, String jarFileName, String jarOffset) {
        if (files == null) {
            return;
        }
        if (jarOffset != null) {
            if (jarOffset.startsWith("/")) {
                jarOffset = jarOffset.substring(1);
            }
            if (!jarOffset.endsWith("/")) {
                jarOffset = jarOffset + "/";
            }
        }
        while (files.hasMoreElements()) {
            String className;
            int lastPeriod;
            String pckgName;
            String fileName = files.nextElement().toString();
            if (!fileName.endsWith(".class") || jarOffset != null && !fileName.startsWith(jarOffset)) continue;
            if (jarOffset != null) {
                fileName = fileName.substring(jarOffset.length());
            }
            if (!this.filter.isSearchPackage(pckgName = (lastPeriod = (className = fileName.replace('/', '.').substring(0, fileName.length() - 6)).lastIndexOf(".")) > 0 ? className.substring(0, lastPeriod) : "")) continue;
            try {
                Class<?> theClass = Class.forName(className, false, this.classLoader);
                if (!this.matcher.isMatch(theClass)) continue;
                this.matchList.add(theClass);
                this.registerHit(jarFileName, theClass);
            }
            catch (ClassNotFoundException e) {
                logger.trace("Error searching classpath" + e.getMessage());
            }
            catch (NoClassDefFoundError e) {
                logger.trace("Error searching classpath" + e.getMessage());
            }
        }
    }

    private void recursivelyListDir(List<String> fileNameList, File dir, StringBuilder relativePath) {
        if (!dir.isDirectory()) {
            fileNameList.add(relativePath.toString());
        } else {
            File[] files = dir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                int prevLen = relativePath.length();
                relativePath.append(prevLen == 0 ? "" : "/").append(files[i].getName());
                this.recursivelyListDir(fileNameList, files[i], relativePath);
                relativePath.delete(prevLen, relativePath.length());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static List<URI> getClassPathFromManifest(Object classPathElement) {
        List<URI> list;
        if (!(classPathElement instanceof URL)) return Collections.emptyList();
        File file = new File(((URL)classPathElement).getFile());
        if (file.isDirectory()) {
            return Collections.emptyList();
        }
        JarFile jarFile = new JarFile(file);
        try {
            list = ClassPathSearch.getClassPathFromManifest(file, jarFile.getManifest());
        }
        catch (Throwable throwable) {
            try {
                jarFile.close();
                throw throwable;
            }
            catch (IOException e) {
                return Collections.emptyList();
            }
        }
        jarFile.close();
        return list;
    }

    private static List<URI> getClassPathFromManifest(File jarFile, Manifest manifest) {
        if (manifest == null) {
            return Collections.emptyList();
        }
        ArrayList<URI> list = new ArrayList<URI>();
        String classpathAttribute = manifest.getMainAttributes().getValue(Attributes.Name.CLASS_PATH.toString());
        if (classpathAttribute != null) {
            String[] split;
            for (String path : split = classpathAttribute.split(" ")) {
                try {
                    path = path.trim();
                    if (path.length() <= 0) continue;
                    URI uri = ClassPathSearch.getClassPathEntry(jarFile, path);
                    list.add(uri);
                }
                catch (URISyntaxException e) {
                    logger.warn("Invalid Class-Path entry: " + path);
                }
            }
        }
        return list;
    }

    private static URI getClassPathEntry(File jarFile, String path) throws URISyntaxException {
        URI uri = new URI(path);
        if (uri.isAbsolute()) {
            return uri;
        }
        return new File(jarFile.getParentFile(), path.replace('/', File.separatorChar)).toURI();
    }

    private static File decodePath(File classPath) {
        try {
            String charsetName = Charset.defaultCharset().name();
            String path = URLDecoder.decode(classPath.getAbsolutePath(), charsetName);
            return new File(path);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static class ClassPathElement {
        private final File classPath;
        private final String jarOffset;

        ClassPathElement(String path) {
            this(new File(path));
        }

        ClassPathElement(File file) {
            this(file, null);
        }

        ClassPathElement(File file, String jarOffset) {
            this.classPath = ClassPathSearch.decodePath(file);
            this.jarOffset = jarOffset;
        }

        public String toString() {
            return this.classPath.getAbsolutePath();
        }

        boolean isDirectory() {
            return this.classPath.isDirectory();
        }

        boolean isJarOrWar() {
            return this.classPath.getName().endsWith(".jar") || this.classPath.getName().endsWith(".war");
        }

        String getJarName() {
            return this.classPath.getName();
        }

        String getJarNameWithOffset() {
            return this.jarOffset == null ? this.classPath.getName() : this.classPath.getName() + "!" + this.jarOffset;
        }
    }
}

