/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.query;

import com.avaje.ebean.bean.EntityBean;
import com.avaje.ebean.bean.EntityBeanIntercept;
import com.avaje.ebeaninternal.api.SpiQuery;
import com.avaje.ebeaninternal.server.deploy.BeanProperty;
import com.avaje.ebeaninternal.server.deploy.BeanPropertyAssocMany;
import com.avaje.ebeaninternal.server.deploy.DbReadContext;
import java.sql.SQLException;
import java.util.Set;
import javax.persistence.PersistenceException;

public class SqlBeanLoad {
    private final DbReadContext ctx;
    private final Object bean;
    private final Class<?> type;
    private final Object originalOldValues;
    private final boolean isLazyLoad;
    private final Set<String> excludes;
    private final boolean setOriginalOldValues;
    private final boolean rawSql;

    public SqlBeanLoad(DbReadContext ctx, Class<?> type, Object bean, SpiQuery.Mode queryMode) {
        this.ctx = ctx;
        this.rawSql = ctx.isRawSql();
        this.type = type;
        this.isLazyLoad = queryMode.equals((Object)SpiQuery.Mode.LAZYLOAD_BEAN);
        this.bean = bean;
        if (bean instanceof EntityBean) {
            EntityBeanIntercept ebi = ((EntityBean)bean)._ebean_getIntercept();
            this.excludes = this.isLazyLoad ? ebi.getLoadedProps() : null;
            this.originalOldValues = this.excludes != null ? ebi.getOldValues() : null;
            this.setOriginalOldValues = this.originalOldValues != null;
        } else {
            this.excludes = null;
            this.originalOldValues = null;
            this.setOriginalOldValues = false;
        }
    }

    public boolean isLazyLoad() {
        return this.isLazyLoad;
    }

    public void loadIgnore(int increment) {
        this.ctx.getDataReader().incrementPos(increment);
    }

    public Object load(BeanProperty prop) throws SQLException {
        if (!this.rawSql && prop.isTransient()) {
            return null;
        }
        if (this.bean == null || this.excludes != null && this.excludes.contains(prop.getName()) || this.type != null && !prop.isAssignableFrom(this.type)) {
            prop.loadIgnore(this.ctx);
            return null;
        }
        try {
            Object dbVal = prop.read(this.ctx);
            if (this.isLazyLoad) {
                prop.setValue(this.bean, dbVal);
            } else {
                prop.setValueIntercept(this.bean, dbVal);
            }
            if (this.setOriginalOldValues) {
                prop.setValue(this.originalOldValues, dbVal);
            }
            return dbVal;
        }
        catch (Exception e) {
            String msg = "Error loading on " + prop.getFullBeanName();
            throw new PersistenceException(msg, (Throwable)e);
        }
    }

    public void loadAssocMany(BeanPropertyAssocMany<?> prop) {
    }
}

