/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.query;

import com.avaje.ebean.bean.ObjectGraphNode;
import com.avaje.ebean.config.dbplatform.SqlLimitResponse;
import com.avaje.ebeaninternal.api.HashQueryPlan;
import com.avaje.ebeaninternal.api.HashQueryPlanBuilder;
import com.avaje.ebeaninternal.api.SpiEbeanServer;
import com.avaje.ebeaninternal.server.core.OrmQueryRequest;
import com.avaje.ebeaninternal.server.deploy.BeanProperty;
import com.avaje.ebeaninternal.server.query.CQueryPlanStats;
import com.avaje.ebeaninternal.server.query.SqlTree;
import com.avaje.ebeaninternal.server.type.DataBind;
import com.avaje.ebeaninternal.server.type.DataReader;
import com.avaje.ebeaninternal.server.type.RsetDataReader;
import java.sql.ResultSet;
import java.sql.SQLException;

public class CQueryPlan {
    private final SpiEbeanServer server;
    private final boolean autofetchTuned;
    private final HashQueryPlan hash;
    private final boolean rawSql;
    private final boolean rowNumberIncluded;
    private final String sql;
    private final String logWhereSql;
    private final SqlTree sqlTree;
    private final BeanProperty[] encryptedProps;
    private final CQueryPlanStats stats;
    private final Class<?> beanType;

    public CQueryPlan(OrmQueryRequest<?> request, SqlLimitResponse sqlRes, SqlTree sqlTree, boolean rawSql, String logWhereSql) {
        this.server = request.getServer();
        this.beanType = request.getBeanDescriptor().getBeanType();
        this.stats = new CQueryPlanStats(this, this.server.isCollectQueryOrigins());
        this.hash = request.getQueryPlanHash();
        this.autofetchTuned = request.getQuery().isAutofetchTuned();
        if (sqlRes != null) {
            this.sql = sqlRes.getSql();
            this.rowNumberIncluded = sqlRes.isIncludesRowNumberColumn();
        } else {
            this.sql = null;
            this.rowNumberIncluded = false;
        }
        this.sqlTree = sqlTree;
        this.rawSql = rawSql;
        this.logWhereSql = logWhereSql;
        this.encryptedProps = sqlTree.getEncryptedProps();
    }

    public CQueryPlan(OrmQueryRequest<?> request, String sql, SqlTree sqlTree, boolean rawSql, boolean rowNumberIncluded, String logWhereSql) {
        this.server = request.getServer();
        this.beanType = request.getBeanDescriptor().getBeanType();
        this.stats = new CQueryPlanStats(this, this.server.isCollectQueryOrigins());
        this.hash = this.buildHash(sql, rawSql, rowNumberIncluded, logWhereSql);
        this.autofetchTuned = false;
        this.sql = sql;
        this.sqlTree = sqlTree;
        this.rawSql = rawSql;
        this.rowNumberIncluded = rowNumberIncluded;
        this.logWhereSql = logWhereSql;
        this.encryptedProps = sqlTree.getEncryptedProps();
    }

    private HashQueryPlan buildHash(String sql, boolean rawSql, boolean rowNumberIncluded, String logWhereSql) {
        HashQueryPlanBuilder builder = new HashQueryPlanBuilder();
        builder.add(sql).add(rawSql).add(rowNumberIncluded).add(logWhereSql);
        builder.addRawSql(sql);
        return builder.build();
    }

    public String toString() {
        return this.beanType + " hash:" + this.hash;
    }

    public Class<?> getBeanType() {
        return this.beanType;
    }

    public DataReader createDataReader(ResultSet rset) {
        return new RsetDataReader(rset);
    }

    public void bindEncryptedProperties(DataBind dataBind) throws SQLException {
        if (this.encryptedProps != null) {
            for (int i = 0; i < this.encryptedProps.length; ++i) {
                String key = this.encryptedProps[i].getEncryptKey().getStringValue();
                dataBind.setString(key);
            }
        }
    }

    public boolean isAutofetchTuned() {
        return this.autofetchTuned;
    }

    public HashQueryPlan getHash() {
        return this.hash;
    }

    public String getSql() {
        return this.sql;
    }

    public SqlTree getSqlTree() {
        return this.sqlTree;
    }

    public boolean isRawSql() {
        return this.rawSql;
    }

    public boolean isRowNumberIncluded() {
        return this.rowNumberIncluded;
    }

    public String getLogWhereSql() {
        return this.logWhereSql;
    }

    public void resetStatistics() {
        this.stats.reset();
    }

    public void executionTime(long loadedBeanCount, long timeMicros, ObjectGraphNode objectGraphNode) {
        this.stats.add(loadedBeanCount, timeMicros, objectGraphNode);
        if (objectGraphNode != null) {
            this.server.collectQueryStats(objectGraphNode, loadedBeanCount, timeMicros);
        }
    }

    public CQueryPlanStats.Snapshot getSnapshot(boolean reset) {
        return this.stats.getSnapshot(reset);
    }

    public CQueryPlanStats getQueryStats() {
        return this.stats;
    }

    public long getLastQueryTime() {
        return this.stats.getLastQueryTime();
    }
}

