/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.lib.thread;

import com.avaje.ebeaninternal.server.lib.thread.ThreadPool;
import com.avaje.ebeaninternal.server.lib.thread.Work;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PooledThread
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(PooledThread.class);
    private boolean wasInterrupted;
    private long lastUsedTime;
    private Work work;
    private boolean isStopping;
    private boolean isStopped;
    private Thread thread;
    private ThreadPool threadPool;
    private String name;
    private Object threadMonitor = new Object();
    private Object workMonitor = new Object();
    private int totalWorkCount;
    private long totalWorkExecutionTime;

    protected PooledThread(ThreadPool threadPool, String name, boolean isDaemon, Integer threadPriority) {
        this.name = name;
        this.threadPool = threadPool;
        this.lastUsedTime = System.currentTimeMillis();
        this.thread = new Thread((Runnable)this, name);
        this.thread.setDaemon(isDaemon);
        if (threadPriority != null) {
            this.thread.setPriority(threadPriority);
        }
    }

    public String toString() {
        return this.name;
    }

    protected void start() {
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean assignWork(Work work) {
        Object object = this.workMonitor;
        synchronized (object) {
            this.work = work;
            this.workMonitor.notifyAll();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object = this.workMonitor;
        synchronized (object) {
            while (!this.isStopping) {
                try {
                    if (this.work == null) {
                        this.workMonitor.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.doTheWork();
            }
        }
        object = this.threadMonitor;
        synchronized (object) {
            this.threadMonitor.notifyAll();
        }
        if (logger.isTraceEnabled()) {
            logger.trace("PooledThread [" + this.getName() + "] finished ");
        }
        this.isStopped = true;
    }

    private void doTheWork() {
        long startTime;
        block9: {
            if (this.isStopping) {
                return;
            }
            startTime = System.currentTimeMillis();
            if (this.work != null) {
                try {
                    if (logger.isTraceEnabled()) {
                        logger.trace("start work " + this.work);
                    }
                    this.work.setStartTime(startTime);
                    this.work.getRunnable().run();
                    if (logger.isTraceEnabled()) {
                        logger.trace("finished work " + this.work);
                    }
                }
                catch (Throwable ex) {
                    logger.error(null, ex);
                    if (!this.wasInterrupted) break block9;
                    this.isStopping = true;
                    this.threadPool.removeThread(this);
                    if (logger.isInfoEnabled()) {
                        logger.info("PooledThread [" + this.name + "] removed due to interrupt");
                    }
                    try {
                        this.thread.interrupt();
                    }
                    catch (Exception e) {
                        logger.error("Error interrupting PooledThead[" + this.name + "]", (Throwable)e);
                    }
                    return;
                }
            }
        }
        this.lastUsedTime = System.currentTimeMillis();
        ++this.totalWorkCount;
        this.totalWorkExecutionTime = this.totalWorkExecutionTime + this.lastUsedTime - startTime;
        this.work = null;
        this.threadPool.returnThread(this);
    }

    public void interrupt() {
        this.wasInterrupted = true;
        try {
            if (logger.isTraceEnabled()) {
                logger.trace("interrupt()");
            }
            this.thread.interrupt();
        }
        catch (SecurityException ex) {
            this.wasInterrupted = false;
            throw ex;
        }
    }

    public boolean isStopped() {
        return this.isStopped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stop() {
        this.isStopping = true;
        Object object = this.threadMonitor;
        synchronized (object) {
            this.assignWork(null);
            if (logger.isTraceEnabled()) {
                logger.trace("stopping thread [" + this.name + "]");
            }
            try {
                this.threadMonitor.wait(10000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.thread = null;
        this.threadPool.removeThread(this);
    }

    public String getName() {
        return this.name;
    }

    public Work getWork() {
        return this.work;
    }

    public int getTotalWorkCount() {
        return this.totalWorkCount;
    }

    public long getTotalWorkExecutionTime() {
        return this.totalWorkExecutionTime;
    }

    public long getLastUsedTime() {
        return this.lastUsedTime;
    }
}

