/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.lib.sql;

import com.avaje.ebean.config.GlobalProperties;
import com.avaje.ebeaninternal.server.lib.sql.DataSourceAlert;
import com.avaje.ebeaninternal.server.lib.util.MailEvent;
import com.avaje.ebeaninternal.server.lib.util.MailListener;
import com.avaje.ebeaninternal.server.lib.util.MailMessage;
import com.avaje.ebeaninternal.server.lib.util.MailSender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleDataSourceAlert
implements DataSourceAlert,
MailListener {
    private static final Logger logger = LoggerFactory.getLogger(SimpleDataSourceAlert.class);

    @Override
    public void handleEvent(MailEvent event) {
        Throwable e = event.getError();
        if (e != null) {
            logger.error(null, e);
        }
    }

    @Override
    public void dataSourceDown(String dataSourceName) {
        String msg = this.getSubject(true, dataSourceName);
        this.sendMessage(msg, msg);
    }

    @Override
    public void dataSourceUp(String dataSourceName) {
        String msg = this.getSubject(false, dataSourceName);
        this.sendMessage(msg, msg);
    }

    @Override
    public void dataSourceWarning(String subject, String msg) {
        this.sendMessage(subject, msg);
    }

    private String getSubject(boolean isDown, String dsName) {
        String msg = "The DataSource " + dsName;
        msg = isDown ? msg + " is DOWN!!" : msg + " is UP.";
        return msg;
    }

    private void sendMessage(String subject, String msg) {
        String mailServerName = GlobalProperties.get("datasource.alert.mailserver", null);
        if (mailServerName == null) {
            return;
        }
        String fromUser = GlobalProperties.get("datasource.alert.fromuser", null);
        String fromEmail = GlobalProperties.get("datasource.alert.fromemail", null);
        String toEmail = GlobalProperties.get("datasource.alert.toemail", null);
        MailMessage data = new MailMessage();
        data.setSender(fromUser, fromEmail);
        data.addBodyLine(msg);
        data.setSubject(subject);
        String[] toList = toEmail.split(",");
        if (toList.length == 0) {
            throw new RuntimeException("alert.toemail has not been set?");
        }
        for (int i = 0; i < toList.length; ++i) {
            data.addRecipient(null, toList[i].trim());
        }
        MailSender sender = new MailSender(mailServerName);
        sender.setMailListener(this);
        sender.sendInBackground(data);
    }
}

