/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.lib.sql;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class PooledConnectionStatistics {
    private final AtomicLong count = new AtomicLong();
    private final AtomicLong errorCount = new AtomicLong();
    private final AtomicLong hwmNanos = new AtomicLong();
    private final AtomicLong totalNanos = new AtomicLong();
    private final AtomicLong collectionStart = new AtomicLong(System.currentTimeMillis());

    public void add(PooledConnectionStatistics other) {
        this.errorCount.addAndGet(other.getErrorCount());
        this.totalNanos.addAndGet(other.totalNanos.get());
        this.count.addAndGet(other.getCount());
        long otherHwm = other.hwmNanos.get();
        if (otherHwm > this.hwmNanos.get()) {
            this.hwmNanos.set(otherHwm);
        }
    }

    public void add(long durationNanos, boolean hasError) {
        if (hasError) {
            this.errorCount.incrementAndGet();
        }
        this.count.incrementAndGet();
        this.totalNanos.addAndGet(durationNanos);
        if (durationNanos > this.hwmNanos.get()) {
            this.hwmNanos.set(durationNanos);
        }
    }

    public String toString() {
        return "count[" + this.count + "] errors[" + this.errorCount + "] totalMicros[" + this.getTotalMicros() + "] hwmMicros[" + this.getHwmMicros() + "]";
    }

    public long getCollectionStart() {
        return this.collectionStart.get();
    }

    public long getCount() {
        return this.count.get();
    }

    public long getErrorCount() {
        return this.errorCount.get();
    }

    public long getTotalMicros() {
        return TimeUnit.MICROSECONDS.convert(this.totalNanos.get(), TimeUnit.NANOSECONDS);
    }

    public long getHwmMicros() {
        return TimeUnit.MICROSECONDS.convert(this.hwmNanos.get(), TimeUnit.NANOSECONDS);
    }

    public LoadValues getValues(boolean reset) {
        LoadValues value = new LoadValues(this.collectionStart.get(), this.count.get(), this.errorCount.get(), this.getHwmMicros(), this.getTotalMicros());
        if (reset) {
            this.count.set(0L);
            this.errorCount.set(0L);
            this.hwmNanos.set(0L);
            this.totalNanos.set(0L);
            this.collectionStart.set(System.currentTimeMillis());
        }
        return value;
    }

    public static class LoadValues {
        private long collectionStart;
        private long count;
        private long errorCount;
        private long hwmMicros;
        private long totalMicros;

        public LoadValues() {
        }

        public LoadValues(long collectionStart, long count, long errorCount, long hwmMicros, long totalMicros) {
            this.collectionStart = collectionStart;
            this.count = count;
            this.errorCount = errorCount;
            this.hwmMicros = hwmMicros;
            this.totalMicros = totalMicros;
        }

        public void plus(LoadValues additional) {
            this.collectionStart = this.collectionStart == 0L ? additional.collectionStart : Math.min(this.collectionStart, additional.collectionStart);
            this.count += additional.count;
            this.errorCount += additional.errorCount;
            this.hwmMicros = Math.max(this.hwmMicros, additional.hwmMicros);
            this.totalMicros += additional.totalMicros;
        }

        public String toString() {
            return "count[" + this.count + "] errors[" + this.errorCount + "] totalMicros[" + this.totalMicros + "] hwmMicros[" + this.hwmMicros + "] avgMicros[" + this.getAvgMicros() + "]";
        }

        public long getCollectionStart() {
            return this.collectionStart;
        }

        public long getCount() {
            return this.count;
        }

        public long getErrorCount() {
            return this.errorCount;
        }

        public long getHwmMicros() {
            return this.hwmMicros;
        }

        public long getTotalMicros() {
            return this.totalMicros;
        }

        public long getAvgMicros() {
            return this.count == 0L ? 0L : this.totalMicros / this.count;
        }
    }
}

