/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.deploy.parse;

import com.avaje.ebean.annotation.CacheStrategy;
import com.avaje.ebean.annotation.EntityConcurrencyMode;
import com.avaje.ebean.annotation.NamedUpdate;
import com.avaje.ebean.annotation.NamedUpdates;
import com.avaje.ebean.annotation.UpdateMode;
import com.avaje.ebean.config.TableName;
import com.avaje.ebeaninternal.server.core.CacheOptions;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptor;
import com.avaje.ebeaninternal.server.deploy.CompoundUniqueContraint;
import com.avaje.ebeaninternal.server.deploy.DeployNamedQuery;
import com.avaje.ebeaninternal.server.deploy.DeployNamedUpdate;
import com.avaje.ebeaninternal.server.deploy.meta.DeployBeanProperty;
import com.avaje.ebeaninternal.server.deploy.parse.AnnotationParser;
import com.avaje.ebeaninternal.server.deploy.parse.DeployBeanInfo;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;

public class AnnotationClass
extends AnnotationParser {
    public AnnotationClass(DeployBeanInfo<?> info) {
        super(info);
    }

    @Override
    public void parse() {
        this.read(this.descriptor.getBeanType());
        this.setTableName();
    }

    private void setTableName() {
        if (this.descriptor.isBaseTableType()) {
            TableName tableName = this.namingConvention.getTableName(this.descriptor.getBeanType());
            this.descriptor.setBaseTable(tableName);
        }
    }

    private void read(Class<?> cls) {
        EntityConcurrencyMode entityConcurrencyMode;
        CacheStrategy cacheStrategy;
        NamedUpdate namedUpdate;
        NamedUpdates namedUpdates;
        NamedQuery namedQuery;
        NamedQueries namedQueries;
        UpdateMode updateMode;
        UniqueConstraint[] uniqueConstraints;
        Table table;
        UniqueConstraint uc;
        Embeddable embeddable;
        Entity entity = cls.getAnnotation(Entity.class);
        if (entity != null) {
            if (entity.name().equals("")) {
                this.descriptor.setName(cls.getSimpleName());
            } else {
                this.descriptor.setName(entity.name());
            }
        }
        if ((embeddable = cls.getAnnotation(Embeddable.class)) != null) {
            this.descriptor.setEntityType(BeanDescriptor.EntityType.EMBEDDED);
            this.descriptor.setName("Embeddable:" + cls.getSimpleName());
        }
        if ((uc = cls.getAnnotation(UniqueConstraint.class)) != null) {
            this.descriptor.addCompoundUniqueConstraint(new CompoundUniqueContraint(uc.columnNames()));
        }
        if ((table = cls.getAnnotation(Table.class)) != null && (uniqueConstraints = table.uniqueConstraints()) != null) {
            for (UniqueConstraint c : uniqueConstraints) {
                this.descriptor.addCompoundUniqueConstraint(new CompoundUniqueContraint(c.columnNames()));
            }
        }
        if ((updateMode = cls.getAnnotation(UpdateMode.class)) != null) {
            this.descriptor.setUpdateChangesOnly(updateMode.updateChangesOnly());
        }
        if ((namedQueries = cls.getAnnotation(NamedQueries.class)) != null) {
            this.readNamedQueries(namedQueries);
        }
        if ((namedQuery = cls.getAnnotation(NamedQuery.class)) != null) {
            this.readNamedQuery(namedQuery);
        }
        if ((namedUpdates = cls.getAnnotation(NamedUpdates.class)) != null) {
            this.readNamedUpdates(namedUpdates);
        }
        if ((namedUpdate = cls.getAnnotation(NamedUpdate.class)) != null) {
            this.readNamedUpdate(namedUpdate);
        }
        if ((cacheStrategy = cls.getAnnotation(CacheStrategy.class)) != null) {
            this.readCacheStrategy(cacheStrategy);
        }
        if ((entityConcurrencyMode = cls.getAnnotation(EntityConcurrencyMode.class)) != null) {
            this.descriptor.setConcurrencyMode(entityConcurrencyMode.value());
        }
    }

    private void readCacheStrategy(CacheStrategy cacheStrategy) {
        String propName;
        DeployBeanProperty beanProperty;
        CacheOptions cacheOptions = this.descriptor.getCacheOptions();
        cacheOptions.setUseCache(cacheStrategy.useBeanCache());
        cacheOptions.setReadOnly(cacheStrategy.readOnly());
        cacheOptions.setWarmingQuery(cacheStrategy.warmingQuery());
        if (cacheStrategy.naturalKey().length() > 0 && (beanProperty = this.descriptor.getBeanProperty(propName = cacheStrategy.naturalKey().trim())) != null) {
            beanProperty.setNaturalKey(true);
            cacheOptions.setNaturalKey(propName);
        }
    }

    private void readNamedQueries(NamedQueries namedQueries) {
        NamedQuery[] queries = namedQueries.value();
        for (int i = 0; i < queries.length; ++i) {
            this.readNamedQuery(queries[i]);
        }
    }

    private void readNamedQuery(NamedQuery namedQuery) {
        DeployNamedQuery q = new DeployNamedQuery(namedQuery);
        this.descriptor.add(q);
    }

    private void readNamedUpdates(NamedUpdates updates) {
        NamedUpdate[] updateArray = updates.value();
        for (int i = 0; i < updateArray.length; ++i) {
            this.readNamedUpdate(updateArray[i]);
        }
    }

    private void readNamedUpdate(NamedUpdate update) {
        DeployNamedUpdate upd = new DeployNamedUpdate(update);
        this.descriptor.add(upd);
    }
}

