/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.deploy;

import com.avaje.ebean.EbeanServer;
import com.avaje.ebean.Query;
import com.avaje.ebean.Transaction;
import com.avaje.ebean.bean.BeanCollection;
import com.avaje.ebean.bean.BeanCollectionAdd;
import com.avaje.ebean.bean.BeanCollectionLoader;
import com.avaje.ebean.common.BeanList;
import com.avaje.ebeaninternal.server.deploy.BeanCollectionHelp;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptor;
import com.avaje.ebeaninternal.server.deploy.BeanPropertyAssocMany;
import com.avaje.ebeaninternal.server.text.json.WriteJsonContext;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class BeanListHelp<T>
implements BeanCollectionHelp<T> {
    private final BeanPropertyAssocMany<T> many;
    private final BeanDescriptor<T> targetDescriptor;
    private BeanCollectionLoader loader;

    public BeanListHelp(BeanPropertyAssocMany<T> many) {
        this.many = many;
        this.targetDescriptor = many.getTargetDescriptor();
    }

    public BeanListHelp() {
        this.many = null;
        this.targetDescriptor = null;
    }

    @Override
    public void setLoader(BeanCollectionLoader loader) {
        this.loader = loader;
    }

    @Override
    public void add(BeanCollection<?> collection, Object bean) {
        collection.internalAdd(bean);
    }

    @Override
    public BeanCollectionAdd getBeanCollectionAdd(Object bc, String mapKey) {
        if (bc instanceof BeanList) {
            BeanList bl = (BeanList)bc;
            if (bl.getActualList() == null) {
                bl.setActualList(new ArrayList());
            }
            return bl;
        }
        if (bc instanceof List) {
            return new VanillaAdd((List)bc);
        }
        throw new RuntimeException("Unhandled type " + bc);
    }

    @Override
    public Iterator<?> getIterator(Object collection) {
        return ((List)collection).iterator();
    }

    @Override
    public Object createEmpty(boolean vanilla) {
        if (vanilla) {
            return new ArrayList();
        }
        BeanList beanList = new BeanList();
        if (this.many != null) {
            beanList.setModifyListening(this.many.getModifyListenMode());
        }
        return beanList;
    }

    @Override
    public BeanCollection<T> createReference(Object parentBean, String propertyName) {
        BeanList beanList = new BeanList(this.loader, parentBean, propertyName);
        beanList.setModifyListening(this.many.getModifyListenMode());
        return beanList;
    }

    @Override
    public void refresh(EbeanServer server, Query<?> query, Transaction t, Object parentBean) {
        BeanList newBeanList = (BeanList)server.findList(query, t);
        this.refresh(newBeanList, parentBean);
    }

    @Override
    public void refresh(BeanCollection<?> bc, Object parentBean) {
        BeanList newBeanList = (BeanList)bc;
        List currentList = (List)this.many.getValue(parentBean);
        newBeanList.setModifyListening(this.many.getModifyListenMode());
        if (currentList == null) {
            this.many.setValue(parentBean, newBeanList);
        } else if (currentList instanceof BeanList) {
            BeanList currentBeanList = (BeanList)currentList;
            currentBeanList.setActualList(newBeanList.getActualList());
            currentBeanList.setModifyListening(this.many.getModifyListenMode());
        } else {
            this.many.setValue(parentBean, newBeanList);
        }
    }

    @Override
    public void jsonWrite(WriteJsonContext ctx, String name, Object collection, boolean explicitInclude) {
        List list;
        if (collection instanceof BeanCollection) {
            BeanList beanList = (BeanList)collection;
            if (!beanList.isPopulated()) {
                if (explicitInclude) {
                    beanList.size();
                } else {
                    return;
                }
            }
            list = beanList.getActualList();
        } else {
            list = (List)collection;
        }
        ctx.beginAssocMany(name);
        for (int j = 0; j < list.size(); ++j) {
            if (j > 0) {
                ctx.appendComma();
            }
            Object detailBean = list.get(j);
            this.targetDescriptor.jsonWrite(ctx, detailBean);
        }
        ctx.endAssocMany();
    }

    static class VanillaAdd
    implements BeanCollectionAdd {
        private final List list;

        private VanillaAdd(List<?> list) {
            this.list = list;
        }

        @Override
        public void addBean(Object bean) {
            this.list.add(bean);
        }
    }
}

