/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.core;

import com.avaje.ebean.meta.MetaBeanInfo;
import com.avaje.ebean.meta.MetaInfoManager;
import com.avaje.ebean.meta.MetaObjectGraphNodeStats;
import com.avaje.ebean.meta.MetaQueryPlanStatistic;
import com.avaje.ebeaninternal.server.core.CObjectGraphNodeStatistics;
import com.avaje.ebeaninternal.server.core.DefaultServer;
import java.util.ArrayList;
import java.util.List;

public class DefaultMetaInfoManager
implements MetaInfoManager {
    private final DefaultServer server;

    public DefaultMetaInfoManager(DefaultServer server) {
        this.server = server;
    }

    @Override
    public MetaBeanInfo getMetaBeanInfo(Class<?> beanClass) {
        return this.server.getBeanDescriptor(beanClass);
    }

    @Override
    public List<MetaBeanInfo> getMetaBeanInfoList() {
        return new ArrayList<MetaBeanInfo>(this.server.getBeanDescriptors());
    }

    @Override
    public List<MetaQueryPlanStatistic> collectQueryPlanStatistics(boolean reset) {
        ArrayList<MetaQueryPlanStatistic> list = new ArrayList<MetaQueryPlanStatistic>();
        for (MetaBeanInfo metaBeanInfo : this.getMetaBeanInfoList()) {
            list.addAll(metaBeanInfo.collectQueryPlanStatistics(reset));
        }
        return list;
    }

    @Override
    public List<MetaObjectGraphNodeStats> collectNodeStatistics(boolean reset) {
        ArrayList<MetaObjectGraphNodeStats> list = new ArrayList<MetaObjectGraphNodeStats>();
        for (CObjectGraphNodeStatistics nodeStatistics : this.server.objectGraphStats.values()) {
            MetaObjectGraphNodeStats nodeStats = nodeStatistics.get(reset);
            if (nodeStats.getCount() <= 0L) continue;
            list.add(nodeStats);
        }
        return list;
    }
}

