/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.core;

import com.avaje.ebean.config.ServerConfig;
import com.avaje.ebean.config.dbplatform.DB2Platform;
import com.avaje.ebean.config.dbplatform.DatabasePlatform;
import com.avaje.ebean.config.dbplatform.H2Platform;
import com.avaje.ebean.config.dbplatform.HsqldbPlatform;
import com.avaje.ebean.config.dbplatform.MsSqlServer2000Platform;
import com.avaje.ebean.config.dbplatform.MsSqlServer2005Platform;
import com.avaje.ebean.config.dbplatform.MySqlPlatform;
import com.avaje.ebean.config.dbplatform.Oracle10Platform;
import com.avaje.ebean.config.dbplatform.Oracle9Platform;
import com.avaje.ebean.config.dbplatform.PostgresPlatform;
import com.avaje.ebean.config.dbplatform.SQLitePlatform;
import com.avaje.ebean.config.dbplatform.SqlAnywherePlatform;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import javax.persistence.PersistenceException;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabasePlatformFactory {
    private static final Logger logger = LoggerFactory.getLogger(DatabasePlatformFactory.class);

    public DatabasePlatform create(ServerConfig serverConfig) {
        try {
            if (serverConfig.getDatabasePlatformName() != null) {
                return this.byDatabaseName(serverConfig.getDatabasePlatformName());
            }
            if (serverConfig.getDataSourceConfig().isOffline()) {
                String m = "You must specify a DatabasePlatformName when you are offline";
                throw new PersistenceException(m);
            }
            return this.byDataSource(serverConfig.getDataSource());
        }
        catch (Exception ex) {
            throw new PersistenceException((Throwable)ex);
        }
    }

    private DatabasePlatform byDatabaseName(String dbName) throws SQLException {
        if ((dbName = dbName.toLowerCase()).equals("postgres83")) {
            return new PostgresPlatform();
        }
        if (dbName.equals("oracle9")) {
            return new Oracle9Platform();
        }
        if (dbName.equals("oracle10")) {
            return new Oracle10Platform();
        }
        if (dbName.equals("oracle")) {
            return new Oracle10Platform();
        }
        if (dbName.equals("sqlserver2005")) {
            return new MsSqlServer2005Platform();
        }
        if (dbName.equals("sqlserver2000")) {
            return new MsSqlServer2000Platform();
        }
        if (dbName.equals("sqlanywhere")) {
            return new SqlAnywherePlatform();
        }
        if (dbName.equals("db2")) {
            return new DB2Platform();
        }
        if (dbName.equals("mysql")) {
            return new MySqlPlatform();
        }
        if (dbName.equals("sqlite")) {
            return new SQLitePlatform();
        }
        throw new RuntimeException("database platform " + dbName + " is not known?");
    }

    private DatabasePlatform byDataSource(DataSource dataSource) {
        Connection conn = null;
        try {
            conn = dataSource.getConnection();
            DatabaseMetaData metaData = conn.getMetaData();
            DatabasePlatform databasePlatform = this.byDatabaseMeta(metaData);
            return databasePlatform;
        }
        catch (SQLException ex) {
            throw new PersistenceException((Throwable)ex);
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException ex) {
                logger.error(null, (Throwable)ex);
            }
        }
    }

    private DatabasePlatform byDatabaseMeta(DatabaseMetaData metaData) throws SQLException {
        String dbProductName = metaData.getDatabaseProductName();
        dbProductName = dbProductName.toLowerCase();
        int majorVersion = metaData.getDatabaseMajorVersion();
        if (dbProductName.contains("oracle")) {
            if (majorVersion > 9) {
                return new Oracle10Platform();
            }
            return new Oracle9Platform();
        }
        if (dbProductName.contains("microsoft")) {
            if (majorVersion > 8) {
                return new MsSqlServer2005Platform();
            }
            return new MsSqlServer2000Platform();
        }
        if (dbProductName.contains("mysql")) {
            return new MySqlPlatform();
        }
        if (dbProductName.contains("h2")) {
            return new H2Platform();
        }
        if (dbProductName.contains("hsql database engine")) {
            return new HsqldbPlatform();
        }
        if (dbProductName.contains("postgres")) {
            return new PostgresPlatform();
        }
        if (dbProductName.contains("sqlite")) {
            return new SQLitePlatform();
        }
        if (dbProductName.contains("db2")) {
            return new DB2Platform();
        }
        if (dbProductName.contains("sql anywhere")) {
            return new SqlAnywherePlatform();
        }
        return new DatabasePlatform();
    }
}

