/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebean.config;

import com.avaje.ebean.config.PropertyMap;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class PropertyExpression {
    private static final Logger logger = LoggerFactory.getLogger(PropertyExpression.class);
    private static final String JAVA_COMP_ENV = "java:comp/env/";
    private static String START = "${";
    private static String END = "}";

    private PropertyExpression() {
    }

    static String eval(String val, PropertyMap map) {
        int ep;
        if (val == null) {
            return null;
        }
        int sp = val.indexOf(START);
        if (sp > -1 && (ep = val.indexOf(END, sp + 1)) > -1) {
            return PropertyExpression.eval(val, sp, ep, map);
        }
        return val;
    }

    private static String evaluateExpression(String exp, PropertyMap map) {
        String val;
        if (PropertyExpression.isJndiExpression(exp) && (val = PropertyExpression.getJndiProperty(exp)) != null) {
            return val;
        }
        val = System.getenv(exp);
        if (val == null) {
            val = System.getProperty(exp);
        }
        if (val == null && map != null) {
            val = map.get(exp);
        }
        if (val != null) {
            return val;
        }
        logger.debug("Unable to evaluate expression [" + exp + "]");
        return null;
    }

    private static String eval(String val, int sp, int ep, PropertyMap map) {
        StringBuilder sb = new StringBuilder();
        sb.append(val.substring(0, sp));
        String cal = PropertyExpression.evalExpression(val, sp, ep, map);
        sb.append(cal);
        PropertyExpression.eval(val, ep + 1, sb, map);
        return sb.toString();
    }

    private static void eval(String val, int startPos, StringBuilder sb, PropertyMap map) {
        int sp;
        if (startPos < val.length() && (sp = val.indexOf(START, startPos)) > -1) {
            sb.append(val.substring(startPos, sp));
            int ep = val.indexOf(END, sp + 1);
            if (ep > -1) {
                String cal = PropertyExpression.evalExpression(val, sp, ep, map);
                sb.append(cal);
                PropertyExpression.eval(val, ep + 1, sb, map);
                return;
            }
        }
        sb.append(val.substring(startPos));
    }

    private static String evalExpression(String val, int sp, int ep, PropertyMap map) {
        String exp = val.substring(sp + START.length(), ep);
        String evaled = PropertyExpression.evaluateExpression(exp, map);
        if (evaled != null) {
            return evaled;
        }
        return START + exp + END;
    }

    private static boolean isJndiExpression(String exp) {
        if (exp.startsWith("JNDI:")) {
            return true;
        }
        return exp.startsWith("jndi:");
    }

    private static String getJndiProperty(String key) {
        try {
            key = key.substring(5);
            return (String)PropertyExpression.getJndiObject(key);
        }
        catch (NamingException ex) {
            return null;
        }
    }

    private static Object getJndiObject(String key) throws NamingException {
        InitialContext ctx = new InitialContext();
        return ctx.lookup(JAVA_COMP_ENV + key);
    }
}

