/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebean;

import com.avaje.ebean.Ebean;
import com.avaje.ebean.EbeanServer;
import com.avaje.ebean.common.BootupEbeanManager;
import com.avaje.ebean.config.GlobalProperties;
import com.avaje.ebean.config.ServerConfig;
import com.avaje.ebean.util.ClassUtil;
import javax.persistence.PersistenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EbeanServerFactory {
    private static final Logger logger = LoggerFactory.getLogger(EbeanServerFactory.class);
    private static BootupEbeanManager serverFactory = EbeanServerFactory.createServerFactory();

    public static EbeanServer create(String name) {
        EbeanServer server = serverFactory.createServer(name);
        return server;
    }

    public static EbeanServer create(ServerConfig config) {
        if (config.getName() == null) {
            throw new PersistenceException("The name is null (it is required)");
        }
        EbeanServer server = serverFactory.createServer(config);
        if (config.isDefaultServer()) {
            GlobalProperties.setSkipPrimaryServer(true);
        }
        if (config.isRegister()) {
            Ebean.register(server, config.isDefaultServer());
        }
        return server;
    }

    private static BootupEbeanManager createServerFactory() {
        String dflt = "com.avaje.ebeaninternal.server.core.DefaultServerFactory";
        String implClassName = GlobalProperties.get("ebean.serverfactory", dflt);
        int delaySecs = GlobalProperties.getInt("ebean.start.delay", 0);
        if (delaySecs > 0) {
            try {
                String m = "Ebean sleeping " + delaySecs + " seconds due to ebean.start.delay";
                logger.info(m);
                Thread.sleep(delaySecs * 1000);
            }
            catch (InterruptedException e) {
                String m = "Interrupting debug.start.delay of " + delaySecs;
                logger.error(m, (Throwable)e);
            }
        }
        try {
            return (BootupEbeanManager)ClassUtil.newInstance(implClassName);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

