/*
 * Decompiled with CFR 0.152.
 */
package tyrex.tm.impl;

import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CosTransactions.Control;
import org.omg.CosTransactions.Coordinator;
import org.omg.CosTransactions.PropagationContext;
import org.omg.CosTransactions.RecoveryCoordinator;
import org.omg.CosTransactions.Resource;
import org.omg.CosTransactions.Status;
import org.omg.CosTransactions.Terminator;
import org.omg.CosTransactions.TransIdentity;
import org.omg.CosTransactions.Unavailable;
import org.omg.CosTransactions._ControlImplBase;
import org.omg.CosTransactions.otid_t;
import tyrex.tm.impl.CoordinatorImpl;
import tyrex.tm.impl.TerminatorImpl;
import tyrex.tm.impl.TransactionImpl;
import tyrex.tm.xid.BaseXid;

final class ControlImpl
extends _ControlImplBase
implements Control,
RecoveryCoordinator {
    protected final TransactionImpl _tx;
    protected final TransIdentity[] _parents;
    private PropagationContext _pgContext;
    private Terminator _terminator;
    private Coordinator _coordinator;

    ControlImpl(TransactionImpl transactionImpl, PropagationContext propagationContext) {
        if (transactionImpl == null) {
            throw new IllegalArgumentException("Argument tx is null");
        }
        if (propagationContext == null) {
            throw new IllegalArgumentException("Argument pgContext is null");
        }
        this._tx = transactionImpl;
        this._parents = new TransIdentity[propagationContext.parents.length + 1];
        int n = propagationContext.parents.length;
        while (n-- > 0) {
            this._parents[n + 1] = propagationContext.parents[n];
        }
        this._parents[0] = propagationContext.current;
    }

    ControlImpl(TransactionImpl transactionImpl) {
        if (transactionImpl == null) {
            throw new IllegalArgumentException("Argument tx is null");
        }
        this._tx = transactionImpl;
        if (transactionImpl.getParent() != null) {
            transactionImpl = (TransactionImpl)transactionImpl.getParent();
            ControlImpl controlImpl = (ControlImpl)transactionImpl.getControl();
            if (controlImpl._parents == null) {
                this._parents = new TransIdentity[]{controlImpl.getIdentity()};
            } else {
                this._parents = new TransIdentity[controlImpl._parents.length + 1];
                int n = controlImpl._parents.length;
                while (n-- > 0) {
                    this._parents[n + 1] = controlImpl._parents[n];
                }
                this._parents[0] = controlImpl.getIdentity();
            }
        } else {
            this._parents = null;
        }
    }

    public Terminator get_terminator() throws Unavailable {
        int n = this._tx.getStatus();
        if (n == 0 || n == 1) {
            return this.getTerminator();
        }
        throw new Unavailable();
    }

    public Coordinator get_coordinator() throws Unavailable {
        int n = this._tx.getStatus();
        if (n == 0 || n == 1) {
            return this.getCoordinator();
        }
        throw new Unavailable();
    }

    protected Terminator getTerminator() {
        if (this._terminator != null) {
            return this._terminator;
        }
        this._terminator = new TerminatorImpl(this);
        ORB oRB = this._tx._txDomain._orb;
        if (oRB != null) {
            oRB.connect((Object)this._terminator);
        }
        return this._terminator;
    }

    protected Coordinator getCoordinator() {
        if (this._coordinator != null) {
            return this._coordinator;
        }
        this._coordinator = new CoordinatorImpl(this);
        ORB oRB = this._tx._txDomain._orb;
        if (oRB != null) {
            oRB.connect((Object)this._coordinator);
        }
        return this._coordinator;
    }

    protected synchronized PropagationContext getPropagationContext() {
        if (this._pgContext != null) {
            return this._pgContext;
        }
        BaseXid baseXid = this._tx._xid;
        byte[] byArray = baseXid.getGlobalTransactionId();
        otid_t otid_t2 = new otid_t(baseXid.getFormatId(), byArray.length, byArray);
        TransIdentity transIdentity = new TransIdentity(this.getCoordinator(), this.getTerminator(), otid_t2);
        ORB oRB = this._tx._txDomain._orb;
        if (oRB == null) {
            this._pgContext = new PropagationContext(this._tx._txDomain.getTransactionTimeout(this._tx), transIdentity, this._parents != null ? this._parents : new TransIdentity[]{}, null);
        } else {
            Any any = oRB.create_any();
            this._pgContext = new PropagationContext(this._tx._txDomain.getTransactionTimeout(this._tx), transIdentity, this._parents != null ? this._parents : new TransIdentity[]{}, any);
        }
        return this._pgContext;
    }

    protected TransIdentity getIdentity() {
        BaseXid baseXid = this._tx._xid;
        byte[] byArray = baseXid.getGlobalTransactionId();
        otid_t otid_t2 = new otid_t(baseXid.getFormatId(), byArray.length, byArray);
        TransIdentity transIdentity = new TransIdentity(this.getCoordinator(), this.getTerminator(), otid_t2);
        return transIdentity;
    }

    protected void deactivate() {
        ORB oRB = this._tx._txDomain._orb;
        if (oRB != null) {
            oRB.disconnect((Object)this);
            if (this._coordinator != null) {
                oRB.disconnect((Object)this._coordinator);
            }
            if (this._terminator != null) {
                oRB.disconnect((Object)this._terminator);
            }
        }
    }

    public Status replay_completion(Resource resource) {
        return CoordinatorImpl.fromJTAStatus(this._tx.getStatus());
    }

    TransactionImpl getTransaction() {
        return this._tx;
    }
}

