/*
 * Decompiled with CFR 0.152.
 */
package humanize.util;

import com.google.common.base.Joiner;
import humanize.spi.context.DefaultContext;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public final class Constants {
    public static final Pattern SPLIT_CAMEL = Pattern.compile("(?<=[A-Z])(?=[A-Z][a-z])|(?<=[^A-Z])(?=[A-Z])|(?<=[A-Za-z])(?=[^A-Za-z])");
    public static final Pattern ONLY_SLUG_CHARS = Pattern.compile("[^-\\w\\s]");
    public static final String DEFAULT_SLUG_SEPARATOR = "-";
    public static final Pattern PUNCTUATION = Pattern.compile("\\p{Punct}+");
    public static final Pattern COMB_DIACRITICAL = Pattern.compile("\\p{InCombiningDiacriticalMarks}+");
    public static final Pattern HYPEN_SPACE = Pattern.compile("[-\\s]+");
    public static final Pattern NOT_IN_BMP = Pattern.compile("([^\u0000-\ud7ff\ue000-\uffff])");
    public static final String SPACE = " ";
    public static final String EMPTY = "";
    public static final String ORDINAL_FMT = "%d%s";
    public static final int ND_FACTOR = 82800000;
    public static final BigDecimal THOUSAND = BigDecimal.valueOf(1000L);
    public static final Map<BigDecimal, String> bigDecExponents = new LinkedHashMap<BigDecimal, String>();
    public static final Map<Long, String> binPrefixes;
    public static final Map<Long, String> metricPrefixes;
    public static final Map<Long, String> nanoTimePrefixes;
    public static final Joiner commaJoiner;
    public static final List<String> titleIgnoredWords;
    public static final Pattern titleWordSperator;

    static {
        bigDecExponents.put(BigDecimal.TEN.pow(3), "thousand");
        bigDecExponents.put(BigDecimal.TEN.pow(6), "million");
        bigDecExponents.put(BigDecimal.TEN.pow(9), "billion");
        bigDecExponents.put(BigDecimal.TEN.pow(12), "trillion");
        bigDecExponents.put(BigDecimal.TEN.pow(15), "quadrillion");
        bigDecExponents.put(BigDecimal.TEN.pow(18), "quintillion");
        bigDecExponents.put(BigDecimal.TEN.pow(21), "sextillion");
        bigDecExponents.put(BigDecimal.TEN.pow(24), "septillion");
        bigDecExponents.put(BigDecimal.TEN.pow(27), "octillion");
        bigDecExponents.put(BigDecimal.TEN.pow(30), "nonillion");
        bigDecExponents.put(BigDecimal.TEN.pow(33), "decillion");
        bigDecExponents.put(BigDecimal.TEN.pow(36), "undecillion");
        bigDecExponents.put(BigDecimal.TEN.pow(39), "duodecillion");
        binPrefixes = new LinkedHashMap<Long, String>();
        binPrefixes.put(0x4000000000000L, "#.## PB");
        binPrefixes.put(0x10000000000L, "#.## TB");
        binPrefixes.put(0x40000000L, "#.## GB");
        binPrefixes.put(0x100000L, "#.## MB");
        binPrefixes.put(1024L, "#.# KB");
        binPrefixes.put(0L, "# bytes");
        metricPrefixes = new LinkedHashMap<Long, String>();
        metricPrefixes.put(1000000000000000L, "#.##P");
        metricPrefixes.put(1000000000000L, "#.##T");
        metricPrefixes.put(1000000000L, "#.##G");
        metricPrefixes.put(1000000L, "#.##M");
        metricPrefixes.put(1000L, "#.#k");
        metricPrefixes.put(0L, "#.#");
        nanoTimePrefixes = new LinkedHashMap<Long, String>();
        nanoTimePrefixes.put(1000000000L, "#.##s");
        nanoTimePrefixes.put(1000000L, "#.###ms");
        nanoTimePrefixes.put(1000L, "#.####\u00b5s");
        nanoTimePrefixes.put(0L, "#.####ns");
        commaJoiner = Joiner.on((String)", ").skipNulls();
        titleIgnoredWords = Arrays.asList("a", "an", "and", "but", "nor", "it", "the", "to", "with", "in", "on", "of", "up", "or", "at", "into", "onto", "by", "from", "then", "for", "via", "versus");
        titleWordSperator = Pattern.compile(".+(\\||-|/).+");
    }

    public static enum TimeStyle {
        STANDARD{

            @Override
            public String format(DefaultContext ctx, boolean neg, int h, int m, int s) {
                return String.format("%s%d:%02d:%02d", neg ? Character.valueOf('-') : Constants.EMPTY, h, m, s);
            }
        }
        ,
        FRENCH_DECIMAL{

            @Override
            public String format(DefaultContext ctx, boolean neg, int h, int m, int s) {
                String r = h == 0 ? (m == 0 ? String.format(Constants.ORDINAL_FMT, s, ctx.timeSuffix(2)) : (s == 0 ? String.format(Constants.ORDINAL_FMT, m, ctx.timeSuffix(1)) : String.format("%d%s %d%s", m, ctx.timeSuffix(1), s, ctx.timeSuffix(2)))) : (m == 0 ? (s == 0 ? String.format(Constants.ORDINAL_FMT, h, ctx.timeSuffix(0)) : String.format("%d%s %d%s", h, ctx.timeSuffix(0), s, ctx.timeSuffix(2))) : (s == 0 ? String.format("%d%s %d%s", h, ctx.timeSuffix(0), m, ctx.timeSuffix(1)) : String.format("%d%s %d%s %d%s", h, ctx.timeSuffix(0), m, ctx.timeSuffix(1), s, ctx.timeSuffix(2))));
                return (neg ? Character.valueOf('-') : Constants.EMPTY) + r;
            }
        };


        public abstract String format(DefaultContext var1, boolean var2, int var3, int var4, int var5);
    }
}

