/*
 * Decompiled with CFR 0.152.
 */
package humanize.text;

import com.google.common.base.Preconditions;
import humanize.text.FormatFactory;
import java.text.Format;
import java.text.MessageFormat;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;

public class ExtendedMessageFormat
extends MessageFormat {
    private static final long serialVersionUID = -2362048321261811743L;
    private static final String DUMMY_PATTERN = "";
    private static final String ESCAPED_QUOTE = "''";
    private static final char START_FMT = ',';
    private static final char END_FE = '}';
    private static final char START_FE = '{';
    private static final char QUOTE = '\'';
    private String toPattern;
    private final Map<String, ? extends FormatFactory> registry;
    private static final char[] SPLIT_CHARS = " \t\n\r\f".toCharArray();

    public ExtendedMessageFormat(String pattern) {
        this(pattern, Locale.getDefault());
    }

    public ExtendedMessageFormat(String pattern, Locale locale) {
        this(pattern, locale, null);
    }

    public ExtendedMessageFormat(String pattern, Locale locale, Map<String, ? extends FormatFactory> registry) {
        super(DUMMY_PATTERN);
        this.setLocale(locale);
        this.registry = registry;
        this.applyPattern(pattern);
    }

    public ExtendedMessageFormat(String pattern, Map<String, ? extends FormatFactory> registry) {
        this(pattern, Locale.getDefault(), registry);
    }

    @Override
    public final void applyPattern(String pattern) {
        if (this.hasRegistry()) {
            super.applyPattern(pattern);
            this.toPattern = super.toPattern();
            return;
        }
        ArrayList<Format> foundFormats = new ArrayList<Format>();
        ArrayList<String> foundDescriptions = new ArrayList<String>();
        StringBuilder stripCustom = new StringBuilder(pattern.length());
        ParsePosition pos = new ParsePosition(0);
        char[] c = pattern.toCharArray();
        int fmtCount = 0;
        while (pos.getIndex() < pattern.length()) {
            char charType = c[pos.getIndex()];
            if ('\'' == charType) {
                this.appendQuotedString(pattern, pos, stripCustom, true);
                continue;
            }
            if ('{' == charType) {
                ++fmtCount;
                this.seekNonWs(pattern, pos);
                int start = pos.getIndex();
                int index = this.readArgumentIndex(pattern, this.next(pos));
                stripCustom.append('{').append(index);
                this.seekNonWs(pattern, pos);
                Format format = null;
                String formatDescription = null;
                if (c[pos.getIndex()] == ',' && (format = this.getFormat(formatDescription = this.parseFormatDescription(pattern, this.next(pos)))) == null) {
                    stripCustom.append(',').append(formatDescription);
                }
                foundFormats.add(format);
                foundDescriptions.add(format == null ? null : formatDescription);
                Preconditions.checkState((foundFormats.size() == fmtCount ? 1 : 0) != 0);
                Preconditions.checkState((foundDescriptions.size() == fmtCount ? 1 : 0) != 0);
                if (c[pos.getIndex()] != '}') {
                    throw new IllegalArgumentException("Unreadable format element at position " + start);
                }
            }
            stripCustom.append(c[pos.getIndex()]);
            this.next(pos);
        }
        super.applyPattern(stripCustom.toString());
        this.toPattern = this.insertFormats(super.toPattern(), foundDescriptions);
        if (this.containsElements(foundFormats)) {
            Format[] origFormats = this.getFormats();
            Iterator it = foundFormats.iterator();
            int i = 0;
            while (it.hasNext()) {
                Format f = (Format)it.next();
                if (f != null) {
                    origFormats[i] = f;
                }
                ++i;
            }
            super.setFormats(origFormats);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExtendedMessageFormat other = (ExtendedMessageFormat)obj;
        if (this.registry == null ? other.registry != null : !this.registry.equals(other.registry)) {
            return false;
        }
        return !(this.toPattern == null ? other.toPattern != null : !this.toPattern.equals(other.toPattern));
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.registry == null ? 0 : this.registry.hashCode());
        result = 31 * result + (this.toPattern == null ? 0 : this.toPattern.hashCode());
        return result;
    }

    @Override
    public void setFormat(int formatElementIndex, Format newFormat) {
        super.setFormat(formatElementIndex, newFormat);
    }

    @Override
    public void setFormatByArgumentIndex(int argumentIndex, Format newFormat) {
        super.setFormatByArgumentIndex(argumentIndex, newFormat);
    }

    @Override
    public void setFormats(Format[] newFormats) {
        super.setFormats(newFormats);
    }

    @Override
    public void setFormatsByArgumentIndex(Format[] newFormats) {
        super.setFormatsByArgumentIndex(newFormats);
    }

    @Override
    public String toPattern() {
        return this.toPattern;
    }

    private StringBuilder appendQuotedString(String pattern, ParsePosition pos, StringBuilder appendTo, boolean escapingOn) {
        int start = pos.getIndex();
        char[] c = pattern.toCharArray();
        if (escapingOn && c[start] == '\'') {
            this.next(pos);
            return appendTo == null ? null : appendTo.append('\'');
        }
        int lastHold = start;
        for (int i = pos.getIndex(); i < pattern.length(); ++i) {
            if (escapingOn && pattern.substring(i).startsWith(ESCAPED_QUOTE)) {
                appendTo.append(c, lastHold, pos.getIndex() - lastHold).append('\'');
                pos.setIndex(i + ESCAPED_QUOTE.length());
                lastHold = pos.getIndex();
                continue;
            }
            switch (c[pos.getIndex()]) {
                case '\'': {
                    this.next(pos);
                    return appendTo == null ? null : appendTo.append(c, lastHold, pos.getIndex() - lastHold);
                }
            }
            this.next(pos);
        }
        throw new IllegalArgumentException("Unterminated quoted string at position " + start);
    }

    private boolean containsElements(Collection<?> coll) {
        return coll != null && !coll.isEmpty();
    }

    private Format getFormat(String desc) {
        if (this.registry != null) {
            FormatFactory factory;
            String name = desc;
            String args = null;
            int i = desc.indexOf(44);
            if (i > 0) {
                name = desc.substring(0, i).trim();
                args = desc.substring(i + 1).trim();
            }
            if ((factory = this.registry.get(name)) != null) {
                return factory.getFormat(name, args, this.getLocale());
            }
        }
        return null;
    }

    private void getQuotedString(String pattern, ParsePosition pos, boolean escapingOn) {
        this.appendQuotedString(pattern, pos, null, escapingOn);
    }

    private boolean hasRegistry() {
        return this.registry == null || this.registry.isEmpty();
    }

    private String insertFormats(String pattern, ArrayList<String> customPatterns) {
        if (!this.containsElements(customPatterns)) {
            return pattern;
        }
        StringBuilder sb = new StringBuilder(pattern.length() * 2);
        ParsePosition pos = new ParsePosition(0);
        int fe = -1;
        int depth = 0;
        do {
            char c;
            if ('\'' == (c = pattern.charAt(pos.getIndex()))) {
                this.appendQuotedString(pattern, pos, sb, false);
                continue;
            }
            if ('{' == c) {
                if (++depth != 1) continue;
                sb.append('{').append(this.readArgumentIndex(pattern, this.next(pos)));
                String customPattern = customPatterns.get(++fe);
                if (customPattern == null) continue;
                sb.append(',').append(customPattern);
                continue;
            }
            if ('}' == c) {
                --depth;
            }
            sb.append(c);
            this.next(pos);
        } while (pos.getIndex() < pattern.length());
        return sb.toString();
    }

    private ParsePosition next(ParsePosition pos) {
        pos.setIndex(pos.getIndex() + 1);
        return pos;
    }

    private String parseFormatDescription(String pattern, ParsePosition pos) {
        int start = pos.getIndex();
        this.seekNonWs(pattern, pos);
        int text = pos.getIndex();
        int depth = 1;
        while (pos.getIndex() < pattern.length()) {
            char charAt = pattern.charAt(pos.getIndex());
            if ('{' == charAt) {
                ++depth;
            } else if ('}' == charAt) {
                if (--depth == 0) {
                    return pattern.substring(text, pos.getIndex());
                }
            } else if ('\'' == charAt) {
                this.getQuotedString(pattern, pos, false);
            }
            this.next(pos);
        }
        throw new IllegalArgumentException("Unterminated format element at position " + start);
    }

    /*
     * Unable to fully structure code
     */
    private int readArgumentIndex(String pattern, ParsePosition pos) {
        start = pos.getIndex();
        this.seekNonWs(pattern, pos);
        result = new StringBuffer();
        error = false;
        while (!error && pos.getIndex() < pattern.length()) {
            c = pattern.charAt(pos.getIndex());
            if (!Character.isWhitespace(c)) ** GOTO lbl-1000
            this.seekNonWs(pattern, pos);
            c = pattern.charAt(pos.getIndex());
            if (c != ',' && c != '}') {
                error = true;
            } else lbl-1000:
            // 2 sources

            {
                if ((c == ',' || c == '}') && result.length() > 0) {
                    try {
                        return Integer.parseInt(result.toString());
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                error = Character.isDigit(c) == false;
                result.append(c);
            }
            this.next(pos);
        }
        if (error) {
            throw new IllegalArgumentException("Invalid format argument index at position " + start + ": " + pattern.substring(start, pos.getIndex()));
        }
        throw new IllegalArgumentException("Unterminated format element at position " + start);
    }

    private void seekNonWs(String pattern, ParsePosition pos) {
        int len = 0;
        char[] buffer = pattern.toCharArray();
        do {
            len = Arrays.binarySearch(SPLIT_CHARS, buffer[pos.getIndex()]) >= 0 ? 1 : 0;
            pos.setIndex(pos.getIndex() + len);
        } while (len > 0 && pos.getIndex() < pattern.length());
    }

    static {
        Arrays.sort(SPLIT_CHARS);
    }
}

