/*
 * Decompiled with CFR 0.152.
 */
package humanize.spi.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheBuilderSpec;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import humanize.config.ConfigLoader;
import humanize.spi.cache.CacheProvider;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;

public class GuavaCacheProvider
implements CacheProvider {
    private static final CacheBuilderSpec spec = GuavaCacheProvider.initSpec();
    private final Cache<Locale, ResourceBundle> bundles = CacheBuilder.from((CacheBuilderSpec)spec).build();
    private final LoadingCache<String, Cache<Locale, Object>> formats = CacheBuilder.from((CacheBuilderSpec)spec).build((CacheLoader)new CacheLoader<String, Cache<Locale, Object>>(){

        public Cache<Locale, Object> load(String cache) throws Exception {
            return CacheBuilder.from((CacheBuilderSpec)spec).build();
        }
    });
    private final LoadingCache<String, Cache<Locale, String[]>> stringCaches = CacheBuilder.from((CacheBuilderSpec)spec).build((CacheLoader)new CacheLoader<String, Cache<Locale, String[]>>(){

        public Cache<Locale, String[]> load(String cache) throws Exception {
            return CacheBuilder.from((CacheBuilderSpec)spec).build();
        }
    });

    private static CacheBuilderSpec initSpec() {
        Properties properties = ConfigLoader.loadProperties();
        return CacheBuilderSpec.parse((String)properties.getProperty("cache.builder.spec"));
    }

    @Override
    public boolean containsBundle(Locale locale) {
        return this.bundles.getIfPresent((Object)locale) != null;
    }

    @Override
    public boolean containsFormat(String cache, Locale locale) {
        return this.getFormatsCache(cache).getIfPresent((Object)locale) != null;
    }

    @Override
    public boolean containsStrings(String cache, Locale locale) {
        return this.getStringCache(cache).getIfPresent((Object)locale) != null;
    }

    @Override
    public ResourceBundle getBundle(Locale locale, Callable<ResourceBundle> getCall) {
        try {
            return (ResourceBundle)this.bundles.get((Object)locale, getCall);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T> T getFormat(String cache, Locale locale, Callable<T> getCall) {
        try {
            return (T)this.getFormatsCache(cache).get((Object)locale, getCall);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String[] getStrings(String cache, Locale locale, Callable<String[]> getCall) {
        try {
            return (String[])this.getStringCache(cache).get((Object)locale, getCall);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ResourceBundle putBundle(Locale locale, ResourceBundle bundle) {
        this.bundles.put((Object)locale, (Object)bundle);
        return bundle;
    }

    @Override
    public <T> T putFormat(String cache, Locale locale, T format) {
        Cache<Locale, T> numberFormatCache = this.getFormatsCache(cache);
        numberFormatCache.put((Object)locale, format);
        return format;
    }

    @Override
    public String[] putStrings(String cache, Locale locale, String[] value) {
        Cache<Locale, String[]> stringCache = this.getStringCache(cache);
        stringCache.put((Object)locale, (Object)value);
        return value;
    }

    private <T> Cache<Locale, T> getFormatsCache(String cache) {
        try {
            return (Cache)this.formats.get((Object)cache);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private Cache<Locale, String[]> getStringCache(String cache) {
        try {
            return (Cache)this.stringCaches.get((Object)cache);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }
}

