/*
 * Decompiled with CFR 0.152.
 */
package play.api.libs.ws.ssl;

import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Date;
import org.apache.commons.codec.binary.Base64;
import org.joda.time.Instant;
import scala.collection.mutable.StringBuilder;
import scala.util.Properties$;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AlgorithmId;
import sun.security.x509.CertificateAlgorithmId;
import sun.security.x509.CertificateIssuerName;
import sun.security.x509.CertificateSerialNumber;
import sun.security.x509.CertificateSubjectName;
import sun.security.x509.CertificateValidity;
import sun.security.x509.CertificateVersion;
import sun.security.x509.CertificateX509Key;
import sun.security.x509.X500Name;
import sun.security.x509.X509CertImpl;
import sun.security.x509.X509CertInfo;

public final class CertificateGenerator$ {
    public static final CertificateGenerator$ MODULE$;

    static {
        new CertificateGenerator$();
    }

    public X509Certificate generateRSAWithSHA256(int keySize, Instant from, int duration) {
        String dn = "CN=localhost, OU=Unit Testing, O=Mavericks, L=Moon Base 1, ST=Cyberspace, C=CY";
        Instant to = from.plus((long)duration);
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
        keyGen.initialize(keySize, new SecureRandom());
        KeyPair pair = keyGen.generateKeyPair();
        return this.generateCertificate(dn, pair, from.toDate(), to.toDate(), "SHA256WithRSA", AlgorithmId.sha256WithRSAEncryption_oid);
    }

    public int generateRSAWithSHA256$default$1() {
        return 2048;
    }

    public Instant generateRSAWithSHA256$default$2() {
        return Instant.now();
    }

    public int generateRSAWithSHA256$default$3() {
        return 5000000;
    }

    public String toPEM(X509Certificate certificate) {
        Base64 encoder = new Base64(64);
        String certBegin = "-----BEGIN CERTIFICATE-----\n";
        String certEnd = "-----END CERTIFICATE-----";
        byte[] derCert = certificate.getEncoded();
        String pemCertPre = new String(encoder.encode(derCert), "UTF-8");
        String pemCert = new StringBuilder().append((Object)certBegin).append((Object)pemCertPre).append((Object)certEnd).toString();
        return pemCert;
    }

    public X509Certificate generateRSAWithMD5(int keySize, Instant from, int duration) {
        String dn = "CN=localhost, OU=Unit Testing, O=Mavericks, L=Moon Base 1, ST=Cyberspace, C=CY";
        Instant to = from.plus((long)duration);
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
        keyGen.initialize(keySize, new SecureRandom());
        KeyPair pair = keyGen.generateKeyPair();
        return this.generateCertificate(dn, pair, from.toDate(), to.toDate(), "MD5WithRSA", AlgorithmId.md5WithRSAEncryption_oid);
    }

    public int generateRSAWithMD5$default$1() {
        return 2048;
    }

    public Instant generateRSAWithMD5$default$2() {
        return Instant.now();
    }

    public int generateRSAWithMD5$default$3() {
        return 5000000;
    }

    public X509Certificate generateCertificate(String dn, KeyPair pair, Date from, Date to, String algorithm2, ObjectIdentifier oid) {
        X509CertInfo info = new X509CertInfo();
        CertificateValidity interval = new CertificateValidity(from, to);
        BigInteger sn = new BigInteger(64, new SecureRandom());
        X500Name owner = new X500Name(dn);
        boolean justName = Properties$.MODULE$.isJavaAtLeast("1.8");
        info.set("validity", interval);
        info.set("serialNumber", new CertificateSerialNumber(sn));
        info.set("subject", justName ? owner : new CertificateSubjectName(owner));
        info.set("issuer", justName ? owner : new CertificateIssuerName(owner));
        info.set("key", new CertificateX509Key(pair.getPublic()));
        info.set("version", new CertificateVersion(2));
        AlgorithmId algo = new AlgorithmId(oid);
        info.set("algorithmID", new CertificateAlgorithmId(algo));
        X509CertImpl cert = new X509CertImpl(info);
        PrivateKey privkey = pair.getPrivate();
        cert.sign(privkey, algorithm2);
        algo = (AlgorithmId)cert.get("x509.algorithm");
        info.set("algorithmID.algorithm", algo);
        cert = new X509CertImpl(info);
        cert.sign(privkey, algorithm2);
        return cert;
    }

    private CertificateGenerator$() {
        MODULE$ = this;
    }
}

