/*
 * Decompiled with CFR 0.152.
 */
package de.regnis.q.sequence;

import de.regnis.q.sequence.QSequenceCommonBlockFactory;
import de.regnis.q.sequence.QSequenceCommonBlocks;
import de.regnis.q.sequence.QSequenceDifferenceBlock;
import de.regnis.q.sequence.core.QSequenceAlgorithm;
import de.regnis.q.sequence.core.QSequenceAssert;
import de.regnis.q.sequence.core.QSequenceCancelledException;
import de.regnis.q.sequence.core.QSequenceException;
import de.regnis.q.sequence.core.QSequenceMedia;
import de.regnis.q.sequence.core.QSequenceSnakeRegister;
import de.regnis.q.sequence.media.QSequenceMediaIndexTransformer;
import java.util.List;

public class QSequenceDifference
implements QSequenceSnakeRegister,
QSequenceCommonBlockFactory {
    private final QSequenceMedia media;
    private final QSequenceMediaIndexTransformer indexTransformer;
    private final boolean[] leftCommonPoints;
    private final boolean[] rightCommonPoints;
    private final int maximumSearchDepth;

    public QSequenceDifference(QSequenceMedia media, QSequenceMediaIndexTransformer indexTransformer) {
        this(media, indexTransformer, Integer.MAX_VALUE);
    }

    public QSequenceDifference(QSequenceMedia media, QSequenceMediaIndexTransformer indexTransformer, int maximumSearchDepth) {
        QSequenceAssert.assertNotNull(media);
        QSequenceAssert.assertNotNull(indexTransformer);
        this.media = media;
        this.indexTransformer = indexTransformer;
        this.leftCommonPoints = new boolean[indexTransformer.getMediaLeftLength()];
        this.rightCommonPoints = new boolean[indexTransformer.getMediaRightLength()];
        this.maximumSearchDepth = maximumSearchDepth;
    }

    public void registerSnake(int leftFrom, int leftTo, int rightFrom, int rightTo) throws QSequenceCancelledException {
        for (int leftIndex = leftFrom; leftIndex <= leftTo; ++leftIndex) {
            QSequenceAssert.assertTrue(!this.leftCommonPoints[this.indexTransformer.getMediaLeftIndex(leftIndex)]);
            this.leftCommonPoints[this.indexTransformer.getMediaLeftIndex((int)leftIndex)] = true;
        }
        for (int rightIndex = rightFrom; rightIndex <= rightTo; ++rightIndex) {
            QSequenceAssert.assertTrue(!this.rightCommonPoints[this.indexTransformer.getMediaRightIndex(rightIndex)]);
            this.rightCommonPoints[this.indexTransformer.getMediaRightIndex((int)rightIndex)] = true;
        }
    }

    public Object createCommonBlock(int leftFrom, int leftTo, int rightFrom, int rightTo) {
        return null;
    }

    public Object createDistinctBlock(int leftFrom, int leftTo, int rightFrom, int rightTo) {
        return new QSequenceDifferenceBlock(leftFrom, leftTo, rightFrom, rightTo);
    }

    public List getBlocks() throws QSequenceException {
        QSequenceAlgorithm algorithm = new QSequenceAlgorithm(this.media, this, this.maximumSearchDepth);
        algorithm.produceSnakesInOrder();
        return QSequenceCommonBlocks.createBlocks(this.leftCommonPoints, this.rightCommonPoints, this);
    }
}

