/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.session.mgt;

import java.util.Collection;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.session.ExpiredSessionException;
import org.apache.shiro.session.InvalidSessionException;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.UnknownSessionException;
import org.apache.shiro.session.mgt.AbstractNativeSessionManager;
import org.apache.shiro.session.mgt.DefaultSessionKey;
import org.apache.shiro.session.mgt.ExecutorServiceSessionValidationScheduler;
import org.apache.shiro.session.mgt.SessionContext;
import org.apache.shiro.session.mgt.SessionKey;
import org.apache.shiro.session.mgt.SessionValidationScheduler;
import org.apache.shiro.session.mgt.ValidatingSession;
import org.apache.shiro.session.mgt.ValidatingSessionManager;
import org.apache.shiro.util.Destroyable;
import org.apache.shiro.util.LifecycleUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractValidatingSessionManager
extends AbstractNativeSessionManager
implements ValidatingSessionManager,
Destroyable {
    private static final Logger log = LoggerFactory.getLogger(AbstractValidatingSessionManager.class);
    public static final long DEFAULT_SESSION_VALIDATION_INTERVAL = 3600000L;
    protected boolean sessionValidationSchedulerEnabled = true;
    protected SessionValidationScheduler sessionValidationScheduler;
    protected long sessionValidationInterval = 3600000L;

    public boolean isSessionValidationSchedulerEnabled() {
        return this.sessionValidationSchedulerEnabled;
    }

    public void setSessionValidationSchedulerEnabled(boolean sessionValidationSchedulerEnabled) {
        this.sessionValidationSchedulerEnabled = sessionValidationSchedulerEnabled;
    }

    public void setSessionValidationScheduler(SessionValidationScheduler sessionValidationScheduler) {
        this.sessionValidationScheduler = sessionValidationScheduler;
    }

    public SessionValidationScheduler getSessionValidationScheduler() {
        return this.sessionValidationScheduler;
    }

    private void enableSessionValidationIfNecessary() {
        SessionValidationScheduler scheduler = this.getSessionValidationScheduler();
        if (this.isSessionValidationSchedulerEnabled() && (scheduler == null || !scheduler.isEnabled())) {
            this.enableSessionValidation();
        }
    }

    public void setSessionValidationInterval(long sessionValidationInterval) {
        this.sessionValidationInterval = sessionValidationInterval;
    }

    public long getSessionValidationInterval() {
        return this.sessionValidationInterval;
    }

    @Override
    protected final Session doGetSession(SessionKey key) throws InvalidSessionException {
        this.enableSessionValidationIfNecessary();
        log.trace("Attempting to retrieve session with key {}", (Object)key);
        Session s = this.retrieveSession(key);
        if (s != null) {
            this.validate(s, key);
        }
        return s;
    }

    protected abstract Session retrieveSession(SessionKey var1) throws UnknownSessionException;

    @Override
    protected Session createSession(SessionContext context) throws AuthorizationException {
        this.enableSessionValidationIfNecessary();
        return this.doCreateSession(context);
    }

    protected abstract Session doCreateSession(SessionContext var1) throws AuthorizationException;

    protected void validate(Session session, SessionKey key) throws InvalidSessionException {
        try {
            this.doValidate(session);
        }
        catch (ExpiredSessionException ese) {
            this.onExpiration(session, ese, key);
            throw ese;
        }
        catch (InvalidSessionException ise) {
            this.onInvalidation(session, ise, key);
            throw ise;
        }
    }

    protected void onExpiration(Session s, ExpiredSessionException ese, SessionKey key) {
        log.trace("Session with id [{}] has expired.", (Object)s.getId());
        this.onExpiration(s);
        this.notifyExpiration(s);
        this.afterExpired(s);
    }

    protected void onExpiration(Session session) {
        this.onChange(session);
    }

    protected void afterExpired(Session session) {
    }

    protected void onInvalidation(Session s, InvalidSessionException ise, SessionKey key) {
        if (ise instanceof ExpiredSessionException) {
            this.onExpiration(s, (ExpiredSessionException)ise, key);
            return;
        }
        log.trace("Session with id [{}] is invalid.", (Object)s.getId());
        this.onStop(s);
        this.notifyStop(s);
        this.afterStopped(s);
    }

    protected void doValidate(Session session) throws InvalidSessionException {
        if (!(session instanceof ValidatingSession)) {
            String msg = "The " + this.getClass().getName() + " implementation only supports validating " + "Session implementations of the " + ValidatingSession.class.getName() + " interface.  " + "Please either implement this interface in your session implementation or override the " + AbstractValidatingSessionManager.class.getName() + ".doValidate(Session) method to perform validation.";
            throw new IllegalStateException(msg);
        }
        ((ValidatingSession)session).validate();
    }

    protected long getTimeout(Session session) {
        return session.getTimeout();
    }

    protected SessionValidationScheduler createSessionValidationScheduler() {
        if (log.isDebugEnabled()) {
            log.debug("No sessionValidationScheduler set.  Attempting to create default instance.");
        }
        ExecutorServiceSessionValidationScheduler scheduler = new ExecutorServiceSessionValidationScheduler(this);
        scheduler.setInterval(this.getSessionValidationInterval());
        if (log.isTraceEnabled()) {
            log.trace("Created default SessionValidationScheduler instance of type [" + scheduler.getClass().getName() + "].");
        }
        return scheduler;
    }

    protected void enableSessionValidation() {
        SessionValidationScheduler scheduler = this.getSessionValidationScheduler();
        if (scheduler == null) {
            scheduler = this.createSessionValidationScheduler();
            this.setSessionValidationScheduler(scheduler);
        }
        if (log.isInfoEnabled()) {
            log.info("Enabling session validation scheduler...");
        }
        scheduler.enableSessionValidation();
        this.afterSessionValidationEnabled();
    }

    protected void afterSessionValidationEnabled() {
    }

    protected void disableSessionValidation() {
        this.beforeSessionValidationDisabled();
        SessionValidationScheduler scheduler = this.getSessionValidationScheduler();
        if (scheduler != null) {
            block4: {
                try {
                    scheduler.disableSessionValidation();
                    if (log.isInfoEnabled()) {
                        log.info("Disabled session validation scheduler.");
                    }
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) break block4;
                    String msg = "Unable to disable SessionValidationScheduler.  Ignoring (shutting down)...";
                    log.debug(msg, (Throwable)e);
                }
            }
            LifecycleUtils.destroy(scheduler);
            this.setSessionValidationScheduler(null);
        }
    }

    protected void beforeSessionValidationDisabled() {
    }

    @Override
    public void destroy() {
        this.disableSessionValidation();
    }

    @Override
    public void validateSessions() {
        if (log.isInfoEnabled()) {
            log.info("Validating all active sessions...");
        }
        int invalidCount = 0;
        Collection<Session> activeSessions = this.getActiveSessions();
        if (activeSessions != null && !activeSessions.isEmpty()) {
            for (Session s : activeSessions) {
                try {
                    DefaultSessionKey key = new DefaultSessionKey(s.getId());
                    this.validate(s, key);
                }
                catch (InvalidSessionException e) {
                    if (log.isDebugEnabled()) {
                        boolean expired = e instanceof ExpiredSessionException;
                        String msg = "Invalidated session with id [" + s.getId() + "]" + (expired ? " (expired)" : " (stopped)");
                        log.debug(msg);
                    }
                    ++invalidCount;
                }
            }
        }
        if (log.isInfoEnabled()) {
            String msg = "Finished session validation.";
            msg = invalidCount > 0 ? msg + "  [" + invalidCount + "] sessions were stopped." : msg + "  No sessions were stopped.";
            log.info(msg);
        }
    }

    protected abstract Collection<Session> getActiveSessions();
}

