/*
 * Decompiled with CFR 0.152.
 */
package scala.concurrent.stm.skel;

import java.util.Arrays;
import scala.Function1;
import scala.Predef$;
import scala.concurrent.stm.NestingLevel;
import scala.concurrent.stm.Txn;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015b!B\u0001\u0003\u0001\u0011Q!\u0001D\"bY2\u0014\u0017mY6MSN$(BA\u0002\u0005\u0003\u0011\u00198.\u001a7\u000b\u0005\u00151\u0011aA:u[*\u0011q\u0001C\u0001\u000bG>t7-\u001e:sK:$(\"A\u0005\u0002\u000bM\u001c\u0017\r\\1\u0016\u0005-a2C\u0001\u0001\r!\ti!#D\u0001\u000f\u0015\ty\u0001#\u0001\u0003mC:<'\"A\t\u0002\t)\fg/Y\u0005\u0003'9\u0011aa\u00142kK\u000e$\b\"B\u000b\u0001\t\u00039\u0012A\u0002\u001fj]&$hh\u0001\u0001\u0015\u0003a\u00012!\u0007\u0001\u001b\u001b\u0005\u0011\u0001CA\u000e\u001d\u0019\u0001!Q!\b\u0001C\u0002y\u0011\u0011!Q\t\u0003?\r\u0002\"\u0001I\u0011\u000e\u0003!I!A\t\u0005\u0003\u000f9{G\u000f[5oOB\u0011\u0001\u0005J\u0005\u0003K!\u00111!\u00118z\u0011\u001d9\u0003A1A\u0005\u000e!\nq\"\u00138ji&\fGnQ1qC\u000eLG/_\u000b\u0002S=\t!&\b\u0002\u0001\u0001#1A\u0006\u0001Q\u0001\u000e%\n\u0001#\u00138ji&\fGnQ1qC\u000eLG/\u001f\u0011\t\u000f9\u0002!\u0019!C\u0007_\u0005\u0001R*\u0019=F[B$\u0018pQ1qC\u000eLG/_\u000b\u0002a=\t\u0011'\b\u0002!\u0001!11\u0007\u0001Q\u0001\u000eA\n\u0011#T1y\u000b6\u0004H/_\"ba\u0006\u001c\u0017\u000e^=!\u0011\u001d)\u0004\u00011A\u0005\nY\nQaX:ju\u0016,\u0012a\u000e\t\u0003AaJ!!\u000f\u0005\u0003\u0007%sG\u000fC\u0004<\u0001\u0001\u0007I\u0011\u0002\u001f\u0002\u0013}\u001b\u0018N_3`I\u0015\fHCA\u001fA!\t\u0001c(\u0003\u0002@\u0011\t!QK\\5u\u0011\u001d\t%(!AA\u0002]\n1\u0001\u001f\u00132\u0011\u0019\u0019\u0005\u0001)Q\u0005o\u00051ql]5{K\u0002Bq!\u0012\u0001A\u0002\u0013%a)A\u0003`I\u0006$\u0018-F\u0001H!\r\u0001\u0003JS\u0005\u0003\u0013\"\u0011Q!\u0011:sCf\u0004B\u0001I&\u001b{%\u0011A\n\u0003\u0002\n\rVt7\r^5p]FBqA\u0014\u0001A\u0002\u0013%q*A\u0005`I\u0006$\u0018m\u0018\u0013fcR\u0011Q\b\u0015\u0005\b\u00036\u000b\t\u00111\u0001H\u0011\u0019\u0011\u0006\u0001)Q\u0005\u000f\u00061q\fZ1uC\u0002BQ\u0001\u0016\u0001\u0005\u0002U\u000bq![:F[B$\u00180F\u0001W!\t\u0001s+\u0003\u0002Y\u0011\t9!i\\8mK\u0006t\u0007\"\u0002.\u0001\t\u00031\u0014\u0001B:ju\u0016DQ\u0001\u0018\u0001\u0005\u0002u\u000b\u0001b]5{K~#S-\u001d\u000b\u0003{yCQaX.A\u0002]\nqA\\3x'&TX\rC\u0003b\u0001\u0011%!-\u0001\u0006dQ\u0006tw-Z*ju\u0016$\"!P2\t\u000b}\u0003\u0007\u0019A\u001c\t\u000b\u0015\u0004A\u0011\u00024\u0002\u000bI,7/\u001a;\u0015\u0003uBQ\u0001\u001b\u0001\u0005\u0002%\f\u0001\u0002\n9mkN$S-\u001d\u000b\u0003{)DQa[4A\u0002)\u000bq\u0001[1oI2,'\u000fC\u0003n\u0001\u0011%a-\u0001\u0003he><\b\"B8\u0001\t\u0003\u0001\u0018!B1qa2LHC\u0001&r\u0011\u0015\u0011h\u000e1\u00018\u0003\u0005I\u0007\"\u0002;\u0001\t\u0003)\u0018\u0001\u00024je\u0016$2!\u0010<}\u0011\u001598\u000f1\u0001y\u0003\u0015aWM^3m!\tI(0D\u0001\u0005\u0013\tYHA\u0001\u0007OKN$\u0018N\\4MKZ,G\u000eC\u0003~g\u0002\u0007!$A\u0002be\u001eDQ\u0001\u001e\u0001\u0005\n}$r!PA\u0001\u0003\u0007\t)\u0001C\u0003x}\u0002\u0007\u0001\u0010C\u0003~}\u0002\u0007!\u0004C\u0003s}\u0002\u0007q\u0007K\u0002\u007f\u0003\u0013\u0001B!a\u0003\u0002\u00125\u0011\u0011Q\u0002\u0006\u0004\u0003\u001fA\u0011AC1o]>$\u0018\r^5p]&!\u00111CA\u0007\u0005\u001d!\u0018-\u001b7sK\u000eDq!a\u0006\u0001\t\u0013\tI\"\u0001\u0006tQ>,H\u000e\u001a$je\u0016$2AVA\u000e\u0011\u00199\u0018Q\u0003a\u0001q\"9\u0011q\u0004\u0001\u0005\u0002\u0005\u0005\u0012\u0001\u0003;sk:\u001c\u0017\r^3\u0015\u0007\u001d\u000b\u0019\u0003\u0003\u0004`\u0003;\u0001\ra\u000e")
public class CallbackList<A> {
    private final int InitialCapacity;
    private final int MaxEmptyCapacity;
    private int _size = 0;
    private Function1<A, BoxedUnit>[] _data = new Function1[128];

    private final int InitialCapacity() {
        return 128;
    }

    private final int MaxEmptyCapacity() {
        return 8192;
    }

    private int _size() {
        return this._size;
    }

    private void _size_$eq(int x$1) {
        this._size = x$1;
    }

    private Function1<A, BoxedUnit>[] _data() {
        return this._data;
    }

    private void _data_$eq(Function1<A, BoxedUnit>[] x$1) {
        this._data = x$1;
    }

    public boolean isEmpty() {
        return this._size() == 0;
    }

    public int size() {
        return this._size();
    }

    public void size_$eq(int newSize) {
        if (newSize != this._size()) {
            this.changeSize(newSize);
        }
    }

    private void changeSize(int newSize) {
        if (newSize < 0 || newSize > this._size()) {
            throw new IllegalArgumentException();
        }
        if (newSize == 0 && this._data().length > 8192) {
            this.reset();
        } else {
            Arrays.fill(this._data(), newSize, this._size(), null);
            this._size_$eq(newSize);
        }
    }

    private void reset() {
        this._data_$eq(new Function1[128]);
        this._size_$eq(0);
    }

    public void $plus$eq(Function1<A, BoxedUnit> handler) {
        if (this._size() == this._data().length) {
            this.grow();
        }
        this._data()[this._size()] = handler;
        this._size_$eq(this._size() + 1);
    }

    private void grow() {
        Function1[] a = new Function1[this._data().length * 2];
        System.arraycopy(this._data(), 0, a, 0, this._data().length);
        this._data_$eq(a);
    }

    public Function1<A, BoxedUnit> apply(int i) {
        return this._data()[i];
    }

    public void fire(NestingLevel level, A arg) {
        if (this._size() > 0) {
            this.fire(level, arg, 0);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void fire(NestingLevel level, A arg, int i) {
        while (i < this._size()) {
            Object object;
            if (!this.shouldFire(level)) return;
            try {
                object = this._data()[i].apply(arg);
            }
            catch (Throwable throwable) {
                Txn.Status s = level.requestRollback(new Txn.UncaughtExceptionCause(throwable));
                Predef$.MODULE$.assert(s instanceof Txn.RolledBack);
                object = BoxedUnit.UNIT;
            }
            ++i;
        }
        return;
    }

    private boolean shouldFire(NestingLevel level) {
        return !(level.status() instanceof Txn.RolledBack);
    }

    /*
     * WARNING - void declaration
     */
    public Function1<A, BoxedUnit>[] truncate(int newSize) {
        Function1<A, BoxedUnit>[] function1Array;
        if (this._size() == newSize) {
            function1Array = null;
        } else {
            void var2_2;
            Function1[] z = new Function1[this._size() - newSize];
            System.arraycopy(this._data(), newSize, z, 0, z.length);
            this.size_$eq(newSize);
            function1Array = var2_2;
        }
        return function1Array;
    }
}

