package kdb;

import java.sql.*;
import java.util.*;

public class SResultSetMetaData extends EResultSetMetaData
{	
	private ArrayList metaList;
	private int columnCountOverride = -1;
	
	public SResultSetMetaData (ArrayList inMetaList)
	{
		metaList = inMetaList;
	}
	
	public void setColumnCount (int i)
	{
		columnCountOverride = i;
	}
	
	public static ArrayList getEmptyMetaData()
	{
		ArrayList aList = new ArrayList();
		Map m = new HashMap();
		aList.add(m);
		return aList;
	}
	
	private void checkMeta () throws SQLException
	{
		if (metaList == null || metaList.size() < 1)
		{
			throw new SQLException("No ResultSetMetaData available");
		}
	}
	
	private void checkColumn (int column) throws SQLException
	{
		if (column > metaList.size() || column < 1)
		{
			throw new SQLException("column index: "+column+" is invalid.");
		}
	}
	
	private void check(int column) throws SQLException
	{
		checkMeta();
		checkColumn(column);
	}
	
	private HashMap getMap (int column)
	{
		HashMap m = (HashMap)metaList.get(column-1);
		return m;
	}
	
	protected String getNullableString(int nullType)
	{
		return "Unknown";
	}

	public int getColumnCount() throws SQLException
	{
		if (columnCountOverride > -1)
		{
			return columnCountOverride;
		}
		checkMeta();
		int colCount = 0;
		return metaList.size();
	}	
	
	public boolean isAutoIncrement(int column) throws SQLException
	{
		check(column);
		HashMap m = getMap(column);
		Boolean b = (Boolean)m.get("autoIncrement");
		if (b == null)
		{
			return false;
		}
		return b.booleanValue();
	}
	
	public int isNullable (int column) throws SQLException
	{
		return 2;
	}
	
	public int getColumnDisplaySize (int column) throws SQLException
	{
		return -1;
	}	
	
	public String getColumnName(int column) throws SQLException
	{
		check(column);
		HashMap m = getMap(column);
		String s = (String)m.get("columnName");
		return s;
	}
	
	public String getColumnTypeName(int column) throws SQLException
	{
		check(column);
		HashMap m = getMap(column);
		String s = (String)m.get("columnTypeName");
		return s;
	}
	
	public String getCatalogName(int column) throws SQLException
	{
		check(column);
		HashMap m = getMap(column);
		String s = (String)m.get("catalogName");
		return s;
	}
	
	public String getSchemaName(int column) throws SQLException
	{
		check(column);
		HashMap m = getMap(column);
		String s = (String)m.get("schemaName");
		return s;
	}
	
	public String getTableName(int column) throws SQLException
	{
		check(column);
		HashMap m = getMap(column);
		String s = (String)m.get("tableName");
		return s;
	}
	
	public int getColumnType (int column) throws SQLException
	{
		return -1;
	}	
	
	public int getPrecision (int column) throws SQLException
	{
		return -1;
	}	
	
	public int getScale (int column) throws SQLException
	{
		return -1;
	}	
	
	public boolean isReadOnly(int column) throws SQLException
	{
		check(column);
		HashMap m = getMap(column);
		Boolean b = (Boolean)m.get("readOnly");
		if (b == null)
		{
			return false;
		}
		return b.booleanValue();
	}
	
	public boolean isWritable(int column) throws SQLException
	{
		check(column);
		HashMap m = getMap(column);
		Boolean b = (Boolean)m.get("writable");
		if (b == null)
		{
			return false;
		}
		return b.booleanValue();
	}
}
