package kdb;

import java.sql.*;
import java.util.*;

public class SResultSet extends EResultSet
{
	private int cursorPos = 0;
	private ArrayList nameValueList;
	private ArrayList metaList;
	
	public SResultSet(ArrayList inMapList, ArrayList inMetaList)
	{
		//System.out.println("Creating new SResultSet: inMapList: " +inMapList+ " inMetaList: " +inMetaList);
		nameValueList = inMapList;
		metaList = inMetaList;
	}
	
	public boolean next() throws SQLException 
	{
		int size = nameValueList.size();
		if (cursorPos >= size)
		{
			return false;	
		}
		++cursorPos;
		return true;
	}
	
	public String getString(int columnIndex) throws SQLException 
	{
		int check = cursorPos - 1;
		if (check >= nameValueList.size() || check < 0)
		{
			throw new SQLException("Invalid cursor state");	
		}
		ArrayList nvs = (ArrayList)nameValueList.get(check);
		if (nvs.size() < (columnIndex-1))
		{
			throw new SQLException("Invalid column index");
		}
		
		ArrayList nv = (ArrayList)nvs.get(columnIndex-1);
		return (String)nv.get(1);
	}
	
	public int getInt (int columnIndex) throws SQLException
	{
		String val = getString(columnIndex);
		return Integer.parseInt(val);
	}
	
	public String getString(String columnName) throws SQLException 
	{
		int check = cursorPos - 1;
		if (check >= nameValueList.size() || check < 0)
		{
			throw new SQLException("Invalid cursor state");	
		}
		
		ArrayList nvs = (ArrayList)nameValueList.get(check);
		for (int i = 0; i < nvs.size(); i++)
		{
			ArrayList nv = (ArrayList)nvs.get(i);
			String name = (String)nv.get(0);
			if (name.equals(columnName))
			{
				return (String)nv.get(1);	
			}
		}
		return null;
	}
	
	public int getInt (String columnName) throws SQLException
	{
		String val = getString(columnName);
		return Integer.parseInt(val);
	}
	
	public ResultSetMetaData getMetaData() throws SQLException
	{
		if (metaList != null)
		{
			return new SResultSetMetaData(metaList);
		}
		return null;
	}
	
	public void close() throws SQLException
	{
		
	}
	
	public static ArrayList buildRow (List cols, List values)
	{
		ArrayList nList = new ArrayList();
		for (int i = 0; i < values.size(); i++)
		{
			ArrayList a1 = new ArrayList();
			a1.add( (String)cols.get(i) );
			a1.add( (String)values.get(i) );
			nList.add(a1);
		}
		return nList;
	}
	
	public static ArrayList buildRow (String[] cols, String[] values)
	{
		ArrayList nList = new ArrayList();
		for (int i = 0; i < values.length; i++)
		{
			ArrayList a1 = new ArrayList();
			a1.add(cols[i]);
			a1.add(values[i]);
			nList.add(a1);
		}
		return nList;
	}
}
