package razorsql.plugins;
	
import javax.swing.*;
import java.awt.event.*;
import java.sql.*;
import java.util.*;

public class PluginExample2 implements Plugin
{
	
	public void load()
	{
		PluginManager pluginManager = PluginManagerFactory.getInstance();
		
		pluginManager.log("in load() in PluginExample2 ");
		
		//add a menu item to the Plugins menu
		JMenuItem menuItem = new JMenuItem("Plugin Example 2");
		pluginManager.addPluginMenuSeparator();
		pluginManager.addPluginMenuItem(menuItem);
		
		//add an ActionListener to perform operations when the
		//menu item is selected
		menuItem.addActionListener(new PluginExampleListener2());
	}
	
	public String getName()
	{
		return "Plugin Example 2";
	}

	public String getVersion()
	{
		return "1.0";
	}
	
	public String getDescription()
	{
		return "Example of how to use RazorSQL plugins 2";
	}
	
	private static class PluginExampleListener2 implements ActionListener
	{
	
		public PluginExampleListener2()
		{}	
		
		public void actionPerformed(ActionEvent e)
		{
			PluginManager pluginManager = 
				PluginManagerFactory.getInstance();
			pluginManager.log("in actionPerformed 2");
			
			JFrame frame = pluginManager.getMainFrame();
			pluginManager.log("pluginexample2: mainFrame: " +frame);
			
			pluginManager.openNewConnectedTab();
			
			pluginManager.executeQuery("Select * from employee");
		}
	}
}
	