/*
 * Decompiled with CFR 0.152.
 */
package jxl.write.biff;

import common.Assert;
import common.Logger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;
import jxl.Cell;
import jxl.CellType;
import jxl.CellView;
import jxl.HeaderFooter;
import jxl.Hyperlink;
import jxl.Image;
import jxl.LabelCell;
import jxl.Range;
import jxl.Sheet;
import jxl.SheetSettings;
import jxl.WorkbookSettings;
import jxl.biff.AutoFilter;
import jxl.biff.CellReferenceHelper;
import jxl.biff.ConditionalFormat;
import jxl.biff.DataValidation;
import jxl.biff.EmptyCell;
import jxl.biff.FormattingRecords;
import jxl.biff.IndexMapping;
import jxl.biff.NumFormatRecordsException;
import jxl.biff.SheetRangeImpl;
import jxl.biff.WorkspaceInformationRecord;
import jxl.biff.XFRecord;
import jxl.biff.drawing.Chart;
import jxl.biff.drawing.ComboBox;
import jxl.biff.drawing.Drawing;
import jxl.biff.drawing.DrawingGroupObject;
import jxl.format.CellFormat;
import jxl.format.Font;
import jxl.format.PageOrientation;
import jxl.format.PaperSize;
import jxl.write.Blank;
import jxl.write.Label;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableHyperlink;
import jxl.write.WritableImage;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import jxl.write.biff.ButtonPropertySetRecord;
import jxl.write.biff.CellValue;
import jxl.write.biff.ColumnInfoRecord;
import jxl.write.biff.File;
import jxl.write.biff.FooterRecord;
import jxl.write.biff.HeaderRecord;
import jxl.write.biff.HyperlinkRecord;
import jxl.write.biff.JxlWriteException;
import jxl.write.biff.MergedCells;
import jxl.write.biff.PLSRecord;
import jxl.write.biff.RowRecord;
import jxl.write.biff.RowsExceededException;
import jxl.write.biff.SharedStrings;
import jxl.write.biff.SheetCopier;
import jxl.write.biff.SheetWriter;
import jxl.write.biff.Styles;
import jxl.write.biff.WritableSheetCopier;
import jxl.write.biff.WritableWorkbookImpl;

class WritableSheetImpl
implements WritableSheet {
    private static Logger logger = Logger.getLogger(class$jxl$write$biff$WritableSheetImpl == null ? (class$jxl$write$biff$WritableSheetImpl = WritableSheetImpl.class$("jxl.write.biff.WritableSheetImpl")) : class$jxl$write$biff$WritableSheetImpl);
    private String name;
    private File outputFile;
    private RowRecord[] rows;
    private FormattingRecords formatRecords;
    private SharedStrings sharedStrings;
    private TreeSet columnFormats;
    private TreeSet autosizedColumns;
    private ArrayList hyperlinks;
    private MergedCells mergedCells;
    private int numRows;
    private int numColumns;
    private PLSRecord plsRecord;
    private ButtonPropertySetRecord buttonPropertySet;
    private boolean chartOnly;
    private DataValidation dataValidation;
    private ArrayList rowBreaks;
    private ArrayList columnBreaks;
    private ArrayList drawings;
    private ArrayList images;
    private ArrayList conditionalFormats;
    private AutoFilter autoFilter;
    private ArrayList validatedCells;
    private ComboBox comboBox;
    private boolean drawingsModified;
    private int maxRowOutlineLevel;
    private int maxColumnOutlineLevel;
    private SheetSettings settings;
    private SheetWriter sheetWriter;
    private WorkbookSettings workbookSettings;
    private WritableWorkbookImpl workbook;
    private static final int rowGrowSize = 10;
    private static final int numRowsPerSheet = 65536;
    private static final int maxSheetNameLength = 31;
    private static final char[] illegalSheetNameCharacters = new char[]{'*', ':', '?', '\\'};
    private static final String[] imageTypes = new String[]{"png"};
    static /* synthetic */ Class class$jxl$write$biff$WritableSheetImpl;

    public WritableSheetImpl(String string, File file, FormattingRecords formattingRecords, SharedStrings sharedStrings, WorkbookSettings workbookSettings, WritableWorkbookImpl writableWorkbookImpl) {
        this.name = this.validateName(string);
        this.outputFile = file;
        this.rows = new RowRecord[0];
        this.numRows = 0;
        this.numColumns = 0;
        this.chartOnly = false;
        this.workbook = writableWorkbookImpl;
        this.formatRecords = formattingRecords;
        this.sharedStrings = sharedStrings;
        this.workbookSettings = workbookSettings;
        this.drawingsModified = false;
        this.columnFormats = new TreeSet(new ColumnInfoComparator());
        this.autosizedColumns = new TreeSet();
        this.hyperlinks = new ArrayList();
        this.mergedCells = new MergedCells(this);
        this.rowBreaks = new ArrayList();
        this.columnBreaks = new ArrayList();
        this.drawings = new ArrayList();
        this.images = new ArrayList();
        this.conditionalFormats = new ArrayList();
        this.validatedCells = new ArrayList();
        this.settings = new SheetSettings(this);
        this.sheetWriter = new SheetWriter(this.outputFile, this, this.workbookSettings);
    }

    public Cell getCell(String string) {
        return this.getCell(CellReferenceHelper.getColumn(string), CellReferenceHelper.getRow(string));
    }

    public Cell getCell(int n, int n2) {
        return this.getWritableCell(n, n2);
    }

    public WritableCell getWritableCell(String string) {
        return this.getWritableCell(CellReferenceHelper.getColumn(string), CellReferenceHelper.getRow(string));
    }

    public WritableCell getWritableCell(int n, int n2) {
        WritableCell writableCell = null;
        if (n2 < this.rows.length && this.rows[n2] != null) {
            writableCell = this.rows[n2].getCell(n);
        }
        if (writableCell == null) {
            writableCell = new EmptyCell(n, n2);
        }
        return writableCell;
    }

    public int getRows() {
        return this.numRows;
    }

    public int getColumns() {
        return this.numColumns;
    }

    public Cell findCell(String string) {
        Cell cell = null;
        boolean bl = false;
        for (int i = 0; i < this.getRows() && !bl; ++i) {
            Cell[] cellArray = this.getRow(i);
            for (int j = 0; j < cellArray.length && !bl; ++j) {
                if (!cellArray[j].getContents().equals(string)) continue;
                cell = cellArray[j];
                bl = true;
            }
        }
        return cell;
    }

    public LabelCell findLabelCell(String string) {
        LabelCell labelCell = null;
        boolean bl = false;
        for (int i = 0; i < this.getRows() && !bl; ++i) {
            Cell[] cellArray = this.getRow(i);
            for (int j = 0; j < cellArray.length && !bl; ++j) {
                if (cellArray[j].getType() != CellType.LABEL && cellArray[j].getType() != CellType.STRING_FORMULA || !cellArray[j].getContents().equals(string)) continue;
                labelCell = (LabelCell)cellArray[j];
                bl = true;
            }
        }
        return labelCell;
    }

    public Cell[] getRow(int n) {
        boolean bl = false;
        int n2 = this.numColumns - 1;
        while (n2 >= 0 && !bl) {
            if (this.getCell(n2, n).getType() != CellType.EMPTY) {
                bl = true;
                continue;
            }
            --n2;
        }
        Cell[] cellArray = new Cell[n2 + 1];
        for (int i = 0; i <= n2; ++i) {
            cellArray[i] = this.getCell(i, n);
        }
        return cellArray;
    }

    public Cell[] getColumn(int n) {
        boolean bl = false;
        int n2 = this.numRows - 1;
        while (n2 >= 0 && !bl) {
            if (this.getCell(n, n2).getType() != CellType.EMPTY) {
                bl = true;
                continue;
            }
            --n2;
        }
        Cell[] cellArray = new Cell[n2 + 1];
        for (int i = 0; i <= n2; ++i) {
            cellArray[i] = this.getCell(n, i);
        }
        return cellArray;
    }

    public String getName() {
        return this.name;
    }

    public void insertRow(int n) {
        if (n < 0 || n >= this.numRows) {
            return;
        }
        RowRecord[] rowRecordArray = this.rows;
        this.rows = this.numRows == this.rows.length ? new RowRecord[rowRecordArray.length + 10] : new RowRecord[rowRecordArray.length];
        System.arraycopy(rowRecordArray, 0, this.rows, 0, n);
        System.arraycopy(rowRecordArray, n, this.rows, n + 1, this.numRows - n);
        for (int i = n + 1; i <= this.numRows; ++i) {
            if (this.rows[i] == null) continue;
            this.rows[i].incrementRow();
        }
        HyperlinkRecord hyperlinkRecord = null;
        Iterator iterator = this.hyperlinks.iterator();
        while (iterator.hasNext()) {
            hyperlinkRecord = (HyperlinkRecord)iterator.next();
            hyperlinkRecord.insertRow(n);
        }
        if (this.dataValidation != null) {
            this.dataValidation.insertRow(n);
        }
        this.mergedCells.insertRow(n);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        Iterator iterator2 = this.rowBreaks.iterator();
        while (iterator2.hasNext()) {
            int n2 = (Integer)iterator2.next();
            if (n2 >= n) {
                ++n2;
            }
            arrayList.add(new Integer(n2));
        }
        this.rowBreaks = arrayList;
        Iterator iterator3 = this.conditionalFormats.iterator();
        while (iterator3.hasNext()) {
            ConditionalFormat conditionalFormat = (ConditionalFormat)iterator3.next();
            conditionalFormat.insertRow(n);
        }
        if (this.workbookSettings.getFormulaAdjust()) {
            this.workbook.rowInserted(this, n);
        }
        ++this.numRows;
    }

    public void insertColumn(int n) {
        Object object;
        Object object2;
        if (n < 0 || n >= this.numColumns) {
            return;
        }
        for (int i = 0; i < this.numRows; ++i) {
            if (this.rows[i] == null) continue;
            this.rows[i].insertColumn(n);
        }
        HyperlinkRecord hyperlinkRecord = null;
        Iterator iterator = this.hyperlinks.iterator();
        while (iterator.hasNext()) {
            hyperlinkRecord = (HyperlinkRecord)iterator.next();
            hyperlinkRecord.insertColumn(n);
        }
        iterator = this.columnFormats.iterator();
        while (iterator.hasNext()) {
            object2 = (ColumnInfoRecord)iterator.next();
            if (((ColumnInfoRecord)object2).getColumn() < n) continue;
            ((ColumnInfoRecord)object2).incrementColumn();
        }
        if (this.autosizedColumns.size() > 0) {
            object2 = new TreeSet();
            iterator = this.autosizedColumns.iterator();
            while (iterator.hasNext()) {
                object = (Integer)iterator.next();
                if ((Integer)object >= n) {
                    ((TreeSet)object2).add((Integer)new Integer((Integer)object + 1));
                    continue;
                }
                ((TreeSet)object2).add((Object)object);
            }
            this.autosizedColumns = object2;
        }
        if (this.dataValidation != null) {
            this.dataValidation.insertColumn(n);
        }
        this.mergedCells.insertColumn(n);
        object2 = new ArrayList<Object>();
        object = this.columnBreaks.iterator();
        while (object.hasNext()) {
            int n2 = (Integer)object.next();
            if (n2 >= n) {
                ++n2;
            }
            ((ArrayList)object2).add(new Integer(n2));
        }
        this.columnBreaks = object2;
        Iterator iterator2 = this.conditionalFormats.iterator();
        while (iterator2.hasNext()) {
            ConditionalFormat conditionalFormat = (ConditionalFormat)iterator2.next();
            conditionalFormat.insertColumn(n);
        }
        if (this.workbookSettings.getFormulaAdjust()) {
            this.workbook.columnInserted(this, n);
        }
        ++this.numColumns;
    }

    public void removeColumn(int n) {
        Object object;
        Object object2;
        if (n < 0 || n >= this.numColumns) {
            return;
        }
        for (int i = 0; i < this.numRows; ++i) {
            if (this.rows[i] == null) continue;
            this.rows[i].removeColumn(n);
        }
        HyperlinkRecord hyperlinkRecord = null;
        Iterator iterator = this.hyperlinks.iterator();
        while (iterator.hasNext()) {
            hyperlinkRecord = (HyperlinkRecord)iterator.next();
            if (hyperlinkRecord.getColumn() == n && hyperlinkRecord.getLastColumn() == n) {
                this.hyperlinks.remove(this.hyperlinks.indexOf(hyperlinkRecord));
                continue;
            }
            hyperlinkRecord.removeColumn(n);
        }
        if (this.dataValidation != null) {
            this.dataValidation.removeColumn(n);
        }
        this.mergedCells.removeColumn(n);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        Iterator iterator2 = this.columnBreaks.iterator();
        while (iterator2.hasNext()) {
            int n2 = (Integer)iterator2.next();
            if (n2 == n) continue;
            if (n2 > n) {
                --n2;
            }
            arrayList.add(new Integer(n2));
        }
        this.columnBreaks = arrayList;
        iterator = this.columnFormats.iterator();
        ColumnInfoRecord columnInfoRecord = null;
        while (iterator.hasNext()) {
            object2 = (ColumnInfoRecord)iterator.next();
            if (((ColumnInfoRecord)object2).getColumn() == n) {
                columnInfoRecord = object2;
                continue;
            }
            if (((ColumnInfoRecord)object2).getColumn() <= n) continue;
            ((ColumnInfoRecord)object2).decrementColumn();
        }
        if (columnInfoRecord != null) {
            this.columnFormats.remove(columnInfoRecord);
        }
        if (this.autosizedColumns.size() > 0) {
            object2 = new TreeSet();
            iterator = this.autosizedColumns.iterator();
            while (iterator.hasNext()) {
                object = (Integer)iterator.next();
                if ((Integer)object == n) continue;
                if ((Integer)object > n) {
                    ((TreeSet)object2).add((Integer)new Integer((Integer)object - 1));
                    continue;
                }
                ((TreeSet)object2).add((Object)object);
            }
            this.autosizedColumns = object2;
        }
        object2 = this.conditionalFormats.iterator();
        while (object2.hasNext()) {
            object = (ConditionalFormat)object2.next();
            ((ConditionalFormat)object).removeColumn(n);
        }
        if (this.workbookSettings.getFormulaAdjust()) {
            this.workbook.columnRemoved(this, n);
        }
        --this.numColumns;
    }

    public void removeRow(int n) {
        if (n < 0 || n >= this.numRows) {
            if (this.workbookSettings.getFormulaAdjust()) {
                this.workbook.rowRemoved(this, n);
            }
            return;
        }
        RowRecord[] rowRecordArray = this.rows;
        this.rows = new RowRecord[rowRecordArray.length];
        System.arraycopy(rowRecordArray, 0, this.rows, 0, n);
        System.arraycopy(rowRecordArray, n + 1, this.rows, n, this.numRows - (n + 1));
        for (int i = n; i < this.numRows; ++i) {
            if (this.rows[i] == null) continue;
            this.rows[i].decrementRow();
        }
        HyperlinkRecord hyperlinkRecord = null;
        Iterator iterator = this.hyperlinks.iterator();
        while (iterator.hasNext()) {
            hyperlinkRecord = (HyperlinkRecord)iterator.next();
            if (hyperlinkRecord.getRow() == n && hyperlinkRecord.getLastRow() == n) {
                iterator.remove();
                continue;
            }
            hyperlinkRecord.removeRow(n);
        }
        if (this.dataValidation != null) {
            this.dataValidation.removeRow(n);
        }
        this.mergedCells.removeRow(n);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        Iterator iterator2 = this.rowBreaks.iterator();
        while (iterator2.hasNext()) {
            int n2 = (Integer)iterator2.next();
            if (n2 == n) continue;
            if (n2 > n) {
                --n2;
            }
            arrayList.add(new Integer(n2));
        }
        this.rowBreaks = arrayList;
        Iterator iterator3 = this.conditionalFormats.iterator();
        while (iterator3.hasNext()) {
            ConditionalFormat conditionalFormat = (ConditionalFormat)iterator3.next();
            conditionalFormat.removeRow(n);
        }
        if (this.workbookSettings.getFormulaAdjust()) {
            this.workbook.rowRemoved(this, n);
        }
        --this.numRows;
    }

    public void addCell(WritableCell writableCell) throws WriteException, RowsExceededException {
        if (writableCell.getType() == CellType.EMPTY && writableCell != null && writableCell.getCellFormat() == null) {
            return;
        }
        CellValue cellValue = (CellValue)writableCell;
        if (cellValue.isReferenced()) {
            throw new JxlWriteException(JxlWriteException.cellReferenced);
        }
        int n = writableCell.getRow();
        RowRecord rowRecord = this.getRowRecord(n);
        rowRecord.addCell(cellValue);
        this.numRows = Math.max(n + 1, this.numRows);
        this.numColumns = Math.max(this.numColumns, rowRecord.getMaxColumn());
        cellValue.setCellDetails(this.formatRecords, this.sharedStrings, this);
    }

    RowRecord getRowRecord(int n) throws RowsExceededException {
        Object object;
        if (n >= 65536) {
            throw new RowsExceededException();
        }
        if (n >= this.rows.length) {
            object = this.rows;
            this.rows = new RowRecord[Math.max(((RowRecord[])object).length + 10, n + 1)];
            System.arraycopy(object, 0, this.rows, 0, ((RowRecord[])object).length);
            object = null;
        }
        if ((object = this.rows[n]) == null) {
            this.rows[n] = object = new RowRecord(n, this);
        }
        return object;
    }

    RowRecord getRowInfo(int n) {
        if (n < 0 || n > this.rows.length) {
            return null;
        }
        return this.rows[n];
    }

    ColumnInfoRecord getColumnInfo(int n) {
        Iterator iterator = this.columnFormats.iterator();
        ColumnInfoRecord columnInfoRecord = null;
        boolean bl = false;
        while (iterator.hasNext() && !bl) {
            columnInfoRecord = (ColumnInfoRecord)iterator.next();
            if (columnInfoRecord.getColumn() < n) continue;
            bl = true;
        }
        if (!bl) {
            return null;
        }
        return columnInfoRecord.getColumn() == n ? columnInfoRecord : null;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setHidden(boolean bl) {
        this.settings.setHidden(bl);
    }

    public void setProtected(boolean bl) {
        this.settings.setProtected(bl);
    }

    public void setSelected() {
        this.settings.setSelected();
    }

    public boolean isHidden() {
        return this.settings.isHidden();
    }

    public void setColumnView(int n, int n2) {
        CellView cellView = new CellView();
        cellView.setSize(n2 * 256);
        this.setColumnView(n, cellView);
    }

    public void setColumnView(int n, int n2, CellFormat cellFormat) {
        CellView cellView = new CellView();
        cellView.setSize(n2 * 256);
        cellView.setFormat(cellFormat);
        this.setColumnView(n, cellView);
    }

    public void setColumnView(int n, CellView cellView) {
        block8: {
            XFRecord xFRecord = (XFRecord)cellView.getFormat();
            if (xFRecord == null) {
                Styles styles = this.getWorkbook().getStyles();
                xFRecord = styles.getNormalStyle();
            }
            try {
                int n2;
                if (!xFRecord.isInitialized()) {
                    this.formatRecords.addStyle(xFRecord);
                }
                int n3 = n2 = cellView.depUsed() ? cellView.getDimension() * 256 : cellView.getSize();
                if (cellView.isAutosize()) {
                    this.autosizedColumns.add(new Integer(n));
                }
                ColumnInfoRecord columnInfoRecord = new ColumnInfoRecord(n, n2, xFRecord);
                if (cellView.isHidden()) {
                    columnInfoRecord.setHidden(true);
                }
                if (!this.columnFormats.contains(columnInfoRecord)) {
                    this.columnFormats.add(columnInfoRecord);
                } else {
                    this.columnFormats.remove(columnInfoRecord);
                    this.columnFormats.add(columnInfoRecord);
                }
            }
            catch (NumFormatRecordsException numFormatRecordsException) {
                logger.warn("Maximum number of format records exceeded.  Using default format.");
                ColumnInfoRecord columnInfoRecord = new ColumnInfoRecord(n, cellView.getDimension() * 256, WritableWorkbook.NORMAL_STYLE);
                if (this.columnFormats.contains(columnInfoRecord)) break block8;
                this.columnFormats.add(columnInfoRecord);
            }
        }
    }

    public void setRowView(int n, int n2) throws RowsExceededException {
        CellView cellView = new CellView();
        cellView.setSize(n2);
        cellView.setHidden(false);
        this.setRowView(n, cellView);
    }

    public void setRowView(int n, boolean bl) throws RowsExceededException {
        CellView cellView = new CellView();
        cellView.setHidden(bl);
        this.setRowView(n, cellView);
    }

    public void setRowView(int n, int n2, boolean bl) throws RowsExceededException {
        CellView cellView = new CellView();
        cellView.setSize(n2);
        cellView.setHidden(bl);
        this.setRowView(n, cellView);
    }

    public void setRowView(int n, CellView cellView) throws RowsExceededException {
        RowRecord rowRecord = this.getRowRecord(n);
        XFRecord xFRecord = (XFRecord)cellView.getFormat();
        try {
            if (xFRecord != null && !xFRecord.isInitialized()) {
                this.formatRecords.addStyle(xFRecord);
            }
        }
        catch (NumFormatRecordsException numFormatRecordsException) {
            logger.warn("Maximum number of format records exceeded.  Using default format.");
            xFRecord = null;
        }
        rowRecord.setRowDetails(cellView.getSize(), false, cellView.isHidden(), 0, false, xFRecord);
        this.numRows = Math.max(this.numRows, n + 1);
    }

    public void write() throws IOException {
        boolean bl = this.drawingsModified;
        if (this.workbook.getDrawingGroup() != null) {
            bl |= this.workbook.getDrawingGroup().hasDrawingsOmitted();
        }
        if (this.autosizedColumns.size() > 0) {
            this.autosizeColumns();
        }
        this.sheetWriter.setWriteData(this.rows, this.rowBreaks, this.columnBreaks, this.hyperlinks, this.mergedCells, this.columnFormats, this.maxRowOutlineLevel, this.maxColumnOutlineLevel);
        this.sheetWriter.setDimensions(this.getRows(), this.getColumns());
        this.sheetWriter.setSettings(this.settings);
        this.sheetWriter.setPLS(this.plsRecord);
        this.sheetWriter.setDrawings(this.drawings, bl);
        this.sheetWriter.setButtonPropertySet(this.buttonPropertySet);
        this.sheetWriter.setDataValidation(this.dataValidation, this.validatedCells);
        this.sheetWriter.setConditionalFormats(this.conditionalFormats);
        this.sheetWriter.setAutoFilter(this.autoFilter);
        this.sheetWriter.write();
    }

    void copy(Sheet sheet) {
        this.settings = new SheetSettings(sheet.getSettings(), this);
        SheetCopier sheetCopier = new SheetCopier(sheet, this);
        sheetCopier.setColumnFormats(this.columnFormats);
        sheetCopier.setFormatRecords(this.formatRecords);
        sheetCopier.setHyperlinks(this.hyperlinks);
        sheetCopier.setMergedCells(this.mergedCells);
        sheetCopier.setRowBreaks(this.rowBreaks);
        sheetCopier.setColumnBreaks(this.columnBreaks);
        sheetCopier.setSheetWriter(this.sheetWriter);
        sheetCopier.setDrawings(this.drawings);
        sheetCopier.setImages(this.images);
        sheetCopier.setConditionalFormats(this.conditionalFormats);
        sheetCopier.copySheet();
        this.dataValidation = sheetCopier.getDataValidation();
        this.comboBox = sheetCopier.getComboBox();
        this.plsRecord = sheetCopier.getPLSRecord();
        this.chartOnly = sheetCopier.isChartOnly();
        this.buttonPropertySet = sheetCopier.getButtonPropertySet();
        this.numRows = sheetCopier.getRows();
        this.autoFilter = sheetCopier.getAutoFilter();
        this.maxRowOutlineLevel = sheetCopier.getMaxRowOutlineLevel();
        this.maxColumnOutlineLevel = sheetCopier.getMaxColumnOutlineLevel();
    }

    void copy(WritableSheet writableSheet) {
        this.settings = new SheetSettings(writableSheet.getSettings(), this);
        WritableSheetImpl writableSheetImpl = (WritableSheetImpl)writableSheet;
        WritableSheetCopier writableSheetCopier = new WritableSheetCopier(writableSheet, this);
        writableSheetCopier.setColumnFormats(writableSheetImpl.columnFormats, this.columnFormats);
        writableSheetCopier.setMergedCells(writableSheetImpl.mergedCells, this.mergedCells);
        writableSheetCopier.setRows(writableSheetImpl.rows);
        writableSheetCopier.setRowBreaks(writableSheetImpl.rowBreaks, this.rowBreaks);
        writableSheetCopier.setColumnBreaks(writableSheetImpl.columnBreaks, this.columnBreaks);
        writableSheetCopier.setDataValidation(writableSheetImpl.dataValidation);
        writableSheetCopier.setSheetWriter(this.sheetWriter);
        writableSheetCopier.setDrawings(writableSheetImpl.drawings, this.drawings, this.images);
        writableSheetCopier.setWorkspaceOptions(writableSheetImpl.getWorkspaceOptions());
        writableSheetCopier.setPLSRecord(writableSheetImpl.plsRecord);
        writableSheetCopier.setButtonPropertySetRecord(writableSheetImpl.buttonPropertySet);
        writableSheetCopier.setHyperlinks(writableSheetImpl.hyperlinks, this.hyperlinks);
        writableSheetCopier.copySheet();
        this.dataValidation = writableSheetCopier.getDataValidation();
        this.plsRecord = writableSheetCopier.getPLSRecord();
        this.buttonPropertySet = writableSheetCopier.getButtonPropertySet();
    }

    final HeaderRecord getHeader() {
        return this.sheetWriter.getHeader();
    }

    final FooterRecord getFooter() {
        return this.sheetWriter.getFooter();
    }

    public boolean isProtected() {
        return this.settings.isProtected();
    }

    public Hyperlink[] getHyperlinks() {
        Hyperlink[] hyperlinkArray = new Hyperlink[this.hyperlinks.size()];
        for (int i = 0; i < this.hyperlinks.size(); ++i) {
            hyperlinkArray[i] = (Hyperlink)this.hyperlinks.get(i);
        }
        return hyperlinkArray;
    }

    public Range[] getMergedCells() {
        return this.mergedCells.getMergedCells();
    }

    public WritableHyperlink[] getWritableHyperlinks() {
        WritableHyperlink[] writableHyperlinkArray = new WritableHyperlink[this.hyperlinks.size()];
        for (int i = 0; i < this.hyperlinks.size(); ++i) {
            writableHyperlinkArray[i] = (WritableHyperlink)this.hyperlinks.get(i);
        }
        return writableHyperlinkArray;
    }

    public void removeHyperlink(WritableHyperlink writableHyperlink) {
        this.removeHyperlink(writableHyperlink, false);
    }

    public void removeHyperlink(WritableHyperlink writableHyperlink, boolean bl) {
        this.hyperlinks.remove(this.hyperlinks.indexOf(writableHyperlink));
        if (!bl) {
            Assert.verify(this.rows.length > writableHyperlink.getRow() && this.rows[writableHyperlink.getRow()] != null);
            this.rows[writableHyperlink.getRow()].removeCell(writableHyperlink.getColumn());
        }
    }

    public void addHyperlink(WritableHyperlink writableHyperlink) throws WriteException, RowsExceededException {
        Object object;
        Cell cell = this.getCell(writableHyperlink.getColumn(), writableHyperlink.getRow());
        Object object2 = null;
        if (writableHyperlink.isFile() || writableHyperlink.isUNC()) {
            object = writableHyperlink.getContents();
            object2 = object == null ? writableHyperlink.getFile().getPath() : object;
        } else if (writableHyperlink.isURL()) {
            object = writableHyperlink.getContents();
            object2 = object == null ? writableHyperlink.getURL().toString() : object;
        } else if (writableHyperlink.isLocation()) {
            object2 = writableHyperlink.getContents();
        }
        if (cell.getType() == CellType.LABEL) {
            object = (Label)cell;
            ((Label)object).setString((String)object2);
            WritableCellFormat writableCellFormat = new WritableCellFormat(((CellValue)object).getCellFormat());
            writableCellFormat.setFont(WritableWorkbook.HYPERLINK_FONT);
            ((CellValue)object).setCellFormat(writableCellFormat);
        } else {
            object = new Label(writableHyperlink.getColumn(), writableHyperlink.getRow(), (String)object2, (CellFormat)WritableWorkbook.HYPERLINK_STYLE);
            this.addCell((WritableCell)object);
        }
        for (int i = writableHyperlink.getRow(); i <= writableHyperlink.getLastRow(); ++i) {
            for (int j = writableHyperlink.getColumn(); j <= writableHyperlink.getLastColumn(); ++j) {
                if (i == writableHyperlink.getRow() || j == writableHyperlink.getColumn() || this.rows.length >= writableHyperlink.getLastColumn() || this.rows[i] == null) continue;
                this.rows[i].removeCell(j);
            }
        }
        writableHyperlink.initialize(this);
        this.hyperlinks.add(writableHyperlink);
    }

    public Range mergeCells(int n, int n2, int n3, int n4) throws WriteException, RowsExceededException {
        if (n3 < n || n4 < n2) {
            logger.warn("Cannot merge cells - top left and bottom right incorrectly specified");
        }
        if (n3 >= this.numColumns || n4 >= this.numRows) {
            this.addCell(new Blank(n3, n4));
        }
        SheetRangeImpl sheetRangeImpl = new SheetRangeImpl(this, n, n2, n3, n4);
        this.mergedCells.add(sheetRangeImpl);
        return sheetRangeImpl;
    }

    public void setRowGroup(int n, int n2, boolean bl) throws WriteException, RowsExceededException {
        if (n2 < n) {
            logger.warn("Cannot merge cells - top and bottom rows incorrectly specified");
        }
        for (int i = n; i <= n2; ++i) {
            RowRecord rowRecord = this.getRowRecord(i);
            rowRecord.incrementOutlineLevel();
            rowRecord.setCollapsed(bl);
            this.maxRowOutlineLevel = Math.max(this.maxRowOutlineLevel, rowRecord.getOutlineLevel());
        }
    }

    public void unsetRowGroup(int n, int n2) throws WriteException, RowsExceededException {
        int n3;
        if (n2 < n) {
            logger.warn("Cannot merge cells - top and bottom rows incorrectly specified");
        }
        if (n2 >= this.numRows) {
            logger.warn("" + n2 + " is greater than the sheet bounds");
            n2 = this.numRows - 1;
        }
        for (n3 = n; n3 <= n2; ++n3) {
            this.rows[n3].decrementOutlineLevel();
        }
        this.maxRowOutlineLevel = 0;
        n3 = this.rows.length;
        while (n3-- > 0) {
            this.maxRowOutlineLevel = Math.max(this.maxRowOutlineLevel, this.rows[n3].getOutlineLevel());
        }
    }

    public void setColumnGroup(int n, int n2, boolean bl) throws WriteException, RowsExceededException {
        if (n2 < n) {
            logger.warn("Cannot merge cells - top and bottom rows incorrectly specified");
        }
        for (int i = n; i <= n2; ++i) {
            ColumnInfoRecord columnInfoRecord = this.getColumnInfo(i);
            columnInfoRecord.incrementOutlineLevel();
            columnInfoRecord.setCollapsed(bl);
            this.maxColumnOutlineLevel = Math.max(this.maxColumnOutlineLevel, columnInfoRecord.getOutlineLevel());
        }
    }

    public void unsetColumnGroup(int n, int n2) throws WriteException, RowsExceededException {
        ColumnInfoRecord columnInfoRecord;
        if (n2 < n) {
            logger.warn("Cannot merge cells - top and bottom rows incorrectly specified");
        }
        for (int i = n; i <= n2; ++i) {
            columnInfoRecord = this.getColumnInfo(i);
            columnInfoRecord.decrementOutlineLevel();
        }
        this.maxColumnOutlineLevel = 0;
        Iterator iterator = this.columnFormats.iterator();
        while (iterator.hasNext()) {
            columnInfoRecord = (ColumnInfoRecord)iterator.next();
            this.maxColumnOutlineLevel = Math.max(this.maxColumnOutlineLevel, columnInfoRecord.getOutlineLevel());
        }
    }

    public void unmergeCells(Range range) {
        this.mergedCells.unmergeCells(range);
    }

    public void setHeader(String string, String string2, String string3) {
        HeaderFooter headerFooter = new HeaderFooter();
        headerFooter.getLeft().append(string);
        headerFooter.getCentre().append(string2);
        headerFooter.getRight().append(string3);
        this.settings.setHeader(headerFooter);
    }

    public void setFooter(String string, String string2, String string3) {
        HeaderFooter headerFooter = new HeaderFooter();
        headerFooter.getLeft().append(string);
        headerFooter.getCentre().append(string2);
        headerFooter.getRight().append(string3);
        this.settings.setFooter(headerFooter);
    }

    public void setPageSetup(PageOrientation pageOrientation) {
        this.settings.setOrientation(pageOrientation);
    }

    public void setPageSetup(PageOrientation pageOrientation, double d, double d2) {
        this.settings.setOrientation(pageOrientation);
        this.settings.setHeaderMargin(d);
        this.settings.setFooterMargin(d2);
    }

    public void setPageSetup(PageOrientation pageOrientation, PaperSize paperSize, double d, double d2) {
        this.settings.setPaperSize(paperSize);
        this.settings.setOrientation(pageOrientation);
        this.settings.setHeaderMargin(d);
        this.settings.setFooterMargin(d2);
    }

    public SheetSettings getSettings() {
        return this.settings;
    }

    WorkbookSettings getWorkbookSettings() {
        return this.workbookSettings;
    }

    public void addRowPageBreak(int n) {
        Iterator iterator = this.rowBreaks.iterator();
        boolean bl = false;
        while (iterator.hasNext() && !bl) {
            if ((Integer)iterator.next() != n) continue;
            bl = true;
        }
        if (!bl) {
            this.rowBreaks.add(new Integer(n));
        }
    }

    public void addColumnPageBreak(int n) {
        Iterator iterator = this.columnBreaks.iterator();
        boolean bl = false;
        while (iterator.hasNext() && !bl) {
            if ((Integer)iterator.next() != n) continue;
            bl = true;
        }
        if (!bl) {
            this.columnBreaks.add(new Integer(n));
        }
    }

    Chart[] getCharts() {
        return this.sheetWriter.getCharts();
    }

    private DrawingGroupObject[] getDrawings() {
        DrawingGroupObject[] drawingGroupObjectArray = new DrawingGroupObject[this.drawings.size()];
        drawingGroupObjectArray = this.drawings.toArray(drawingGroupObjectArray);
        return drawingGroupObjectArray;
    }

    void checkMergedBorders() {
        this.sheetWriter.setWriteData(this.rows, this.rowBreaks, this.columnBreaks, this.hyperlinks, this.mergedCells, this.columnFormats, this.maxRowOutlineLevel, this.maxColumnOutlineLevel);
        this.sheetWriter.setDimensions(this.getRows(), this.getColumns());
        this.sheetWriter.checkMergedBorders();
    }

    private WorkspaceInformationRecord getWorkspaceOptions() {
        return this.sheetWriter.getWorkspaceOptions();
    }

    void rationalize(IndexMapping indexMapping, IndexMapping indexMapping2, IndexMapping indexMapping3) {
        Iterator iterator = this.columnFormats.iterator();
        while (iterator.hasNext()) {
            ColumnInfoRecord columnInfoRecord = (ColumnInfoRecord)iterator.next();
            columnInfoRecord.rationalize(indexMapping);
        }
        for (int i = 0; i < this.rows.length; ++i) {
            if (this.rows[i] == null) continue;
            this.rows[i].rationalize(indexMapping);
        }
        Chart[] chartArray = this.getCharts();
        for (int i = 0; i < chartArray.length; ++i) {
            chartArray[i].rationalize(indexMapping, indexMapping2, indexMapping3);
        }
    }

    WritableWorkbookImpl getWorkbook() {
        return this.workbook;
    }

    public CellFormat getColumnFormat(int n) {
        return this.getColumnView(n).getFormat();
    }

    public int getColumnWidth(int n) {
        return this.getColumnView(n).getDimension();
    }

    public int getRowHeight(int n) {
        return this.getRowView(n).getDimension();
    }

    boolean isChartOnly() {
        return this.chartOnly;
    }

    public CellView getRowView(int n) {
        CellView cellView = new CellView();
        try {
            RowRecord rowRecord = this.getRowRecord(n);
            if (rowRecord == null || rowRecord.isDefaultHeight()) {
                cellView.setDimension(this.settings.getDefaultRowHeight());
                cellView.setSize(this.settings.getDefaultRowHeight());
            } else if (rowRecord.isCollapsed()) {
                cellView.setHidden(true);
            } else {
                cellView.setDimension(rowRecord.getRowHeight());
                cellView.setSize(rowRecord.getRowHeight());
            }
            return cellView;
        }
        catch (RowsExceededException rowsExceededException) {
            cellView.setDimension(this.settings.getDefaultRowHeight());
            cellView.setSize(this.settings.getDefaultRowHeight());
            return cellView;
        }
    }

    public CellView getColumnView(int n) {
        ColumnInfoRecord columnInfoRecord = this.getColumnInfo(n);
        CellView cellView = new CellView();
        if (columnInfoRecord != null) {
            cellView.setDimension(columnInfoRecord.getWidth() / 256);
            cellView.setSize(columnInfoRecord.getWidth());
            cellView.setHidden(columnInfoRecord.getHidden());
            cellView.setFormat(columnInfoRecord.getCellFormat());
        } else {
            cellView.setDimension(this.settings.getDefaultColumnWidth() / 256);
            cellView.setSize(this.settings.getDefaultColumnWidth() * 256);
        }
        return cellView;
    }

    public void addImage(WritableImage writableImage) {
        int n;
        CharSequence charSequence;
        boolean bl = false;
        java.io.File file = writableImage.getImageFile();
        String string = "?";
        if (file != null) {
            charSequence = file.getName();
            n = ((String)charSequence).lastIndexOf(46);
            string = n != -1 ? ((String)charSequence).substring(n + 1) : "";
            for (int i = 0; i < imageTypes.length && !bl; ++i) {
                if (!string.equalsIgnoreCase(imageTypes[i])) continue;
                bl = true;
            }
        } else {
            bl = true;
        }
        if (bl) {
            this.workbook.addDrawing(writableImage);
            this.drawings.add(writableImage);
            this.images.add(writableImage);
        } else {
            charSequence = new StringBuffer("Image type ");
            ((StringBuffer)charSequence).append(string);
            ((StringBuffer)charSequence).append(" not supported.  Supported types are ");
            ((StringBuffer)charSequence).append(imageTypes[0]);
            for (n = 1; n < imageTypes.length; ++n) {
                ((StringBuffer)charSequence).append(", ");
                ((StringBuffer)charSequence).append(imageTypes[n]);
            }
            logger.warn(((StringBuffer)charSequence).toString());
        }
    }

    public int getNumberOfImages() {
        return this.images.size();
    }

    public WritableImage getImage(int n) {
        return (WritableImage)this.images.get(n);
    }

    public Image getDrawing(int n) {
        return (Image)this.images.get(n);
    }

    public void removeImage(WritableImage writableImage) {
        this.drawings.remove(writableImage);
        this.images.remove(writableImage);
        this.drawingsModified = true;
        this.workbook.removeDrawing(writableImage);
    }

    private String validateName(String string) {
        if (string.length() > 31) {
            logger.warn("Sheet name " + string + " too long - truncating");
            string = string.substring(0, 31);
        }
        if (string.charAt(0) == '\'') {
            logger.warn("Sheet naming cannot start with ' - removing");
            string = string.substring(1);
        }
        for (int i = 0; i < illegalSheetNameCharacters.length; ++i) {
            String string2 = string.replace(illegalSheetNameCharacters[i], '@');
            if (string != string2) {
                logger.warn(illegalSheetNameCharacters[i] + " is not a valid character within a sheet name - replacing");
            }
            string = string2;
        }
        return string;
    }

    void addDrawing(DrawingGroupObject drawingGroupObject) {
        this.drawings.add(drawingGroupObject);
        Assert.verify(!(drawingGroupObject instanceof Drawing));
    }

    void removeDrawing(DrawingGroupObject drawingGroupObject) {
        int n = this.drawings.size();
        this.drawings.remove(drawingGroupObject);
        int n2 = this.drawings.size();
        this.drawingsModified = true;
        Assert.verify(n2 == n - 1);
    }

    public int[] getRowPageBreaks() {
        int[] nArray = new int[this.rowBreaks.size()];
        int n = 0;
        Iterator iterator = this.rowBreaks.iterator();
        while (iterator.hasNext()) {
            nArray[n] = (Integer)iterator.next();
            ++n;
        }
        return nArray;
    }

    public int[] getColumnPageBreaks() {
        int[] nArray = new int[this.columnBreaks.size()];
        int n = 0;
        Iterator iterator = this.columnBreaks.iterator();
        while (iterator.hasNext()) {
            nArray[n] = (Integer)iterator.next();
            ++n;
        }
        return nArray;
    }

    void addValidationCell(CellValue cellValue) {
        this.validatedCells.add(cellValue);
    }

    ComboBox getComboBox() {
        return this.comboBox;
    }

    void setComboBox(ComboBox comboBox) {
        this.comboBox = comboBox;
    }

    public DataValidation getDataValidation() {
        return this.dataValidation;
    }

    private void autosizeColumns() {
        Iterator iterator = this.autosizedColumns.iterator();
        while (iterator.hasNext()) {
            Integer n = (Integer)iterator.next();
            this.autosizeColumn(n);
        }
    }

    private void autosizeColumn(int n) {
        int n2 = 0;
        ColumnInfoRecord columnInfoRecord = this.getColumnInfo(n);
        Font font = columnInfoRecord.getCellFormat().getFont();
        Font font2 = WritableWorkbook.NORMAL_STYLE.getFont();
        for (int i = 0; i < this.numRows; ++i) {
            Cell cell = null;
            if (this.rows[i] != null) {
                cell = this.rows[i].getCell(n);
            }
            if (cell == null) continue;
            String string = cell.getContents();
            Font font3 = cell.getCellFormat().getFont();
            Font font4 = font3.equals(font2) ? font : font3;
            int n3 = font4.getPointSize();
            int n4 = string.length();
            if (font4.isItalic() || font4.getBoldWeight() > 400) {
                n4 += 2;
            }
            int n5 = n4 * n3;
            n2 = Math.max(n2, n5 * 256);
        }
        columnInfoRecord.setWidth(n2 / font2.getPointSize());
    }

    void importSheet(Sheet sheet) {
        this.settings = new SheetSettings(sheet.getSettings(), this);
        SheetCopier sheetCopier = new SheetCopier(sheet, this);
        sheetCopier.setColumnFormats(this.columnFormats);
        sheetCopier.setFormatRecords(this.formatRecords);
        sheetCopier.setHyperlinks(this.hyperlinks);
        sheetCopier.setMergedCells(this.mergedCells);
        sheetCopier.setRowBreaks(this.rowBreaks);
        sheetCopier.setColumnBreaks(this.columnBreaks);
        sheetCopier.setSheetWriter(this.sheetWriter);
        sheetCopier.setDrawings(this.drawings);
        sheetCopier.setImages(this.images);
        sheetCopier.importSheet();
        this.dataValidation = sheetCopier.getDataValidation();
        this.comboBox = sheetCopier.getComboBox();
        this.plsRecord = sheetCopier.getPLSRecord();
        this.chartOnly = sheetCopier.isChartOnly();
        this.buttonPropertySet = sheetCopier.getButtonPropertySet();
        this.numRows = sheetCopier.getRows();
        this.maxRowOutlineLevel = sheetCopier.getMaxRowOutlineLevel();
        this.maxColumnOutlineLevel = sheetCopier.getMaxColumnOutlineLevel();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class ColumnInfoComparator
    implements Comparator {
        private ColumnInfoComparator() {
        }

        public boolean equals(Object object) {
            return object == this;
        }

        public int compare(Object object, Object object2) {
            if (object == object2) {
                return 0;
            }
            Assert.verify(object instanceof ColumnInfoRecord);
            Assert.verify(object2 instanceof ColumnInfoRecord);
            ColumnInfoRecord columnInfoRecord = (ColumnInfoRecord)object;
            ColumnInfoRecord columnInfoRecord2 = (ColumnInfoRecord)object2;
            return columnInfoRecord.getColumn() - columnInfoRecord2.getColumn();
        }
    }
}

