/*
 * Decompiled with CFR 0.152.
 */
package jxl.write.biff;

import common.Assert;
import common.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import jxl.BooleanCell;
import jxl.Cell;
import jxl.CellType;
import jxl.DateCell;
import jxl.LabelCell;
import jxl.NumberCell;
import jxl.Range;
import jxl.WorkbookSettings;
import jxl.biff.CellReferenceHelper;
import jxl.biff.DataValidation;
import jxl.biff.FormattingRecords;
import jxl.biff.FormulaData;
import jxl.biff.NumFormatRecordsException;
import jxl.biff.SheetRangeImpl;
import jxl.biff.WorkbookMethods;
import jxl.biff.WorkspaceInformationRecord;
import jxl.biff.WritableRecordData;
import jxl.biff.XFRecord;
import jxl.biff.drawing.Drawing;
import jxl.biff.formula.ExternalSheet;
import jxl.biff.formula.FormulaException;
import jxl.format.CellFormat;
import jxl.write.Blank;
import jxl.write.Boolean;
import jxl.write.DateTime;
import jxl.write.Formula;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableHyperlink;
import jxl.write.WritableImage;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import jxl.write.biff.ButtonPropertySetRecord;
import jxl.write.biff.CellValue;
import jxl.write.biff.ColumnInfoRecord;
import jxl.write.biff.MergedCells;
import jxl.write.biff.PLSRecord;
import jxl.write.biff.ReadBooleanFormulaRecord;
import jxl.write.biff.ReadDateFormulaRecord;
import jxl.write.biff.ReadErrorFormulaRecord;
import jxl.write.biff.ReadFormulaRecord;
import jxl.write.biff.ReadNumberFormulaRecord;
import jxl.write.biff.ReadStringFormulaRecord;
import jxl.write.biff.RowRecord;
import jxl.write.biff.RowsExceededException;
import jxl.write.biff.SheetWriter;
import jxl.write.biff.WritableSheetImpl;

class WritableSheetCopier {
    private static Logger logger = Logger.getLogger(class$jxl$write$biff$SheetCopier == null ? (class$jxl$write$biff$SheetCopier = WritableSheetCopier.class$("jxl.write.biff.SheetCopier")) : class$jxl$write$biff$SheetCopier);
    private WritableSheetImpl fromSheet;
    private WritableSheetImpl toSheet;
    private WorkbookSettings workbookSettings;
    private TreeSet fromColumnFormats;
    private TreeSet toColumnFormats;
    private MergedCells fromMergedCells;
    private MergedCells toMergedCells;
    private RowRecord[] fromRows;
    private ArrayList fromRowBreaks;
    private ArrayList fromColumnBreaks;
    private ArrayList toRowBreaks;
    private ArrayList toColumnBreaks;
    private DataValidation fromDataValidation;
    private DataValidation toDataValidation;
    private SheetWriter sheetWriter;
    private ArrayList fromDrawings;
    private ArrayList toDrawings;
    private ArrayList toImages;
    private WorkspaceInformationRecord fromWorkspaceOptions;
    private PLSRecord fromPLSRecord;
    private PLSRecord toPLSRecord;
    private ButtonPropertySetRecord fromButtonPropertySet;
    private ButtonPropertySetRecord toButtonPropertySet;
    private ArrayList fromHyperlinks;
    private ArrayList toHyperlinks;
    private int numRows;
    private int maxRowOutlineLevel;
    private int maxColumnOutlineLevel;
    private boolean chartOnly;
    private FormattingRecords formatRecords;
    private HashMap xfRecords;
    private HashMap fonts;
    private HashMap formats;
    static /* synthetic */ Class class$jxl$write$biff$SheetCopier;

    public WritableSheetCopier(WritableSheet writableSheet, WritableSheet writableSheet2) {
        this.fromSheet = (WritableSheetImpl)writableSheet;
        this.toSheet = (WritableSheetImpl)writableSheet2;
        this.workbookSettings = this.toSheet.getWorkbook().getSettings();
        this.chartOnly = false;
    }

    void setColumnFormats(TreeSet treeSet, TreeSet treeSet2) {
        this.fromColumnFormats = treeSet;
        this.toColumnFormats = treeSet2;
    }

    void setMergedCells(MergedCells mergedCells, MergedCells mergedCells2) {
        this.fromMergedCells = mergedCells;
        this.toMergedCells = mergedCells2;
    }

    void setRows(RowRecord[] rowRecordArray) {
        this.fromRows = rowRecordArray;
    }

    void setRowBreaks(ArrayList arrayList, ArrayList arrayList2) {
        this.fromRowBreaks = arrayList;
        this.toRowBreaks = arrayList2;
    }

    void setColumnBreaks(ArrayList arrayList, ArrayList arrayList2) {
        this.fromColumnBreaks = arrayList;
        this.toColumnBreaks = arrayList2;
    }

    void setDrawings(ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3) {
        this.fromDrawings = arrayList;
        this.toDrawings = arrayList2;
        this.toImages = arrayList3;
    }

    void setHyperlinks(ArrayList arrayList, ArrayList arrayList2) {
        this.fromHyperlinks = arrayList;
        this.toHyperlinks = arrayList2;
    }

    void setWorkspaceOptions(WorkspaceInformationRecord workspaceInformationRecord) {
        this.fromWorkspaceOptions = workspaceInformationRecord;
    }

    void setDataValidation(DataValidation dataValidation) {
        this.fromDataValidation = dataValidation;
    }

    void setPLSRecord(PLSRecord pLSRecord) {
        this.fromPLSRecord = pLSRecord;
    }

    void setButtonPropertySetRecord(ButtonPropertySetRecord buttonPropertySetRecord) {
        this.fromButtonPropertySet = buttonPropertySetRecord;
    }

    void setSheetWriter(SheetWriter sheetWriter) {
        this.sheetWriter = sheetWriter;
    }

    DataValidation getDataValidation() {
        return this.toDataValidation;
    }

    PLSRecord getPLSRecord() {
        return this.toPLSRecord;
    }

    boolean isChartOnly() {
        return this.chartOnly;
    }

    ButtonPropertySetRecord getButtonPropertySet() {
        return this.toButtonPropertySet;
    }

    public void copySheet() {
        WritableRecordData writableRecordData;
        Object object;
        Object object2;
        this.shallowCopyCells();
        Iterator iterator = this.fromColumnFormats.iterator();
        while (iterator.hasNext()) {
            object2 = new ColumnInfoRecord((ColumnInfoRecord)iterator.next());
            this.toColumnFormats.add(object2);
        }
        object2 = this.fromMergedCells.getMergedCells();
        for (int i = 0; i < ((Range[])object2).length; ++i) {
            this.toMergedCells.add(new SheetRangeImpl((SheetRangeImpl)object2[i], this.toSheet));
        }
        try {
            object = null;
            writableRecordData = null;
            for (int i = 0; i < this.fromRows.length; ++i) {
                object = this.fromRows[i];
                if (object == null || ((RowRecord)object).isDefaultHeight() && !((RowRecord)object).isCollapsed()) continue;
                writableRecordData = this.toSheet.getRowRecord(i);
                writableRecordData.setRowDetails(((RowRecord)object).getRowHeight(), ((RowRecord)object).matchesDefaultFontHeight(), ((RowRecord)object).isCollapsed(), ((RowRecord)object).getOutlineLevel(), ((RowRecord)object).getGroupStart(), ((RowRecord)object).getStyle());
            }
        }
        catch (RowsExceededException rowsExceededException) {
            Assert.verify(false);
        }
        this.toRowBreaks = new ArrayList(this.fromRowBreaks);
        this.toColumnBreaks = new ArrayList(this.fromColumnBreaks);
        if (this.fromDataValidation != null) {
            this.toDataValidation = new DataValidation(this.fromDataValidation, (ExternalSheet)this.toSheet.getWorkbook(), (WorkbookMethods)this.toSheet.getWorkbook(), this.toSheet.getWorkbook().getSettings());
        }
        this.sheetWriter.setCharts(this.fromSheet.getCharts());
        object = this.fromDrawings.iterator();
        while (object.hasNext()) {
            writableRecordData = object.next();
            if (!(writableRecordData instanceof Drawing)) continue;
            WritableImage writableImage = new WritableImage((Drawing)((Object)writableRecordData), this.toSheet.getWorkbook().getDrawingGroup());
            this.toDrawings.add(writableImage);
            this.toImages.add(writableImage);
        }
        this.sheetWriter.setWorkspaceOptions(this.fromWorkspaceOptions);
        if (this.fromPLSRecord != null) {
            this.toPLSRecord = new PLSRecord(this.fromPLSRecord);
        }
        if (this.fromButtonPropertySet != null) {
            this.toButtonPropertySet = new ButtonPropertySetRecord(this.fromButtonPropertySet);
        }
        object = this.fromHyperlinks.iterator();
        while (object.hasNext()) {
            writableRecordData = new WritableHyperlink((WritableHyperlink)object.next(), this.toSheet);
            this.toHyperlinks.add(writableRecordData);
        }
    }

    private WritableCell shallowCopyCell(Cell cell) {
        CellType cellType = cell.getType();
        CellValue cellValue = null;
        if (cellType == CellType.LABEL) {
            cellValue = new Label((LabelCell)cell);
        } else if (cellType == CellType.NUMBER) {
            cellValue = new Number((NumberCell)cell);
        } else if (cellType == CellType.DATE) {
            cellValue = new DateTime((DateCell)cell);
        } else if (cellType == CellType.BOOLEAN) {
            cellValue = new Boolean((BooleanCell)cell);
        } else if (cellType == CellType.NUMBER_FORMULA) {
            cellValue = new ReadNumberFormulaRecord((FormulaData)cell);
        } else if (cellType == CellType.STRING_FORMULA) {
            cellValue = new ReadStringFormulaRecord((FormulaData)cell);
        } else if (cellType == CellType.BOOLEAN_FORMULA) {
            cellValue = new ReadBooleanFormulaRecord((FormulaData)cell);
        } else if (cellType == CellType.DATE_FORMULA) {
            cellValue = new ReadDateFormulaRecord((FormulaData)cell);
        } else if (cellType == CellType.FORMULA_ERROR) {
            cellValue = new ReadErrorFormulaRecord((FormulaData)cell);
        } else if (cellType == CellType.EMPTY && cell.getCellFormat() != null) {
            cellValue = new Blank(cell);
        }
        return cellValue;
    }

    private WritableCell deepCopyCell(Cell cell) {
        WritableCellFormat writableCellFormat;
        int n;
        Object object;
        WritableCell writableCell = this.shallowCopyCell(cell);
        if (writableCell == null) {
            return writableCell;
        }
        if (writableCell instanceof ReadFormulaRecord) {
            object = (ReadFormulaRecord)writableCell;
            int n2 = n = !((ReadFormulaRecord)object).handleImportedCellReferences(this.fromSheet.getWorkbook(), this.fromSheet.getWorkbook(), this.workbookSettings) ? 1 : 0;
            if (n != 0) {
                try {
                    logger.warn("Formula " + ((ReadFormulaRecord)object).getFormula() + " in cell " + CellReferenceHelper.getCellReference(cell.getColumn(), cell.getRow()) + " cannot be imported because it references another " + " sheet from the source workbook");
                }
                catch (FormulaException formulaException) {
                    logger.warn("Formula  in cell " + CellReferenceHelper.getCellReference(cell.getColumn(), cell.getRow()) + " cannot be imported:  " + formulaException.getMessage());
                }
                writableCell = new Formula(cell.getColumn(), cell.getRow(), "\"ERROR\"");
            }
        }
        if ((writableCellFormat = (WritableCellFormat)this.xfRecords.get(new Integer(n = ((XFRecord)(object = writableCell.getCellFormat())).getXFIndex()))) == null) {
            writableCellFormat = this.copyCellFormat((CellFormat)object);
        }
        writableCell.setCellFormat(writableCellFormat);
        return writableCell;
    }

    void shallowCopyCells() {
        int n = this.fromSheet.getRows();
        Cell[] cellArray = null;
        Cell cell = null;
        for (int i = 0; i < n; ++i) {
            cellArray = this.fromSheet.getRow(i);
            for (int j = 0; j < cellArray.length; ++j) {
                cell = cellArray[j];
                WritableCell writableCell = this.shallowCopyCell(cell);
                try {
                    if (writableCell == null) continue;
                    this.toSheet.addCell(writableCell);
                    continue;
                }
                catch (WriteException writeException) {
                    Assert.verify(false);
                }
            }
        }
        this.numRows = this.toSheet.getRows();
    }

    void deepCopyCells() {
        int n = this.fromSheet.getRows();
        Cell[] cellArray = null;
        Cell cell = null;
        for (int i = 0; i < n; ++i) {
            cellArray = this.fromSheet.getRow(i);
            for (int j = 0; j < cellArray.length; ++j) {
                cell = cellArray[j];
                WritableCell writableCell = this.deepCopyCell(cell);
                try {
                    if (writableCell == null) continue;
                    this.toSheet.addCell(writableCell);
                    continue;
                }
                catch (WriteException writeException) {
                    Assert.verify(false);
                }
            }
        }
    }

    private WritableCellFormat copyCellFormat(CellFormat cellFormat) {
        try {
            XFRecord xFRecord = (XFRecord)cellFormat;
            WritableCellFormat writableCellFormat = new WritableCellFormat((CellFormat)xFRecord);
            this.formatRecords.addStyle(writableCellFormat);
            int n = xFRecord.getXFIndex();
            this.xfRecords.put(new Integer(n), writableCellFormat);
            int n2 = xFRecord.getFontIndex();
            this.fonts.put(new Integer(n2), new Integer(writableCellFormat.getFontIndex()));
            int n3 = xFRecord.getFormatRecord();
            this.formats.put(new Integer(n3), new Integer(writableCellFormat.getFormatRecord()));
            return writableCellFormat;
        }
        catch (NumFormatRecordsException numFormatRecordsException) {
            logger.warn("Maximum number of format records exceeded.  Using default format.");
            return WritableWorkbook.NORMAL_STYLE;
        }
    }

    public int getMaxColumnOutlineLevel() {
        return this.maxColumnOutlineLevel;
    }

    public int getMaxRowOutlineLevel() {
        return this.maxRowOutlineLevel;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

