/*
 * Decompiled with CFR 0.152.
 */
package jxl.write.biff;

import jxl.SheetSettings;
import jxl.biff.IntegerHelper;
import jxl.biff.Type;
import jxl.biff.WritableRecordData;

class Window2Record
extends WritableRecordData {
    private byte[] data;

    public Window2Record(SheetSettings sheetSettings) {
        super(Type.WINDOW2);
        int n = 0;
        n |= 0;
        if (sheetSettings.getShowGridLines()) {
            n |= 2;
        }
        n |= 4;
        n |= 0;
        if (sheetSettings.getDisplayZeroValues()) {
            n |= 0x10;
        }
        n |= 0x20;
        n |= 0x80;
        if (sheetSettings.getHorizontalFreeze() != 0 || sheetSettings.getVerticalFreeze() != 0) {
            n |= 8;
            n |= 0x100;
        }
        if (sheetSettings.isSelected()) {
            n |= 0x600;
        }
        if (sheetSettings.getPageBreakPreviewMode()) {
            n |= 0x800;
        }
        this.data = new byte[18];
        IntegerHelper.getTwoBytes(n, this.data, 0);
        IntegerHelper.getTwoBytes(64, this.data, 6);
        IntegerHelper.getTwoBytes(sheetSettings.getPageBreakPreviewMagnification(), this.data, 10);
        IntegerHelper.getTwoBytes(sheetSettings.getNormalMagnification(), this.data, 12);
    }

    public byte[] getData() {
        return this.data;
    }
}

