/*
 * Decompiled with CFR 0.152.
 */
package jxl.write.biff;

import common.Assert;
import common.Logger;
import jxl.CellReferenceHelper;
import jxl.CellType;
import jxl.FormulaCell;
import jxl.Sheet;
import jxl.WorkbookSettings;
import jxl.biff.FormattingRecords;
import jxl.biff.FormulaData;
import jxl.biff.IntegerHelper;
import jxl.biff.Type;
import jxl.biff.WorkbookMethods;
import jxl.biff.formula.ExternalSheet;
import jxl.biff.formula.FormulaException;
import jxl.biff.formula.FormulaParser;
import jxl.write.WritableCell;
import jxl.write.biff.CellValue;
import jxl.write.biff.FormulaRecord;
import jxl.write.biff.SharedStrings;
import jxl.write.biff.WritableSheetImpl;
import jxl.write.biff.WritableWorkbookImpl;

class ReadFormulaRecord
extends CellValue
implements FormulaData {
    private static Logger logger = Logger.getLogger(class$jxl$write$biff$ReadFormulaRecord == null ? (class$jxl$write$biff$ReadFormulaRecord = ReadFormulaRecord.class$("jxl.write.biff.ReadFormulaRecord")) : class$jxl$write$biff$ReadFormulaRecord);
    private FormulaData formula;
    private FormulaParser parser;
    static /* synthetic */ Class class$jxl$write$biff$ReadFormulaRecord;

    protected ReadFormulaRecord(FormulaData formulaData) {
        super(Type.FORMULA, formulaData);
        this.formula = formulaData;
    }

    protected final byte[] getCellData() {
        return super.getData();
    }

    protected byte[] handleFormulaException() {
        byte[] byArray = null;
        byte[] byArray2 = super.getData();
        WritableWorkbookImpl writableWorkbookImpl = this.getSheet().getWorkbook();
        this.parser = new FormulaParser(this.getContents(), writableWorkbookImpl, writableWorkbookImpl, writableWorkbookImpl.getSettings());
        try {
            this.parser.parse();
        }
        catch (FormulaException formulaException) {
            logger.warn(formulaException.getMessage());
            this.parser = new FormulaParser("\"ERROR\"", writableWorkbookImpl, writableWorkbookImpl, writableWorkbookImpl.getSettings());
            try {
                this.parser.parse();
            }
            catch (FormulaException formulaException2) {
                Assert.verify(false);
            }
        }
        byte[] byArray3 = this.parser.getBytes();
        byArray = new byte[byArray3.length + 16];
        IntegerHelper.getTwoBytes(byArray3.length, byArray, 14);
        System.arraycopy(byArray3, 0, byArray, 16, byArray3.length);
        byArray[8] = (byte)(byArray[8] | 2);
        byte[] byArray4 = new byte[byArray2.length + byArray.length];
        System.arraycopy(byArray2, 0, byArray4, 0, byArray2.length);
        System.arraycopy(byArray, 0, byArray4, byArray2.length, byArray.length);
        return byArray4;
    }

    public byte[] getData() {
        byte[] byArray = super.getData();
        byte[] byArray2 = null;
        try {
            byte[] byArray3;
            if (this.parser == null) {
                byArray2 = this.formula.getFormulaData();
            } else {
                byArray3 = this.parser.getBytes();
                byArray2 = new byte[byArray3.length + 16];
                IntegerHelper.getTwoBytes(byArray3.length, byArray2, 14);
                System.arraycopy(byArray3, 0, byArray2, 16, byArray3.length);
            }
            byArray2[8] = (byte)(byArray2[8] | 2);
            byArray3 = new byte[byArray.length + byArray2.length];
            System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
            System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
            return byArray3;
        }
        catch (FormulaException formulaException) {
            logger.warn(CellReferenceHelper.getCellReference(this.getColumn(), this.getRow()) + " " + formulaException.getMessage());
            return this.handleFormulaException();
        }
    }

    public CellType getType() {
        return this.formula.getType();
    }

    public String getContents() {
        return this.formula.getContents();
    }

    public byte[] getFormulaData() throws FormulaException {
        byte[] byArray = this.formula.getFormulaData();
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        byArray2[8] = (byte)(byArray2[8] | 2);
        return byArray2;
    }

    public byte[] getFormulaBytes() throws FormulaException {
        if (this.parser != null) {
            return this.parser.getBytes();
        }
        byte[] byArray = this.getFormulaData();
        byte[] byArray2 = new byte[byArray.length - 16];
        System.arraycopy(byArray, 16, byArray2, 0, byArray2.length);
        return byArray2;
    }

    public WritableCell copyTo(int n, int n2) {
        return new FormulaRecord(n, n2, this);
    }

    void setCellDetails(FormattingRecords formattingRecords, SharedStrings sharedStrings, WritableSheetImpl writableSheetImpl) {
        super.setCellDetails(formattingRecords, sharedStrings, writableSheetImpl);
        writableSheetImpl.getWorkbook().addRCIRCell(this);
    }

    void columnInserted(Sheet sheet, int n, int n2) {
        try {
            if (this.parser == null) {
                byte[] byArray = this.formula.getFormulaData();
                byte[] byArray2 = new byte[byArray.length - 16];
                System.arraycopy(byArray, 16, byArray2, 0, byArray2.length);
                this.parser = new FormulaParser(byArray2, this, this.getSheet().getWorkbook(), this.getSheet().getWorkbook(), this.getSheet().getWorkbookSettings());
                this.parser.parse();
            }
            this.parser.columnInserted(n, n2, sheet == this.getSheet());
        }
        catch (FormulaException formulaException) {
            logger.warn("cannot insert column within formula:  " + formulaException.getMessage());
        }
    }

    void columnRemoved(Sheet sheet, int n, int n2) {
        try {
            if (this.parser == null) {
                byte[] byArray = this.formula.getFormulaData();
                byte[] byArray2 = new byte[byArray.length - 16];
                System.arraycopy(byArray, 16, byArray2, 0, byArray2.length);
                this.parser = new FormulaParser(byArray2, this, this.getSheet().getWorkbook(), this.getSheet().getWorkbook(), this.getSheet().getWorkbookSettings());
                this.parser.parse();
            }
            this.parser.columnRemoved(n, n2, sheet == this.getSheet());
        }
        catch (FormulaException formulaException) {
            logger.warn("cannot remove column within formula:  " + formulaException.getMessage());
        }
    }

    void rowInserted(Sheet sheet, int n, int n2) {
        try {
            if (this.parser == null) {
                byte[] byArray = this.formula.getFormulaData();
                byte[] byArray2 = new byte[byArray.length - 16];
                System.arraycopy(byArray, 16, byArray2, 0, byArray2.length);
                this.parser = new FormulaParser(byArray2, this, this.getSheet().getWorkbook(), this.getSheet().getWorkbook(), this.getSheet().getWorkbookSettings());
                this.parser.parse();
            }
            this.parser.rowInserted(n, n2, sheet == this.getSheet());
        }
        catch (FormulaException formulaException) {
            logger.warn("cannot insert row within formula:  " + formulaException.getMessage());
        }
    }

    void rowRemoved(Sheet sheet, int n, int n2) {
        try {
            if (this.parser == null) {
                byte[] byArray = this.formula.getFormulaData();
                byte[] byArray2 = new byte[byArray.length - 16];
                System.arraycopy(byArray, 16, byArray2, 0, byArray2.length);
                this.parser = new FormulaParser(byArray2, this, this.getSheet().getWorkbook(), this.getSheet().getWorkbook(), this.getSheet().getWorkbookSettings());
                this.parser.parse();
            }
            this.parser.rowRemoved(n, n2, sheet == this.getSheet());
        }
        catch (FormulaException formulaException) {
            logger.warn("cannot remove row within formula:  " + formulaException.getMessage());
        }
    }

    protected FormulaData getReadFormula() {
        return this.formula;
    }

    public String getFormula() throws FormulaException {
        return ((FormulaCell)((Object)this.formula)).getFormula();
    }

    public boolean handleImportedCellReferences(ExternalSheet externalSheet, WorkbookMethods workbookMethods, WorkbookSettings workbookSettings) {
        try {
            if (this.parser == null) {
                byte[] byArray = this.formula.getFormulaData();
                byte[] byArray2 = new byte[byArray.length - 16];
                System.arraycopy(byArray, 16, byArray2, 0, byArray2.length);
                this.parser = new FormulaParser(byArray2, this, externalSheet, workbookMethods, workbookSettings);
                this.parser.parse();
            }
            return this.parser.handleImportedCellReferences();
        }
        catch (FormulaException formulaException) {
            logger.warn("cannot import formula:  " + formulaException.getMessage());
            return false;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

