/*
 * Decompiled with CFR 0.152.
 */
package jxl.write.biff;

import jxl.biff.IntegerHelper;
import jxl.biff.Type;
import jxl.biff.WritableRecordData;

class IndexRecord
extends WritableRecordData {
    private byte[] data;
    private int rows;
    private int bofPosition;
    private int blocks;
    private int dataPos;

    public IndexRecord(int n, int n2, int n3) {
        super(Type.INDEX);
        this.bofPosition = n;
        this.rows = n2;
        this.blocks = n3;
        this.data = new byte[16 + 4 * this.blocks];
        this.dataPos = 16;
    }

    protected byte[] getData() {
        IntegerHelper.getFourBytes(this.rows, this.data, 8);
        return this.data;
    }

    void addBlockPosition(int n) {
        IntegerHelper.getFourBytes(n - this.bofPosition, this.data, this.dataPos);
        this.dataPos += 4;
    }

    void setDataStartPosition(int n) {
        IntegerHelper.getFourBytes(n - this.bofPosition, this.data, 12);
    }
}

