/*
 * Decompiled with CFR 0.152.
 */
package jxl.write.biff;

import common.Logger;
import java.io.IOException;
import java.io.OutputStream;
import jxl.WorkbookSettings;
import jxl.biff.ByteData;
import jxl.write.biff.CompoundFile;
import jxl.write.biff.ExcelDataOutput;
import jxl.write.biff.FileDataOutput;
import jxl.write.biff.JxlWriteException;
import jxl.write.biff.MemoryDataOutput;

public final class File {
    private static Logger logger = Logger.getLogger(class$jxl$write$biff$File == null ? (class$jxl$write$biff$File = File.class$("jxl.write.biff.File")) : class$jxl$write$biff$File);
    private ExcelDataOutput data;
    private int pos;
    private OutputStream outputStream;
    private int initialFileSize;
    private int arrayGrowSize;
    private WorkbookSettings workbookSettings;
    jxl.read.biff.CompoundFile readCompoundFile;
    static /* synthetic */ Class class$jxl$write$biff$File;

    File(OutputStream outputStream, WorkbookSettings workbookSettings, jxl.read.biff.CompoundFile compoundFile) throws IOException {
        this.outputStream = outputStream;
        this.workbookSettings = workbookSettings;
        this.readCompoundFile = compoundFile;
        this.createDataOutput();
    }

    private void createDataOutput() throws IOException {
        if (this.workbookSettings.getUseTemporaryFileDuringWrite()) {
            this.data = new FileDataOutput(this.workbookSettings.getTemporaryFileDuringWriteDirectory());
        } else {
            this.initialFileSize = this.workbookSettings.getInitialFileSize();
            this.arrayGrowSize = this.workbookSettings.getArrayGrowSize();
            this.data = new MemoryDataOutput(this.initialFileSize, this.arrayGrowSize);
        }
    }

    void close(boolean bl) throws IOException, JxlWriteException {
        CompoundFile compoundFile = new CompoundFile(this.data, this.data.getPosition(), this.outputStream, this.readCompoundFile);
        compoundFile.write();
        this.outputStream.flush();
        this.data.close();
        if (bl) {
            this.outputStream.close();
        }
        this.data = null;
        if (!this.workbookSettings.getGCDisabled()) {
            System.gc();
        }
    }

    public void write(ByteData byteData) throws IOException {
        byte[] byArray = byteData.getBytes();
        this.data.write(byArray);
    }

    int getPos() throws IOException {
        return this.data.getPosition();
    }

    void setData(byte[] byArray, int n) throws IOException {
        this.data.setData(byArray, n);
    }

    public void setOutputFile(OutputStream outputStream) throws IOException {
        if (this.data != null) {
            logger.warn("Rewriting a workbook with non-empty data");
        }
        this.outputStream = outputStream;
        this.createDataOutput();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

