/*
 * Decompiled with CFR 0.152.
 */
package jxl.write.biff;

import java.util.ArrayList;
import java.util.Iterator;
import jxl.biff.IntegerHelper;
import jxl.biff.Type;
import jxl.biff.WritableRecordData;

class DBCellRecord
extends WritableRecordData {
    private int rowPos;
    private int cellOffset;
    private ArrayList cellRowPositions;
    private int position;

    public DBCellRecord(int n) {
        super(Type.DBCELL);
        this.rowPos = n;
        this.cellRowPositions = new ArrayList(10);
    }

    void setCellOffset(int n) {
        this.cellOffset = n;
    }

    void addCellRowPosition(int n) {
        this.cellRowPositions.add(new Integer(n));
    }

    void setPosition(int n) {
        this.position = n;
    }

    protected byte[] getData() {
        byte[] byArray = new byte[4 + 2 * this.cellRowPositions.size()];
        IntegerHelper.getFourBytes(this.position - this.rowPos, byArray, 0);
        int n = 4;
        int n2 = this.cellOffset;
        Iterator iterator = this.cellRowPositions.iterator();
        while (iterator.hasNext()) {
            int n3 = (Integer)iterator.next();
            IntegerHelper.getTwoBytes(n3 - n2, byArray, n);
            n2 = n3;
            n += 2;
        }
        return byArray;
    }
}

